/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical.resolver;

import com.google.common.util.concurrent.FutureCallback;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.DiagnosticSupport;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.IImplicitDependencies;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.IResolutionContext;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.IResourceDependencyRemoteResolver;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.RemoteMonitoredProxyCreationListener;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.RemoteResolveComputation;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ResolutionUtil;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ResourceComputationScheduler;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ResourceDependencyLocalResolver;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.SynchronizedResourceSet;
import org.eclipse.emf.compare.ide.ui.internal.util.ThreadSafeProgressMonitor;

public class ResourceDependencyRemoteResolver
implements IResourceDependencyRemoteResolver {
    private static final Logger LOGGER = Logger.getLogger(ResourceDependencyLocalResolver.class);
    protected final ResourceComputationScheduler<URI> scheduler;
    private final IImplicitDependencies implicitDependencies;

    public ResourceDependencyRemoteResolver(IResolutionContext context) {
        this.implicitDependencies = context.getImplicitDependencies();
        this.scheduler = context.getScheduler();
    }

    public void demandRemoteResolve(SynchronizedResourceSet resourceSet, URI uri, DiagnosticSupport diagnostic, ThreadSafeProgressMonitor tspm) {
        if (ResolutionUtil.isInterruptedOrCanceled((IProgressMonitor)tspm)) {
            this.scheduler.demandShutdown();
            return;
        }
        for (URI currentUri : this.implicitDependencies.of(uri, resourceSet.getURIConverter())) {
            this.scheduler.scheduleComputation(this.getRemoteResolveComputation(resourceSet, currentUri, diagnostic, tspm));
        }
    }

    public RemoteResolveComputation getRemoteResolveComputation(SynchronizedResourceSet resourceSet, URI uri, final DiagnosticSupport diagnostic, final ThreadSafeProgressMonitor tspm) {
        return new RemoteResolveComputation(this.scheduler, diagnostic, resourceSet, uri, new FutureCallback<Object>(){

            public void onSuccess(Object o) {
                if (!ResolutionUtil.isInterruptedOrCanceled((IProgressMonitor)tspm)) {
                    tspm.worked(1);
                }
            }

            public void onFailure(Throwable t) {
                if (!ResolutionUtil.isInterruptedOrCanceled((IProgressMonitor)tspm)) {
                    tspm.worked(1);
                    diagnostic.merge(BasicDiagnostic.toDiagnostic((Throwable)t));
                }
            }
        }, tspm);
    }

    public SynchronizedResourceSet getResourceSetForRemoteResolution(DiagnosticSupport diagnostic, ThreadSafeProgressMonitor tspm) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"INSTANTIATING SynchronizedResourceSet for remote resolution.");
        }
        SynchronizedResourceSet resourceSet = new SynchronizedResourceSet(new RemoteMonitoredProxyCreationListener(tspm, this, diagnostic));
        return resourceSet;
    }
}

