/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical.resolver;

import com.google.common.eventbus.EventBus;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.graph.IGraph;
import org.eclipse.emf.compare.graph.IGraphView;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.DefaultResolutionContext;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.DependencyGraphUpdater;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.IResolutionContext;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.LocalModelResolution;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.LocalModelsResolution;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ModelResourceListener;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ModelsResolution;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ResourceComputationScheduler;
import org.eclipse.emf.compare.ide.ui.logical.AbstractModelResolver;
import org.eclipse.emf.compare.ide.ui.logical.IStorageProviderAccessor;
import org.eclipse.emf.compare.ide.ui.logical.SynchronizationModel;
import org.eclipse.emf.compare.ide.utils.StorageTraversal;
import org.eclipse.emf.compare.internal.utils.ReadOnlyGraph;
import org.eclipse.emf.compare.rcp.graph.IGraphConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadedModelResolver
extends AbstractModelResolver
implements IGraphConsumer {
    private IResolutionContext context;
    private IGraph<URI> graph;

    public IGraphView<URI> getGraphView() {
        return ReadOnlyGraph.toReadOnlyGraph(this.graph);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.graph == null) {
            throw new IllegalStateException();
        }
        EventBus eventBus = new EventBus();
        this.context = this.createContext(eventBus, this.graph);
        this.context.initialize();
    }

    @Override
    public void dispose() {
        this.context.dispose();
        super.dispose();
    }

    protected DefaultResolutionContext createContext(EventBus eventBus, IGraph<URI> aGraph) {
        return new DefaultResolutionContext(eventBus, aGraph, new DependencyGraphUpdater<URI>(aGraph, eventBus), new ResourceComputationScheduler<URI>(), new ModelResourceListener());
    }

    @Override
    public boolean canResolve(IStorage sourceStorage) {
        return true;
    }

    @Override
    public StorageTraversal resolveLocalModel(IResource start, IProgressMonitor monitor) throws InterruptedException {
        LocalModelResolution comp = new LocalModelResolution(this.context, monitor);
        return comp.run(start);
    }

    @Override
    public SynchronizationModel resolveLocalModels(IResource left, IResource right, IResource origin, IProgressMonitor monitor) throws InterruptedException {
        LocalModelsResolution comp = new LocalModelsResolution(this.context, left, right, origin, monitor);
        return comp.run();
    }

    @Override
    public SynchronizationModel resolveModels(IStorageProviderAccessor storageAccessor, IStorage left, IStorage right, IStorage origin, IProgressMonitor monitor) throws InterruptedException {
        ModelsResolution comp = new ModelsResolution(this.context, monitor, storageAccessor, left, right, origin);
        return comp.run();
    }

    public String getId() {
        return "org.eclipse.emf.compare.resources.graph";
    }

    public void setGraph(IGraph<URI> graph) {
        this.graph = graph;
    }
}

