/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.command.ICompareCopyCommand;
import org.eclipse.emf.compare.domain.impl.EMFCompareEditingDomain;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.MergeAction;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.MergeNonConflictingRunnable;
import org.eclipse.emf.compare.internal.domain.IMergeAllNonConflictingRunnable;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IEMFCompareConfiguration;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class MergeAllNonConflictingAction
extends MergeAction {
    private Comparison comparison;
    private IMergeAllNonConflictingRunnable runnable;

    public MergeAllNonConflictingAction(IEMFCompareConfiguration compareConfiguration, Comparison comparison, IMerger.Registry mergerRegistry, MergeMode mode) {
        super(compareConfiguration, mergerRegistry, mode, null);
        this.comparison = comparison;
        this.runnable = new MergeNonConflictingRunnable(compareConfiguration.isLeftEditable(), compareConfiguration.isRightEditable(), mode);
    }

    protected void initToolTipAndImage(MergeMode mode) {
        switch (mode) {
            case LEFT_TO_RIGHT: {
                this.setToolTipText(EMFCompareIDEUIMessages.getString("merged.all.to.right.tooltip"));
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/merge_all_to_right.gif"));
                break;
            }
            case RIGHT_TO_LEFT: {
                this.setToolTipText(EMFCompareIDEUIMessages.getString("merged.all.to.left.tooltip"));
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/merge_all_to_left.gif"));
                break;
            }
            case ACCEPT: {
                this.setToolTipText(EMFCompareIDEUIMessages.getString("accept.all.changes.tooltip"));
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/accept_all_changes.gif"));
                break;
            }
            case REJECT: {
                this.setToolTipText(EMFCompareIDEUIMessages.getString("reject.all.changes.tooltip"));
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/reject_all_changes.gif"));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public void setComparison(Comparison comparison) {
        this.comparison = comparison;
        this.clearCache();
        this.setEnabled(comparison != null);
    }

    public void run() {
        if (this.editingDomain instanceof EMFCompareEditingDomain) {
            ICompareCopyCommand mergeCommand = ((EMFCompareEditingDomain)this.editingDomain).createCopyAllNonConflictingCommand(this.comparison, this.isLeftToRight(), this.mergerRegistry, this.runnable);
            this.editingDomain.getCommandStack().execute((Command)mergeCommand);
        } else {
            EMFCompareIDEUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.compare.ide.ui", "Couldn't create the copy all command."));
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return true;
    }
}

