/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.cpp.profile.RTCppProperties;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum OperationKind implements Enumerator
{
    MEMBER(0, "Member", "Member"),
    FRIEND(1, "Friend", "Friend"),
    GLOBAL(2, "Global", "Global");

    public static final int MEMBER_VALUE = 0;
    public static final int FRIEND_VALUE = 1;
    public static final int GLOBAL_VALUE = 2;
    private static final OperationKind[] VALUES_ARRAY;
    public static final List<OperationKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new OperationKind[]{MEMBER, FRIEND, GLOBAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static OperationKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OperationKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OperationKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OperationKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OperationKind get(int value) {
        switch (value) {
            case 0: {
                return MEMBER;
            }
            case 1: {
                return FRIEND;
            }
            case 2: {
                return GLOBAL;
            }
        }
        return null;
    }

    private OperationKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

