/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFix;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.text.edits.TextEditGroup;

public class ControlStatementsFix
extends CompilationUnitRewriteOperationsFix {
    public static ControlStatementsFix[] createRemoveBlockFix(CompilationUnit compilationUnit, ASTNode node) {
        RemoveBlockOperation op;
        if (!(node instanceof Statement)) {
            return null;
        }
        Statement statement = (Statement)node;
        if (statement instanceof Block) {
            Block block = (Block)statement;
            if (block.statements().size() != 1) {
                return null;
            }
            ASTNode parent = block.getParent();
            if (!(parent instanceof Statement)) {
                return null;
            }
            statement = (Statement)parent;
        }
        if (statement instanceof IfStatement) {
            RemoveBlockOperation op2;
            ArrayList<ControlStatementsFix> result = new ArrayList<ControlStatementsFix>();
            ArrayList<RemoveBlockOperation> removeAllList = new ArrayList<RemoveBlockOperation>();
            IfElseIterator iter = new IfElseIterator((IfStatement)statement);
            IfStatement item = null;
            while (iter.hasNext()) {
                item = iter.next();
                if (!RemoveBlockOperation.satisfiesQuickAssistPrecondition((Statement)item, IfStatement.THEN_STATEMENT_PROPERTY)) continue;
                op2 = new RemoveBlockOperation((Statement)item, IfStatement.THEN_STATEMENT_PROPERTY);
                removeAllList.add(op2);
                if (item != statement) continue;
                result.add(new ControlStatementsFix(FixMessages.ControlStatementsFix_removeIfBlock_proposalDescription, compilationUnit, new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[]{op2}));
            }
            if (RemoveBlockOperation.satisfiesQuickAssistPrecondition(item, IfStatement.ELSE_STATEMENT_PROPERTY)) {
                op2 = new RemoveBlockOperation((Statement)item, IfStatement.ELSE_STATEMENT_PROPERTY);
                removeAllList.add(op2);
                if (item == statement) {
                    result.add(new ControlStatementsFix(FixMessages.ControlStatementsFix_removeElseBlock_proposalDescription, compilationUnit, new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[]{op2}));
                }
            }
            if (removeAllList.size() > 1) {
                CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[] allConvert = removeAllList.toArray(new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[removeAllList.size()]);
                result.add(new ControlStatementsFix(FixMessages.ControlStatementsFix_removeIfElseBlock_proposalDescription, compilationUnit, allConvert));
            }
            return result.toArray(new ControlStatementsFix[result.size()]);
        }
        if (statement instanceof WhileStatement) {
            if (RemoveBlockOperation.satisfiesQuickAssistPrecondition(statement, WhileStatement.BODY_PROPERTY)) {
                op = new RemoveBlockOperation(statement, WhileStatement.BODY_PROPERTY);
                return new ControlStatementsFix[]{new ControlStatementsFix(FixMessages.ControlStatementsFix_removeBrackets_proposalDescription, compilationUnit, new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[]{op})};
            }
        } else if (statement instanceof ForStatement) {
            if (RemoveBlockOperation.satisfiesQuickAssistPrecondition(statement, ForStatement.BODY_PROPERTY)) {
                op = new RemoveBlockOperation(statement, ForStatement.BODY_PROPERTY);
                return new ControlStatementsFix[]{new ControlStatementsFix(FixMessages.ControlStatementsFix_removeBrackets_proposalDescription, compilationUnit, new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[]{op})};
            }
        } else if (statement instanceof EnhancedForStatement) {
            if (RemoveBlockOperation.satisfiesQuickAssistPrecondition(statement, EnhancedForStatement.BODY_PROPERTY)) {
                op = new RemoveBlockOperation(statement, EnhancedForStatement.BODY_PROPERTY);
                return new ControlStatementsFix[]{new ControlStatementsFix(FixMessages.ControlStatementsFix_removeBrackets_proposalDescription, compilationUnit, new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[]{op})};
            }
        } else if (statement instanceof DoStatement && RemoveBlockOperation.satisfiesQuickAssistPrecondition(statement, DoStatement.BODY_PROPERTY)) {
            op = new RemoveBlockOperation(statement, DoStatement.BODY_PROPERTY);
            return new ControlStatementsFix[]{new ControlStatementsFix(FixMessages.ControlStatementsFix_removeBrackets_proposalDescription, compilationUnit, new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[]{op})};
        }
        return null;
    }

    public static ICleanUpFix createCleanUp(CompilationUnit compilationUnit, boolean convertSingleStatementToBlock, boolean removeUnnecessaryBlock, boolean removeUnnecessaryBlockContainingReturnOrThrow) {
        if (!(convertSingleStatementToBlock || removeUnnecessaryBlock || removeUnnecessaryBlockContainingReturnOrThrow)) {
            return null;
        }
        ArrayList<CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation> operations = new ArrayList<CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation>();
        ControlStatementFinder finder = new ControlStatementFinder(convertSingleStatementToBlock, removeUnnecessaryBlock, removeUnnecessaryBlockContainingReturnOrThrow, operations);
        compilationUnit.accept((ASTVisitor)finder);
        if (operations.isEmpty()) {
            return null;
        }
        CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[] ops = operations.toArray(new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[operations.size()]);
        return new ControlStatementsFix(FixMessages.ControlStatementsFix_change_name, compilationUnit, ops);
    }

    protected ControlStatementsFix(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    private static final class AddBlockOperation
    extends CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation {
        private final ChildPropertyDescriptor fBodyProperty;
        private final Statement fBody;
        private final Statement fControlStatement;

        public AddBlockOperation(ChildPropertyDescriptor bodyProperty, Statement body, Statement controlStatement) {
            this.fBodyProperty = bodyProperty;
            this.fBody = body;
            this.fControlStatement = controlStatement;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModel model) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            String label = this.fBodyProperty == IfStatement.THEN_STATEMENT_PROPERTY ? FixMessages.CodeStyleFix_ChangeIfToBlock_desription : (this.fBodyProperty == IfStatement.ELSE_STATEMENT_PROPERTY ? FixMessages.CodeStyleFix_ChangeElseToBlock_description : FixMessages.CodeStyleFix_ChangeControlToBlock_description);
            TextEditGroup group = this.createTextEditGroup(label, cuRewrite);
            ASTNode moveTarget = rewrite.createMoveTarget((ASTNode)this.fBody);
            Block replacingBody = cuRewrite.getRoot().getAST().newBlock();
            replacingBody.statements().add(moveTarget);
            rewrite.set((ASTNode)this.fControlStatement, (StructuralPropertyDescriptor)this.fBodyProperty, (Object)replacingBody, group);
        }
    }

    private static final class ControlStatementFinder
    extends GenericVisitor {
        private final List<CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation> fResult;
        private final boolean fFindControlStatementsWithoutBlock;
        private final boolean fRemoveUnnecessaryBlocks;
        private final boolean fRemoveUnnecessaryBlocksOnlyWhenReturnOrThrow;

        public ControlStatementFinder(boolean findControlStatementsWithoutBlock, boolean removeUnnecessaryBlocks, boolean removeUnnecessaryBlocksOnlyWhenReturnOrThrow, List<CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation> resultingCollection) {
            this.fFindControlStatementsWithoutBlock = findControlStatementsWithoutBlock;
            this.fRemoveUnnecessaryBlocks = removeUnnecessaryBlocks;
            this.fRemoveUnnecessaryBlocksOnlyWhenReturnOrThrow = removeUnnecessaryBlocksOnlyWhenReturnOrThrow;
            this.fResult = resultingCollection;
        }

        @Override
        public boolean visit(DoStatement node) {
            this.handle(node.getBody(), DoStatement.BODY_PROPERTY);
            return super.visit(node);
        }

        @Override
        public boolean visit(ForStatement node) {
            this.handle(node.getBody(), ForStatement.BODY_PROPERTY);
            return super.visit(node);
        }

        @Override
        public boolean visit(EnhancedForStatement node) {
            this.handle(node.getBody(), EnhancedForStatement.BODY_PROPERTY);
            return super.visit(node);
        }

        @Override
        public boolean visit(IfStatement statement) {
            this.handle(statement.getThenStatement(), IfStatement.THEN_STATEMENT_PROPERTY);
            Statement elseStatement = statement.getElseStatement();
            if (elseStatement != null && !(elseStatement instanceof IfStatement)) {
                this.handle(elseStatement, IfStatement.ELSE_STATEMENT_PROPERTY);
            }
            return super.visit(statement);
        }

        @Override
        public boolean visit(WhileStatement node) {
            this.handle(node.getBody(), WhileStatement.BODY_PROPERTY);
            return super.visit(node);
        }

        private void handle(Statement body, ChildPropertyDescriptor bodyProperty) {
            if ((body.getFlags() & 8) != 0) {
                return;
            }
            Statement parent = (Statement)body.getParent();
            if ((parent.getFlags() & 8) != 0) {
                return;
            }
            if (this.fRemoveUnnecessaryBlocksOnlyWhenReturnOrThrow) {
                if (!(body instanceof Block)) {
                    if (body.getNodeType() != 25 && body.getNodeType() != 41 && body.getNodeType() != 53) {
                        this.fResult.add(new AddBlockOperation(bodyProperty, body, parent));
                    }
                } else if (RemoveBlockOperation.satisfiesCleanUpPrecondition(parent, bodyProperty, true)) {
                    this.fResult.add(new RemoveBlockOperation(parent, bodyProperty));
                }
            } else if (this.fFindControlStatementsWithoutBlock) {
                if (!(body instanceof Block)) {
                    this.fResult.add(new AddBlockOperation(bodyProperty, body, parent));
                }
            } else if (this.fRemoveUnnecessaryBlocks && RemoveBlockOperation.satisfiesCleanUpPrecondition(parent, bodyProperty, false)) {
                this.fResult.add(new RemoveBlockOperation(parent, bodyProperty));
            }
        }
    }

    private static class IfElseIterator {
        private IfStatement fCursor;

        public IfElseIterator(IfStatement item) {
            this.fCursor = this.findStart(item);
        }

        public IfStatement next() {
            if (!this.hasNext()) {
                return null;
            }
            IfStatement result = this.fCursor;
            this.fCursor = this.fCursor.getElseStatement() instanceof IfStatement ? (IfStatement)this.fCursor.getElseStatement() : null;
            return result;
        }

        public boolean hasNext() {
            return this.fCursor != null;
        }

        private IfStatement findStart(IfStatement item) {
            while (item.getLocationInParent() == IfStatement.ELSE_STATEMENT_PROPERTY) {
                item = (IfStatement)item.getParent();
            }
            return item;
        }
    }

    static class RemoveBlockOperation
    extends CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation {
        private final Statement fStatement;
        private final ChildPropertyDescriptor fChild;

        public RemoveBlockOperation(Statement controlStatement, ChildPropertyDescriptor child) {
            this.fStatement = controlStatement;
            this.fChild = child;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModel model) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            Block block = (Block)this.fStatement.getStructuralProperty((StructuralPropertyDescriptor)this.fChild);
            Statement statement = (Statement)block.statements().get(0);
            Statement moveTarget = (Statement)rewrite.createMoveTarget((ASTNode)statement);
            TextEditGroup group = this.createTextEditGroup(FixMessages.ControlStatementsFix_removeBrackets_proposalDescription, cuRewrite);
            rewrite.set((ASTNode)this.fStatement, (StructuralPropertyDescriptor)this.fChild, (Object)moveTarget, group);
        }

        public static boolean satisfiesCleanUpPrecondition(Statement controlStatement, ChildPropertyDescriptor childDescriptor, boolean onlyReturnAndThrows) {
            return RemoveBlockOperation.satisfiesPrecondition(controlStatement, childDescriptor, onlyReturnAndThrows, true);
        }

        public static boolean satisfiesQuickAssistPrecondition(Statement controlStatement, ChildPropertyDescriptor childDescriptor) {
            return RemoveBlockOperation.satisfiesPrecondition(controlStatement, childDescriptor, false, false);
        }

        private static boolean satisfiesPrecondition(Statement controlStatement, ChildPropertyDescriptor childDescriptor, boolean onlyReturnAndThrows, boolean cleanUpCheck) {
            Object child = controlStatement.getStructuralProperty((StructuralPropertyDescriptor)childDescriptor);
            if (!(child instanceof Block)) {
                return false;
            }
            Block block = (Block)child;
            List list = block.statements();
            if (list.size() != 1) {
                return false;
            }
            ASTNode singleStatement = (ASTNode)list.get(0);
            if (onlyReturnAndThrows && !(singleStatement instanceof ReturnStatement) && !(singleStatement instanceof ThrowStatement)) {
                return false;
            }
            if (controlStatement instanceof IfStatement) {
                if (((IfStatement)controlStatement).getThenStatement() != child) {
                    return true;
                }
                IfStatement ifStatement = (IfStatement)controlStatement;
                if (ifStatement.getElseStatement() == null) {
                    return true;
                }
                return !RemoveBlockOperation.hasUnblockedIf((Statement)singleStatement, onlyReturnAndThrows, cleanUpCheck);
            }
            if (!RemoveBlockOperation.hasUnblockedIf((Statement)singleStatement, onlyReturnAndThrows, cleanUpCheck)) {
                return true;
            }
            Statement currentChild = controlStatement;
            ASTNode parent = currentChild.getParent();
            while (true) {
                Statement body = null;
                if (parent instanceof IfStatement) {
                    body = ((IfStatement)parent).getThenStatement();
                    if (body == currentChild && ((IfStatement)parent).getElseStatement() != null) {
                        return false;
                    }
                } else if (parent instanceof WhileStatement) {
                    body = ((WhileStatement)parent).getBody();
                } else if (parent instanceof DoStatement) {
                    body = ((DoStatement)parent).getBody();
                } else if (parent instanceof ForStatement) {
                    body = ((ForStatement)parent).getBody();
                } else if (parent instanceof EnhancedForStatement) {
                    body = ((EnhancedForStatement)parent).getBody();
                } else {
                    return true;
                }
                if (body != currentChild) {
                    return true;
                }
                currentChild = parent;
                parent = currentChild.getParent();
            }
        }

        private static boolean hasUnblockedIf(Statement p, boolean onlyReturnAndThrows, boolean cleanUpCheck) {
            while (!(p instanceof IfStatement)) {
                ChildPropertyDescriptor childD = null;
                if (p instanceof WhileStatement) {
                    childD = WhileStatement.BODY_PROPERTY;
                } else if (p instanceof ForStatement) {
                    childD = ForStatement.BODY_PROPERTY;
                } else if (p instanceof EnhancedForStatement) {
                    childD = EnhancedForStatement.BODY_PROPERTY;
                } else if (p instanceof DoStatement) {
                    childD = DoStatement.BODY_PROPERTY;
                } else {
                    return false;
                }
                Statement body = (Statement)p.getStructuralProperty((StructuralPropertyDescriptor)childD);
                if (body instanceof Block) {
                    if (!cleanUpCheck) {
                        return false;
                    }
                    if (!RemoveBlockOperation.satisfiesPrecondition(p, childD, onlyReturnAndThrows, cleanUpCheck)) {
                        return false;
                    }
                    p = (Statement)((Block)body).statements().get(0);
                    continue;
                }
                p = body;
            }
            return true;
        }
    }
}

