/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.structure.UseSuperTypeProcessor;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class UseSupertypeWizard
extends RefactoringWizard {
    static final String DIALOG_SETTING_SECTION = "UseSupertypeWizard";
    private final UseSuperTypeProcessor fProcessor;

    public UseSupertypeWizard(UseSuperTypeProcessor processor, Refactoring ref) {
        super(ref, 4);
        this.fProcessor = processor;
        this.setDefaultPageTitle(RefactoringMessages.UseSupertypeWizard_Use_Super_Type_Where_Possible);
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new UseSupertypeInputPage(this.fProcessor));
    }

    private static class UseSupertypeInputPage
    extends UserInputWizardPage {
        private static final String REWRITE_INSTANCEOF = "rewriteInstanceOf";
        public static final String PAGE_NAME = "UseSupertypeInputPage";
        private TreeViewer fTreeViewer;
        private final Map<IType, Integer> fFileCount = new HashMap<IType, Integer>(2);
        private static final String MESSAGE = RefactoringMessages.UseSupertypeInputPage_Select_supertype;
        private JavaElementLabelProvider fLabelProvider;
        private IDialogSettings fSettings;
        private UseSuperTypeProcessor fProcessor;

        public UseSupertypeInputPage(UseSuperTypeProcessor processor) {
            super(PAGE_NAME);
            this.fProcessor = processor;
            this.setMessage(MESSAGE);
        }

        private void loadSettings() {
            this.fSettings = this.getDialogSettings().getSection(UseSupertypeWizard.DIALOG_SETTING_SECTION);
            if (this.fSettings == null) {
                this.fSettings = this.getDialogSettings().addNewSection(UseSupertypeWizard.DIALOG_SETTING_SECTION);
                this.fSettings.put(REWRITE_INSTANCEOF, false);
            }
            this.getUseSupertypeProcessor().setInstanceOf(this.fSettings.getBoolean(REWRITE_INSTANCEOF));
        }

        private UseSuperTypeProcessor getUseSupertypeProcessor() {
            return this.fProcessor;
        }

        public void createControl(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            this.loadSettings();
            Composite composite = new Composite(parent, 0);
            this.setControl((Control)composite);
            composite.setLayout((Layout)new GridLayout());
            Label label = new Label(composite, 0);
            label.setText(Messages.format(RefactoringMessages.UseSupertypeInputPage_Select_supertype_to_use, JavaElementLabels.getElementLabel((IJavaElement)this.getUseSupertypeProcessor().getSubType(), 262144L)));
            label.setLayoutData((Object)new GridData());
            this.addTreeViewer(composite);
            final Button checkbox = new Button(composite, 32);
            checkbox.setText(RefactoringMessages.UseSupertypeInputPage_Use_in_instanceof);
            checkbox.setLayoutData((Object)new GridData());
            checkbox.setSelection(this.getUseSupertypeProcessor().isInstanceOf());
            checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    UseSupertypeInputPage.this.getUseSupertypeProcessor().setInstanceOf(checkbox.getSelection());
                    UseSupertypeInputPage.this.fSettings.put(UseSupertypeInputPage.REWRITE_INSTANCEOF, checkbox.getSelection());
                    UseSupertypeInputPage.this.setMessage(MESSAGE);
                    UseSupertypeInputPage.this.setPageComplete(true);
                    UseSupertypeInputPage.this.fFileCount.clear();
                    UseSupertypeInputPage.this.fTreeViewer.refresh();
                }
            });
            Dialog.applyDialogFont((Control)composite);
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.jdt.ui.use_supertype_wizard_page_context");
        }

        private void addTreeViewer(Composite composite) {
            this.fTreeViewer = new TreeViewer(composite, 2820);
            Tree tree = this.fTreeViewer.getTree();
            GridData data = new GridData(1808);
            data.heightHint = this.convertHeightInCharsToPixels(12);
            tree.setLayoutData((Object)data);
            this.fLabelProvider = new UseSupertypeLabelProvider(this.fFileCount);
            this.fTreeViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
            this.fTreeViewer.setContentProvider((IContentProvider)new UseSupertypeContentProvider());
            this.fTreeViewer.setComparator(new ViewerComparator(){

                public boolean isSorterProperty(Object element, String property) {
                    return true;
                }

                public int compare(Viewer viewer, Object first, Object second) {
                    IType type1 = (IType)first;
                    IType type2 = (IType)second;
                    try {
                        int kind2;
                        int kind1 = type1.isInterface() ? 1 : 0;
                        int n = kind2 = type2.isInterface() ? 1 : 0;
                        if (kind1 - kind2 != 0) {
                            return kind1 - kind2;
                        }
                    }
                    catch (JavaModelException exception) {
                        JavaPlugin.log(exception);
                    }
                    return this.getComparator().compare(type1.getElementName(), type2.getElementName());
                }
            });
            this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                    if (new Integer(0).equals(UseSupertypeInputPage.this.fFileCount.get(ss.getFirstElement()))) {
                        UseSupertypeInputPage.this.setMessage(RefactoringMessages.UseSupertypeInputPage_No_updates, 1);
                        UseSupertypeInputPage.this.setPageComplete(false);
                    } else {
                        UseSupertypeInputPage.this.setMessage(MESSAGE);
                        UseSupertypeInputPage.this.setPageComplete(true);
                    }
                    UseSupertypeInputPage.this.fTreeViewer.refresh();
                }
            });
            try {
                this.fTreeViewer.setInput((Object)SuperTypeHierarchyCache.getTypeHierarchy(this.getUseSupertypeProcessor().getSubType()));
            }
            catch (JavaModelException exception) {
                JavaPlugin.log(exception);
            }
            this.fTreeViewer.expandAll();
            TreeItem[] items = tree.getItems();
            if (items.length > 0) {
                tree.setSelection(new TreeItem[]{items[0]});
            }
        }

        public IWizardPage getNextPage() {
            this.initializeRefactoring();
            IWizardPage nextPage = super.getNextPage();
            this.updateUpdateLabels();
            return nextPage;
        }

        private void updateUpdateLabels() {
            IType selectedType = this.getSelectedSupertype();
            int count = this.getUseSupertypeProcessor().getChanges();
            this.fFileCount.put(selectedType, new Integer(count));
            if (count == 0) {
                this.setMessage(RefactoringMessages.UseSupertypeInputPage_No_updates, 1);
                this.setPageComplete(false);
            }
            this.fTreeViewer.refresh();
            if (this.noSupertypeCanBeUsed()) {
                this.setMessage(RefactoringMessages.UseSupertypeWizard_10, 1);
                this.setPageComplete(false);
            }
        }

        private boolean noSupertypeCanBeUsed() {
            return this.fTreeViewer.getTree().getItemCount() == this.countFilesWithValue(0);
        }

        private int countFilesWithValue(int i) {
            int count = 0;
            Iterator<IType> iter = this.fFileCount.keySet().iterator();
            while (iter.hasNext()) {
                if (this.fFileCount.get(iter.next()) != i) continue;
                ++count;
            }
            return count;
        }

        private IType getSelectedSupertype() {
            IStructuredSelection ss = (IStructuredSelection)this.fTreeViewer.getSelection();
            return (IType)ss.getFirstElement();
        }

        public boolean performFinish() {
            this.initializeRefactoring();
            boolean superFinish = super.performFinish();
            if (!superFinish) {
                return false;
            }
            int count = this.getUseSupertypeProcessor().getChanges();
            if (count == 0) {
                this.updateUpdateLabels();
                return false;
            }
            return superFinish;
        }

        private void initializeRefactoring() {
            IStructuredSelection ss = (IStructuredSelection)this.fTreeViewer.getSelection();
            this.getUseSupertypeProcessor().setSuperType((IType)ss.getFirstElement());
        }

        public void dispose() {
            this.fTreeViewer = null;
            this.fFileCount.clear();
            this.fLabelProvider = null;
            super.dispose();
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible && this.fTreeViewer != null) {
                this.fTreeViewer.getTree().setFocus();
            }
        }

        private class UseSupertypeContentProvider
        implements ITreeContentProvider {
            private ITypeHierarchy fHierarchy;

            private UseSupertypeContentProvider() {
            }

            public Object[] getChildren(Object element) {
                if (element instanceof ITypeHierarchy) {
                    return this.getElements(element);
                }
                return this.getDirectSuperTypes((IType)element).toArray();
            }

            public Set<IType> getDirectSuperTypes(IType type) {
                HashSet<IType> result = new HashSet<IType>();
                IType superclass = this.fHierarchy.getSuperclass(type);
                if (superclass != null) {
                    result.add(superclass);
                }
                IType[] superInterface = this.fHierarchy.getSuperInterfaces(type);
                int i = 0;
                while (i < superInterface.length) {
                    result.add(superInterface[i]);
                    ++i;
                }
                try {
                    if (type.isInterface()) {
                        IType found = type.getJavaProject().findType("java.lang.Object");
                        result.add(found);
                    }
                }
                catch (JavaModelException exception) {
                    JavaPlugin.log(exception);
                }
                return result;
            }

            public Object[] getElements(Object element) {
                if (element instanceof ITypeHierarchy) {
                    return this.getChildren(((ITypeHierarchy)element).getType());
                }
                return new Object[0];
            }

            public boolean hasChildren(Object element) {
                return this.getChildren(element).length > 0;
            }

            public Object getParent(Object element) {
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.fHierarchy = newInput instanceof ITypeHierarchy ? (ITypeHierarchy)newInput : null;
            }
        }

        private static class UseSupertypeLabelProvider
        extends JavaElementLabelProvider {
            private final Map<IType, Integer> fFileCount;

            private UseSupertypeLabelProvider(Map<IType, Integer> fileCount) {
                this.fFileCount = fileCount;
            }

            @Override
            public String getText(Object element) {
                String superText = super.getText(element);
                if (!this.fFileCount.containsKey(element)) {
                    return superText;
                }
                int count = this.fFileCount.get(element);
                if (count == 0) {
                    Object[] keys = new String[]{superText};
                    return Messages.format(RefactoringMessages.UseSupertypeInputPage_no_possible_updates, keys);
                }
                if (count == 1) {
                    Object[] keys = new String[]{superText};
                    return Messages.format(RefactoringMessages.UseSupertypeInputPage_updates_possible_in_file, keys);
                }
                Object[] keys = new String[]{superText, String.valueOf(count)};
                return Messages.format(RefactoringMessages.UseSupertypeInputPage_updates_possible_in_files, keys);
            }
        }
    }
}

