/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;

@Deprecated
public class JavaElementContentProvider
extends StandardJavaElementContentProvider
implements IElementChangedListener {
    protected TreeViewer fViewer;
    protected Object fInput;

    @Override
    public void dispose() {
        super.dispose();
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        this.fViewer = (TreeViewer)viewer;
        if (oldInput == null && newInput != null) {
            JavaCore.addElementChangedListener((IElementChangedListener)this);
        } else if (oldInput != null && newInput == null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this);
        }
        this.fInput = newInput;
    }

    public JavaElementContentProvider() {
    }

    public JavaElementContentProvider(boolean provideMembers, boolean provideWorkingCopy) {
        super(provideMembers, provideWorkingCopy);
    }

    public void elementChanged(ElementChangedEvent event) {
        try {
            this.processDelta(event.getDelta());
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
    }

    protected void processDelta(IJavaElementDelta delta) throws JavaModelException {
        IJavaElementDelta[] affectedChildren;
        Object parent;
        int kind = delta.getKind();
        int flags = delta.getFlags();
        IJavaElement element = delta.getElement();
        if (element instanceof ICompilationUnit) {
            if (!this.getProvideWorkingCopy()) {
                return;
            }
            ICompilationUnit cu = (ICompilationUnit)element;
            if (!JavaModelUtil.isPrimary(cu) || !this.isOnClassPath((ICompilationUnit)element)) {
                return;
            }
        }
        if ((flags & 0x400) != 0 || (flags & 0x200) != 0) {
            this.postRefresh(element);
            return;
        }
        if (kind == 2) {
            parent = this.internalGetParent(element);
            this.postRemove(element);
            if (parent instanceof IPackageFragment) {
                this.updatePackageIcon((IJavaElement)((IPackageFragment)parent));
            }
            if (this.isPackageFragmentEmpty(element.getParent()) && this.fViewer.testFindItem(parent) != null) {
                this.postRefresh(this.internalGetParent(parent));
            }
            return;
        }
        if (kind == 1) {
            parent = this.internalGetParent(element);
            if (parent instanceof IPackageFragment) {
                Object grandparent = this.internalGetParent(parent);
                if (parent.equals(this.fInput)) {
                    this.postRefresh(parent);
                } else if (this.fViewer.testFindItem(parent) == null) {
                    this.postRefresh(grandparent);
                } else {
                    this.postRefresh(parent);
                }
            } else {
                this.postAdd(parent, element);
            }
        }
        if (element instanceof ICompilationUnit && kind == 4) {
            this.postRefresh(element);
            return;
        }
        if (element instanceof ICompilationUnit || element instanceof IClassFile) {
            return;
        }
        if (element instanceof IPackageFragmentRoot && (flags & 0x8000) != 0) {
            this.postRefresh(element);
        }
        if (this.isClassPathChange(delta)) {
            this.postRefresh(element.getJavaProject());
        }
        if (delta.getResourceDeltas() != null) {
            IResourceDelta[] rd = delta.getResourceDeltas();
            int i = 0;
            while (i < rd.length) {
                this.processResourceDelta(rd[i], element);
                ++i;
            }
        }
        if ((affectedChildren = delta.getAffectedChildren()).length > 1) {
            if (element instanceof IPackageFragment) {
                IJavaElement parent2 = (IJavaElement)this.internalGetParent(element);
                if (element.equals(this.fInput)) {
                    this.postRefresh(element);
                } else {
                    this.postRefresh(parent2);
                }
                return;
            }
            if (element instanceof IPackageFragmentRoot) {
                this.postRefresh(this.skipProjectPackageFragmentRoot((IPackageFragmentRoot)element));
            } else {
                this.postRefresh(element);
            }
            return;
        }
        int i = 0;
        while (i < affectedChildren.length) {
            this.processDelta(affectedChildren[i]);
            ++i;
        }
    }

    private boolean isOnClassPath(ICompilationUnit element) {
        IJavaProject project = element.getJavaProject();
        if (project == null || !project.exists()) {
            return false;
        }
        return project.isOnClasspath((IJavaElement)element);
    }

    private void updatePackageIcon(final IJavaElement element) {
        this.postRunnable(new Runnable(){

            @Override
            public void run() {
                Control ctrl = JavaElementContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    JavaElementContentProvider.this.fViewer.update((Object)element, new String[]{"org.eclipse.jface.image"});
                }
            }
        });
    }

    private void processResourceDelta(IResourceDelta delta, Object parent) {
        IResourceDelta[] affectedChildren;
        int status = delta.getKind();
        IResource resource = delta.getResource();
        if (resource == null) {
            return;
        }
        if ((status & 2) != 0) {
            if (parent instanceof IPackageFragment) {
                this.postRefresh(this.internalGetParent(parent));
            } else {
                this.postRemove(resource);
            }
        }
        if ((status & 1) != 0) {
            if (parent instanceof IPackageFragment) {
                this.postRefresh(this.internalGetParent(parent));
            } else {
                this.postAdd(parent, resource);
            }
        }
        if ((affectedChildren = delta.getAffectedChildren()).length > 1) {
            this.postRefresh(resource);
            return;
        }
        int i = 0;
        while (i < affectedChildren.length) {
            this.processResourceDelta(affectedChildren[i], resource);
            ++i;
        }
    }

    private void postRefresh(final Object root) {
        this.postRunnable(new Runnable(){

            @Override
            public void run() {
                Control ctrl = JavaElementContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    JavaElementContentProvider.this.fViewer.refresh(root);
                }
            }
        });
    }

    private void postAdd(final Object parent, final Object element) {
        this.postRunnable(new Runnable(){

            @Override
            public void run() {
                Control ctrl = JavaElementContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    JavaElementContentProvider.this.fViewer.add(parent, element);
                }
            }
        });
    }

    private void postRemove(final Object element) {
        this.postRunnable(new Runnable(){

            @Override
            public void run() {
                Control ctrl = JavaElementContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    JavaElementContentProvider.this.fViewer.remove(element);
                }
            }
        });
    }

    private void postRunnable(Runnable r) {
        Control ctrl = this.fViewer.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            ctrl.getDisplay().asyncExec(r);
        }
    }
}

