/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.trans.preproc;

import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrusrt.xtumlrt.common.Attribute;
import org.eclipse.papyrusrt.xtumlrt.common.Behaviour;
import org.eclipse.papyrusrt.xtumlrt.common.Capsule;
import org.eclipse.papyrusrt.xtumlrt.common.CapsuleKind;
import org.eclipse.papyrusrt.xtumlrt.common.CapsulePart;
import org.eclipse.papyrusrt.xtumlrt.common.Entity;
import org.eclipse.papyrusrt.xtumlrt.common.Model;
import org.eclipse.papyrusrt.xtumlrt.common.MultiplicityElement;
import org.eclipse.papyrusrt.xtumlrt.common.NamedElement;
import org.eclipse.papyrusrt.xtumlrt.common.Operation;
import org.eclipse.papyrusrt.xtumlrt.common.Package;
import org.eclipse.papyrusrt.xtumlrt.common.Parameter;
import org.eclipse.papyrusrt.xtumlrt.common.Port;
import org.eclipse.papyrusrt.xtumlrt.common.Protocol;
import org.eclipse.papyrusrt.xtumlrt.common.ProtocolBehaviourFeature;
import org.eclipse.papyrusrt.xtumlrt.common.Signal;
import org.eclipse.papyrusrt.xtumlrt.common.StructuredType;
import org.eclipse.papyrusrt.xtumlrt.statemach.StateMachine;
import org.eclipse.papyrusrt.xtumlrt.trans.Transformation;
import org.eclipse.papyrusrt.xtumlrt.trans.TransformationContext;
import org.eclipse.papyrusrt.xtumlrt.trans.preproc.StateMachineDefaultsPreprocessor;

public class StructureDefaultsPreprocessor
implements Transformation<NamedElement, NamedElement> {
    private static final StateMachineDefaultsPreprocessor behaviourPreprocessor = new StateMachineDefaultsPreprocessor();

    @Override
    public NamedElement transform(NamedElement input, TransformationContext context) {
        this.visit(input);
        return input;
    }

    protected void _visit(Model model) {
        EList _entities = model.getEntities();
        Consumer<Entity> _function = new Consumer<Entity>(){

            @Override
            public void accept(Entity it) {
                StructureDefaultsPreprocessor.this.visit((NamedElement)it);
            }
        };
        _entities.forEach((Consumer)_function);
        EList _protocols = model.getProtocols();
        Consumer<Protocol> _function_1 = new Consumer<Protocol>(){

            @Override
            public void accept(Protocol it) {
                StructureDefaultsPreprocessor.this.visit((NamedElement)it);
            }
        };
        _protocols.forEach((Consumer)_function_1);
        EList _packages = model.getPackages();
        Consumer<Package> _function_2 = new Consumer<Package>(){

            @Override
            public void accept(Package it) {
                StructureDefaultsPreprocessor.this.visit((NamedElement)it);
            }
        };
        _packages.forEach((Consumer)_function_2);
    }

    protected void _visit(Entity entity) {
        this.visitEntity(entity);
    }

    protected void visitStructuredType(StructuredType structuredType) {
        EList _attributes = structuredType.getAttributes();
        Consumer<Attribute> _function = new Consumer<Attribute>(){

            @Override
            public void accept(Attribute it) {
                StructureDefaultsPreprocessor.this.visit((NamedElement)it);
            }
        };
        _attributes.forEach((Consumer)_function);
        EList _operations = structuredType.getOperations();
        Consumer<Operation> _function_1 = new Consumer<Operation>(){

            @Override
            public void accept(Operation it) {
                StructureDefaultsPreprocessor.this.visit((NamedElement)it);
            }
        };
        _operations.forEach((Consumer)_function_1);
    }

    protected void visitEntity(Entity entity) {
        boolean _tripleNotEquals;
        this.visitStructuredType((StructuredType)entity);
        Behaviour _behaviour = entity.getBehaviour();
        boolean bl = _tripleNotEquals = _behaviour != null;
        if (_tripleNotEquals) {
            Behaviour _behaviour_1 = entity.getBehaviour();
            this.visit((NamedElement)_behaviour_1);
        }
    }

    protected void _visit(Capsule capsule) {
        this.visitEntity((Entity)capsule);
        EList _ports = capsule.getPorts();
        Consumer<Port> _function = new Consumer<Port>(){

            @Override
            public void accept(Port it) {
                StructureDefaultsPreprocessor.this.visit((NamedElement)it);
            }
        };
        _ports.forEach((Consumer)_function);
        EList _parts = capsule.getParts();
        Consumer<CapsulePart> _function_1 = new Consumer<CapsulePart>(){

            @Override
            public void accept(CapsulePart it) {
                StructureDefaultsPreprocessor.this.visit((NamedElement)it);
            }
        };
        _parts.forEach((Consumer)_function_1);
    }

    protected void _visit(Protocol protocol) {
        EList _protocolBehaviourFeatures = protocol.getProtocolBehaviourFeatures();
        Consumer<ProtocolBehaviourFeature> _function = new Consumer<ProtocolBehaviourFeature>(){

            @Override
            public void accept(ProtocolBehaviourFeature it) {
                StructureDefaultsPreprocessor.this.visit((NamedElement)it);
            }
        };
        _protocolBehaviourFeatures.forEach((Consumer)_function);
    }

    protected void _visit(Signal signal) {
        EList _parameters = signal.getParameters();
        Consumer<Parameter> _function = new Consumer<Parameter>(){

            @Override
            public void accept(Parameter it) {
                StructureDefaultsPreprocessor.this.visit((NamedElement)it);
            }
        };
        _parameters.forEach((Consumer)_function);
    }

    protected void _visit(Package packge) {
        EList _entities = packge.getEntities();
        Consumer<Entity> _function = new Consumer<Entity>(){

            @Override
            public void accept(Entity it) {
                StructureDefaultsPreprocessor.this.visit((NamedElement)it);
            }
        };
        _entities.forEach((Consumer)_function);
        EList _protocols = packge.getProtocols();
        Consumer<Protocol> _function_1 = new Consumer<Protocol>(){

            @Override
            public void accept(Protocol it) {
                StructureDefaultsPreprocessor.this.visit((NamedElement)it);
            }
        };
        _protocols.forEach((Consumer)_function_1);
        EList _packages = packge.getPackages();
        Consumer<Package> _function_2 = new Consumer<Package>(){

            @Override
            public void accept(Package it) {
                StructureDefaultsPreprocessor.this.visit((NamedElement)it);
            }
        };
        _packages.forEach((Consumer)_function_2);
    }

    protected void _visit(Port port) {
        this.visitMultiplicityElement((MultiplicityElement)port);
    }

    protected void _visit(CapsulePart part) {
        this.visitMultiplicityElement((MultiplicityElement)part);
        if (Objects.equal((Object)part.getKind(), (Object)CapsuleKind.OPTIONAL) || Objects.equal((Object)part.getKind(), (Object)CapsuleKind.PLUGIN)) {
            part.setLowerBound("0");
        }
    }

    protected void _visit(Attribute attribute) {
        this.visitMultiplicityElement((MultiplicityElement)attribute);
    }

    protected void _visit(Operation operation) {
        EList _parameters = operation.getParameters();
        Consumer<Parameter> _function = new Consumer<Parameter>(){

            @Override
            public void accept(Parameter it) {
                StructureDefaultsPreprocessor.this.visit((NamedElement)it);
            }
        };
        _parameters.forEach((Consumer)_function);
    }

    protected void _visit(Parameter parameter) {
        this.visitMultiplicityElement((MultiplicityElement)parameter);
    }

    protected void visitMultiplicityElement(MultiplicityElement element) {
        String lowerBound = element.getLowerBound();
        String upperBound = element.getUpperBound();
        if (lowerBound == null && upperBound == null) {
            element.setLowerBound("1");
            element.setUpperBound("1");
        } else if (lowerBound == null && upperBound != null) {
            String _upperBound = element.getUpperBound();
            element.setLowerBound(_upperBound);
        } else if (lowerBound != null && upperBound == null) {
            String _lowerBound = element.getLowerBound();
            element.setUpperBound(_lowerBound);
        } else {
            String _upperBound_1 = element.getUpperBound();
            element.setLowerBound(_upperBound_1);
        }
    }

    protected void _visit(Behaviour behaviour) {
    }

    protected void _visit(StateMachine machine) {
        behaviourPreprocessor.transform(machine, (TransformationContext)null);
    }

    public void visit(NamedElement capsule) {
        if (capsule instanceof Capsule) {
            this._visit((Capsule)capsule);
            return;
        }
        if (capsule instanceof Entity) {
            this._visit((Entity)capsule);
            return;
        }
        if (capsule instanceof StateMachine) {
            this._visit((StateMachine)capsule);
            return;
        }
        if (capsule instanceof Attribute) {
            this._visit((Attribute)capsule);
            return;
        }
        if (capsule instanceof Behaviour) {
            this._visit((Behaviour)capsule);
            return;
        }
        if (capsule instanceof CapsulePart) {
            this._visit((CapsulePart)capsule);
            return;
        }
        if (capsule instanceof Parameter) {
            this._visit((Parameter)capsule);
            return;
        }
        if (capsule instanceof Port) {
            this._visit((Port)capsule);
            return;
        }
        if (capsule instanceof Protocol) {
            this._visit((Protocol)capsule);
            return;
        }
        if (capsule instanceof Signal) {
            this._visit((Signal)capsule);
            return;
        }
        if (capsule instanceof Model) {
            this._visit((Model)capsule);
            return;
        }
        if (capsule instanceof Operation) {
            this._visit((Operation)capsule);
            return;
        }
        if (capsule instanceof Package) {
            this._visit((Package)capsule);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(capsule).toString());
    }
}

