/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.export.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.sasheditor.DiModel;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ResourceUtils;
import org.eclipse.papyrus.infra.gmfdiag.export.Activator;
import org.eclipse.papyrus.infra.gmfdiag.export.actions.ExportAllDiagramsDialog;
import org.eclipse.papyrus.infra.gmfdiag.export.actions.ExportAllDiagramsParameter;
import org.eclipse.papyrus.infra.gmfdiag.export.engine.ExportAllDiagramsEngine;
import org.eclipse.papyrus.infra.gmfdiag.export.utils.SelectionHelper;
import org.eclipse.papyrus.infra.ui.util.ServiceUtilsForSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class ExportAllDiagramsAction
extends AbstractHandler {
    private ExportAllDiagramsEngine exportAllDiagrams = new ExportAllDiagramsEngine();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ExportAllDiagramsDialog exportPopup;
        ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        ModelSet modelSetSelection = null;
        ExportAllDiagramsParameter parameter = null;
        IFile file = null;
        try {
            modelSetSelection = ServiceUtilsForSelection.getInstance().getModelSet((Object)selection);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        if (modelSetSelection == null) {
            file = SelectionHelper.convertSelection2File(selection);
            URI diFileUri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            parameter = new ExportAllDiagramsParameter(diFileUri);
        } else {
            IModel diModel = modelSetSelection.getModel("org.eclipse.papyrus.infra.core.resource.DiModel");
            if (diModel instanceof DiModel) {
                file = ResourceUtils.getFile((Resource)((DiModel)diModel).getResource());
            }
            parameter = new ExportAllDiagramsParameter(modelSetSelection);
        }
        URI uriDirectory = null;
        if (file != null) {
            IResource parentResource = file.getParent().findMember(".");
            uriDirectory = URI.createURI((String)parentResource.getLocationURI().toString());
        }
        if ((exportPopup = new ExportAllDiagramsDialog(Activator.getActiveWorkbenchShell(), uriDirectory)).open() == 0) {
            parameter.setExportFormat(exportPopup.getExporter());
            parameter.setOutputDirectory(exportPopup.getOutputDirectory());
            parameter.setQualifiedName(exportPopup.getQualifiedName());
            this.exportAllDiagrams.initialise(parameter);
            this.exportAllDiagrams.exportDiagramsToImages();
        }
        return null;
    }
}

