/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.serializer;

import com.google.common.base.Throwables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.analysis.GrammarAlias;
import org.eclipse.xtext.serializer.analysis.IContextPDAProvider;
import org.eclipse.xtext.serializer.analysis.IContextTypePDAProvider;
import org.eclipse.xtext.serializer.analysis.ISemanticSequencerNfaProvider;
import org.eclipse.xtext.serializer.analysis.ISyntacticSequencerPDAProvider;
import org.eclipse.xtext.util.GraphvizDotBuilder;
import org.eclipse.xtext.util.formallang.Nfa;
import org.eclipse.xtext.util.formallang.NfaToDot;
import org.eclipse.xtext.util.formallang.Pda;
import org.eclipse.xtext.util.formallang.PdaToDot;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xtext.generator.XtextGeneratorNaming;
import org.eclipse.xtext.xtext.generator.serializer.EqualAmbiguousTransitions;
import org.eclipse.xtext.xtext.generator.serializer.SyntacticSequencerExtensions;
import org.eclipse.xtext.xtext.generator.serializer.SyntacticSequencerPDA2ExtendedDot;

public class DebugGraphGenerator {
    @Inject
    private Grammar grammar;
    @Inject
    @Extension
    private XtextGeneratorNaming _xtextGeneratorNaming;
    @Inject
    private IContextPDAProvider contextPDAProvider;
    @Inject
    private IContextTypePDAProvider contextTypePDAProvider;
    @Inject
    private ISyntacticSequencerPDAProvider syntacticSequencerPDAProvider;
    @Inject
    private ISemanticSequencerNfaProvider semanticSequencerNFAProvider;
    @Inject
    private SyntacticSequencerPDA2ExtendedDot syntacticSequencerPDA2Dot;
    @Inject
    private SyntacticSequencerExtensions syntacticSequencerUtil;
    @Inject
    private PdaToDot<?, ?> pdaToDot;
    @Inject
    private NfaToDot<?> nfaToDot;

    /*
     * WARNING - void declaration
     */
    public Iterable<Pair<String, String>> generateDebugGraphs() {
        ArrayList result = CollectionLiterals.newArrayList((Object[])new Pair[0]);
        Map _contextPDAs = this.contextPDAProvider.getContextPDAs(this.grammar);
        Set _entrySet = _contextPDAs.entrySet();
        for (Map.Entry e : _entrySet) {
            ISerializationContext iSerializationContext = (ISerializationContext)e.getKey();
            String _file = this.file("context", iSerializationContext);
            ISerializationContext iSerializationContext2 = (ISerializationContext)e.getKey();
            Pda _value = (Pda)e.getValue();
            String string = this.drawSafe((GraphvizDotBuilder)this.pdaToDot, iSerializationContext2, _value);
            Pair _mappedTo = Pair.of((Object)_file, (Object)string);
            result.add(_mappedTo);
        }
        Map _contextTypePDAs = this.contextTypePDAProvider.getContextTypePDAs(this.grammar);
        Set _entrySet_1 = _contextTypePDAs.entrySet();
        for (Map.Entry entry : _entrySet_1) {
            ISerializationContext iSerializationContext = (ISerializationContext)entry.getKey();
            String _file_1 = this.file("context_type", iSerializationContext);
            ISerializationContext iSerializationContext3 = (ISerializationContext)entry.getKey();
            Pda _value_1 = (Pda)entry.getValue();
            String _drawSafe_1 = this.drawSafe((GraphvizDotBuilder)this.pdaToDot, iSerializationContext3, _value_1);
            Pair _mappedTo_1 = Pair.of((Object)_file_1, (Object)_drawSafe_1);
            result.add(_mappedTo_1);
        }
        Map map = this.syntacticSequencerPDAProvider.getSyntacticSequencerPDAs(this.grammar);
        Set _entrySet_2 = map.entrySet();
        for (Map.Entry entry : _entrySet_2) {
            ISerializationContext iSerializationContext = (ISerializationContext)entry.getKey();
            String _file_2 = this.file("syntactic_sequencer", iSerializationContext);
            ISerializationContext _key_5 = (ISerializationContext)entry.getKey();
            ISyntacticSequencerPDAProvider.ISynAbsorberState _value_2 = (ISyntacticSequencerPDAProvider.ISynAbsorberState)entry.getValue();
            String _drawSafe_2 = this.drawSafe(this.syntacticSequencerPDA2Dot, _key_5, _value_2);
            Pair _mappedTo_2 = Pair.of((Object)_file_2, (Object)_drawSafe_2);
            result.add(_mappedTo_2);
        }
        Map map2 = this.semanticSequencerNFAProvider.getSemanticSequencerNFAs(this.grammar);
        Set _entrySet_3 = map2.entrySet();
        for (Map.Entry entry : _entrySet_3) {
            ISerializationContext _key_6 = (ISerializationContext)entry.getKey();
            String _file_3 = this.file("semantic_sequencer", _key_6);
            ISerializationContext _key_7 = (ISerializationContext)entry.getKey();
            Nfa _value_3 = (Nfa)entry.getValue();
            String _drawSafe_3 = this.drawSafe((GraphvizDotBuilder)this.nfaToDot, _key_7, _value_3);
            Pair _mappedTo_3 = Pair.of((Object)_file_3, (Object)_drawSafe_3);
            result.add(_mappedTo_3);
        }
        try {
            boolean bl = false;
            HashMap trans2id = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
            Set<ISyntacticSequencerPDAProvider.ISynTransition> _allAmbiguousTransitions = this.syntacticSequencerUtil.getAllAmbiguousTransitions();
            for (ISyntacticSequencerPDAProvider.ISynTransition transition : _allAmbiguousTransitions) {
                void var10_26;
                String name = "ambiguity_" + Integer.valueOf((int)var10_26);
                String _directory = this.directory("syntactic_sequencer");
                String _plus = String.valueOf(_directory) + name;
                String _plus_1 = String.valueOf(_plus) + ".dot";
                Nfa _ambiguousNfa = transition.getAmbiguousNfa();
                String _draw = this.nfaToDot.draw((Object)_ambiguousNfa);
                Pair _mappedTo_4 = Pair.of((Object)_plus_1, (Object)_draw);
                result.add(_mappedTo_4);
                trans2id.put(transition, name);
                ++var10_26;
            }
            StringBuffer ambiguities = new StringBuffer();
            List<EqualAmbiguousTransitions> _allAmbiguousTransitionsBySyntax = this.syntacticSequencerUtil.getAllAmbiguousTransitionsBySyntax();
            for (EqualAmbiguousTransitions group : _allAmbiguousTransitionsBySyntax) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"id: ");
                String _identifier = group.getIdentifier();
                _builder.append((Object)_identifier, "");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"Ambiguous syntax:\u00bb:");
                _builder.newLine();
                _builder.append((Object)"        ");
                GrammarAlias.AbstractElementAlias _elementAlias = group.getElementAlias();
                String _string = _elementAlias.toString();
                String _replace = _string.replace("\n", "\n        ");
                _builder.append((Object)_replace, "        ");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"This ambiguous syntax occurs at:");
                _builder.newLine();
                List<ISyntacticSequencerPDAProvider.ISynTransition> _transitions = group.getTransitions();
                for (ISyntacticSequencerPDAProvider.ISynTransition trans : _transitions) {
                    _builder.append((Object)"\t");
                    String _get = (String)trans2id.get(trans);
                    _builder.append((Object)_get, "\t");
                    _builder.append((Object)":");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"    ");
                    String _ambiguityInsideTransition = group.ambiguityInsideTransition(trans);
                    String _replace_1 = _ambiguityInsideTransition.replace("\n", "\n        ");
                    _builder.append((Object)_replace_1, "\t    ");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"\t");
                _builder.newLine();
                _builder.newLine();
                ambiguities.append((CharSequence)_builder);
            }
            String _directory = this.directory("syntactic_sequencer");
            String _plus = String.valueOf(_directory) + "ambiguities.txt";
            String _string_1 = ambiguities.toString();
            Pair _mappedTo_4 = Pair.of((Object)_plus, (Object)_string_1);
            result.add(_mappedTo_4);
        }
        catch (Throwable throwable) {
            if (throwable instanceof Exception) {
                Exception e_4 = (Exception)throwable;
                e_4.printStackTrace();
            }
            throw Exceptions.sneakyThrow((Throwable)throwable);
        }
        return result;
    }

    private String drawSafe(GraphvizDotBuilder builder, ISerializationContext context, Object graph) {
        String _xtrycatchfinallyexpression = null;
        try {
            _xtrycatchfinallyexpression = builder.draw(graph);
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                InputOutput.println((Object)("Error rendering " + context));
                e.printStackTrace();
                return Throwables.getStackTraceAsString((Throwable)e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return _xtrycatchfinallyexpression;
    }

    private String directory(String name) {
        String _runtimeBasePackage = this._xtextGeneratorNaming.getRuntimeBasePackage(this.grammar);
        String _replace = _runtimeBasePackage.replace(".", "/");
        String _plus = String.valueOf(_replace) + "/serializer/";
        String _simpleName = GrammarUtil.getSimpleName((Grammar)this.grammar);
        String _lowerCase = _simpleName.toLowerCase();
        String _plus_1 = String.valueOf(_plus) + _lowerCase;
        String _plus_2 = String.valueOf(_plus_1) + "_";
        String _plus_3 = String.valueOf(_plus_2) + name;
        return String.valueOf(_plus_3) + "/";
    }

    private String file(String name, ISerializationContext contexts) {
        String _directory = this.directory(name);
        String _plus = String.valueOf(_directory) + contexts;
        return String.valueOf(_plus) + ".dot";
    }
}

