/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.osgi.framework.Bundle;

public class Policy {
    public static final DebugOptionsListener RESOURCES_DEBUG_OPTIONS_LISTENER = new DebugOptionsListener(){

        public void optionsChanged(DebugOptions options) {
            DEBUG = options.getBooleanOption("org.eclipse.core.resources/debug", false);
            DEBUG_AUTO_REFRESH = DEBUG && options.getBooleanOption("org.eclipse.core.resources/refresh", false);
            DEBUG_BUILD_DELTA = DEBUG && options.getBooleanOption("org.eclipse.core.resources/build/delta", false);
            DEBUG_BUILD_FAILURE = DEBUG && options.getBooleanOption("org.eclipse.core.resources/build/failure", false);
            DEBUG_BUILD_INTERRUPT = DEBUG && options.getBooleanOption("org.eclipse.core.resources/build/interrupt", false);
            DEBUG_BUILD_INVOKING = DEBUG && options.getBooleanOption("org.eclipse.core.resources/build/invoking", false);
            DEBUG_BUILD_NEEDED = DEBUG && options.getBooleanOption("org.eclipse.core.resources/build/needbuild", false);
            DEBUG_BUILD_NEEDED_STACK = DEBUG && options.getBooleanOption("org.eclipse.core.resources/build/needbuildstack", false);
            DEBUG_BUILD_STACK = DEBUG && options.getBooleanOption("org.eclipse.core.resources/build/stacktrace", false);
            DEBUG_CONTENT_TYPE = DEBUG && options.getBooleanOption("org.eclipse.core.resources/contenttype", false);
            DEBUG_CONTENT_TYPE_CACHE = DEBUG && options.getBooleanOption("org.eclipse.core.resources/contenttype/cache", false);
            DEBUG_HISTORY = DEBUG && options.getBooleanOption("org.eclipse.core.resources/history", false);
            DEBUG_NATURES = DEBUG && options.getBooleanOption("org.eclipse.core.resources/natures", false);
            DEBUG_NOTIFICATIONS = DEBUG && options.getBooleanOption("org.eclipse.core.resources/notifications", false);
            DEBUG_PREFERENCES = DEBUG && options.getBooleanOption("org.eclipse.core.resources/preferences", false);
            DEBUG_RESTORE = DEBUG && options.getBooleanOption("org.eclipse.core.resources/restore", false);
            DEBUG_RESTORE_MARKERS = DEBUG && options.getBooleanOption("org.eclipse.core.resources/restore/markers", false);
            DEBUG_RESTORE_MASTERTABLE = DEBUG && options.getBooleanOption("org.eclipse.core.resources/restore/mastertable", false);
            DEBUG_RESTORE_METAINFO = DEBUG && options.getBooleanOption("org.eclipse.core.resources/restore/metainfo", false);
            DEBUG_RESTORE_SNAPSHOTS = DEBUG && options.getBooleanOption("org.eclipse.core.resources/restore/snapshots", false);
            DEBUG_RESTORE_SYNCINFO = DEBUG && options.getBooleanOption("org.eclipse.core.resources/restore/syncinfo", false);
            DEBUG_RESTORE_TREE = DEBUG && options.getBooleanOption("org.eclipse.core.resources/restore/tree", false);
            DEBUG_SAVE = DEBUG && options.getBooleanOption("org.eclipse.core.resources/save", false);
            DEBUG_SAVE_MARKERS = DEBUG && options.getBooleanOption("org.eclipse.core.resources/save/markers", false);
            DEBUG_SAVE_MASTERTABLE = DEBUG && options.getBooleanOption("org.eclipse.core.resources/save/mastertable", false);
            DEBUG_SAVE_METAINFO = DEBUG && options.getBooleanOption("org.eclipse.core.resources/save/metainfo", false);
            DEBUG_SAVE_SYNCINFO = DEBUG && options.getBooleanOption("org.eclipse.core.resources/save/syncinfo", false);
            DEBUG_SAVE_TREE = DEBUG && options.getBooleanOption("org.eclipse.core.resources/save/tree", false);
            DEBUG_STRINGS = DEBUG && options.getBooleanOption("org.eclipse.core.resources/strings", false);
        }
    };
    public static final boolean buildOnCancel = false;
    public static boolean DEBUG = false;
    public static boolean DEBUG_AUTO_REFRESH = false;
    public static boolean DEBUG_BUILD_DELTA = false;
    public static boolean DEBUG_BUILD_FAILURE = false;
    public static boolean DEBUG_BUILD_INTERRUPT = false;
    public static boolean DEBUG_BUILD_INVOKING = false;
    public static boolean DEBUG_BUILD_NEEDED = false;
    public static boolean DEBUG_BUILD_NEEDED_STACK = false;
    public static boolean DEBUG_BUILD_STACK = false;
    public static boolean DEBUG_CONTENT_TYPE = false;
    public static boolean DEBUG_CONTENT_TYPE_CACHE = false;
    public static boolean DEBUG_HISTORY = false;
    public static boolean DEBUG_NATURES = false;
    public static boolean DEBUG_NOTIFICATIONS = false;
    public static boolean DEBUG_PREFERENCES = false;
    public static boolean DEBUG_RESTORE = false;
    public static boolean DEBUG_RESTORE_MARKERS = false;
    public static boolean DEBUG_RESTORE_MASTERTABLE = false;
    public static boolean DEBUG_RESTORE_METAINFO = false;
    public static boolean DEBUG_RESTORE_SNAPSHOTS = false;
    public static boolean DEBUG_RESTORE_SYNCINFO = false;
    public static boolean DEBUG_RESTORE_TREE = false;
    public static boolean DEBUG_SAVE = false;
    public static boolean DEBUG_SAVE_MARKERS = false;
    public static boolean DEBUG_SAVE_MASTERTABLE = false;
    public static boolean DEBUG_SAVE_METAINFO = false;
    public static boolean DEBUG_SAVE_SYNCINFO = false;
    public static boolean DEBUG_SAVE_TREE = false;
    public static boolean DEBUG_STRINGS = false;
    public static int endOpWork = 1;
    public static final long MAX_BUILD_DELAY = 1000L;
    public static final long MIN_BUILD_DELAY = 100L;
    public static int opWork = 99;
    public static final int totalWork = 100;

    public static void checkCanceled(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public static void debug(String message) {
        StringBuilder output = new StringBuilder();
        output.append(new Date(System.currentTimeMillis()));
        output.append(" - [");
        output.append(Thread.currentThread().getName());
        output.append("] ");
        Job currentJob = Job.getJobManager().currentJob();
        if (currentJob != null) {
            output.append(currentJob.getClass().getName());
            output.append("(");
            output.append(currentJob.getName());
            output.append("): ");
        }
        output.append(message);
        System.out.println(output.toString());
    }

    public static void debug(Throwable t) {
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        String str = writer.toString();
        if (str.endsWith("\n")) {
            str = str.substring(0, str.length() - 2);
        }
        Policy.debug(str);
    }

    public static void log(int severity, String message, Throwable t) {
        if (message == null) {
            message = "";
        }
        Policy.log((IStatus)new Status(severity, "org.eclipse.core.resources", 1, message, t));
    }

    public static void log(IStatus status) {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.core.resources");
        if (bundle == null) {
            return;
        }
        Platform.getLog((Bundle)bundle).log(status);
    }

    public static void log(Throwable t) {
        Policy.log(4, "Internal Error", t);
    }

    public static IProgressMonitor monitorFor(IProgressMonitor monitor) {
        return monitor == null ? new NullProgressMonitor() : monitor;
    }

    public static IProgressMonitor subMonitorFor(IProgressMonitor monitor, int ticks) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        if (monitor instanceof NullProgressMonitor) {
            return monitor;
        }
        return new SubProgressMonitor(monitor, ticks);
    }
}

