/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.nattable.manager.axis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.nattable.manager.axis.AbstractAxisManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.EObjectAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.NattableaxisFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.NattableaxisproviderPackage;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;

public class EObjectAxisManager
extends AbstractAxisManager {
    public boolean canDestroyAxisElement(Integer axisPosition) {
        Object current = this.getElements().get(axisPosition);
        if (current instanceof EObjectAxis) {
            return !EMFHelper.isReadOnly((EObject)((EObjectAxis)current).getElement());
        }
        return false;
    }

    public Command getAddAxisCommand(TransactionalEditingDomain domain, Collection<Object> objectToAdd) {
        Collection<IAxis> toAdd = this.getAxisToAdd(objectToAdd);
        if (!toAdd.isEmpty()) {
            return new AbstractAxisManager.AddCommandWrapper((AbstractAxisManager)this, AddCommand.create((EditingDomain)domain, (Object)this.getRepresentedContentProvider(), (Object)NattableaxisproviderPackage.eINSTANCE.getAxisProvider_Axis(), toAdd), objectToAdd);
        }
        return null;
    }

    public Command getAddAxisCommand(TransactionalEditingDomain domain, Collection<Object> objectToAdd, int index) {
        Collection<IAxis> toAdd = this.getAxisToAdd(objectToAdd);
        if (!toAdd.isEmpty()) {
            return new AbstractAxisManager.AddCommandWrapper((AbstractAxisManager)this, AddCommand.create((EditingDomain)domain, (Object)this.getRepresentedContentProvider(), (Object)NattableaxisproviderPackage.eINSTANCE.getAxisProvider_Axis(), toAdd, (int)index), objectToAdd);
        }
        return null;
    }

    protected Collection<IAxis> getAxisToAdd(Collection<Object> objectToAdd) {
        ArrayList<IAxis> toAdd = new ArrayList<IAxis>();
        for (Object object : objectToAdd) {
            if (!this.isAllowedContents(object) || this.isAlreadyManaged(object)) continue;
            EObjectAxis horizontalAxis = NattableaxisFactory.eINSTANCE.createEObjectAxis();
            horizontalAxis.setElement((EObject)object);
            horizontalAxis.setManager(this.representedAxisManager);
            toAdd.add((IAxis)horizontalAxis);
        }
        return toAdd;
    }

    public Command getDestroyAxisElementCommand(TransactionalEditingDomain domain, Integer axisPosition) {
        Object current = this.getElements().get(axisPosition);
        if (current instanceof EObjectAxis) {
            EObject element = ((EObjectAxis)current).getElement();
            DestroyElementRequest request = new DestroyElementRequest(this.getContextEditingDomain(), element, false);
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)element);
            return new AbstractAxisManager.RemoveCommandWrapper((AbstractAxisManager)this, (Command)new GMFtoEMFCommandWrapper(provider.getEditCommand((IEditCommandRequest)request)), Collections.singleton(((EObjectAxis)current).getElement()));
        }
        return null;
    }

    public String getElementAxisName(IAxis axis) {
        throw new UnsupportedOperationException();
    }

    public boolean isAllowedContents(Object object) {
        return object instanceof EObject;
    }

    public boolean isDynamic() {
        return false;
    }

    public boolean isSlave() {
        return false;
    }
}

