/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.palette.customaction.utils;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.core.modelsetquery.ModelSetQuery;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionalElementListDialog<T extends EObject>
extends ElementListSelectionDialog {
    public ConditionalElementListDialog(Shell parent, Predicate<T> condition, EObject anEobject, EClass eclassAccepted) {
        this(parent, condition, ModelSetQuery.getObjectsOfType((EObject)anEobject, (EClassifier)eclassAccepted));
    }

    public ConditionalElementListDialog(Shell parent, Predicate<T> condition, Collection<T> elements) {
        super(parent, (ILabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)){

            public void dispose() {
                if (this.adapterFactory instanceof IDisposable) {
                    ((IDisposable)this.adapterFactory).dispose();
                }
                super.dispose();
            }
        });
        this.setMultipleSelection(false);
        ArrayList result = Lists.newArrayList((Iterable)Iterables.filter(elements, condition));
        this.setTitle("Choose Elements");
        this.setElements(result.toArray());
    }

    public T getFirstResult() {
        if (this.getResult().length > 0) {
            return (T)((EObject)this.getResult()[0]);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ICondition<T> {
        public boolean isValid(T var1);
    }
}

