/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.util;

import java.util.Arrays;
import java.util.Comparator;

public class HashTable
implements Cloneable {
    private static final int[] PRIMES = new int[]{17, 29, 53, 97, 193, 389, 769, 1543, 3079, 6151, 12289, 24593, 49157, 98317, 196613, 393241, 786433, 1572869, 0x30000B, 0x60000D, 0xC00005, 25165843, 0x3000005, 100663319, 201326611, 402653189, 805306457, 0x60000005};
    private static final int MIN_HASH_SIZE = 9;
    @Deprecated
    protected static final int minHashSize = 8;
    protected int currEntry = -1;
    protected int[] hashTable;
    protected int[] nextTable;

    public boolean isEmpty() {
        return this.currEntry < 0;
    }

    public final int size() {
        return this.currEntry + 1;
    }

    public HashTable(int initialSize) {
        if (initialSize >= 9) {
            this.hashTable = new int[HashTable.getSuitableHashTableSize(initialSize)];
            this.nextTable = new int[initialSize];
        } else {
            this.hashTable = null;
            this.nextTable = null;
        }
    }

    public Object clone() {
        HashTable newTable = null;
        try {
            newTable = (HashTable)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        int size = this.capacity();
        if (this.hashTable != null) {
            newTable.hashTable = new int[HashTable.getSuitableHashTableSize(size)];
            newTable.nextTable = new int[size];
            System.arraycopy(this.hashTable, 0, newTable.hashTable, 0, this.hashTable.length);
            System.arraycopy(this.nextTable, 0, newTable.nextTable, 0, this.nextTable.length);
        }
        newTable.currEntry = this.currEntry;
        return newTable;
    }

    protected void resize() {
        this.resize(this.capacity() << 1);
    }

    public void clear() {
        this.currEntry = -1;
        if (this.hashTable == null) {
            return;
        }
        Arrays.fill(this.hashTable, 0);
        Arrays.fill(this.nextTable, 0);
    }

    protected void rehash() {
        if (this.nextTable == null) {
            return;
        }
        Arrays.fill(this.hashTable, 0);
        Arrays.fill(this.nextTable, 0);
        int i = 0;
        while (i <= this.currEntry) {
            this.linkIntoHashTable(i, this.hash(i));
            ++i;
        }
    }

    protected void resize(int size) {
        if (size >= 9) {
            this.hashTable = new int[HashTable.getSuitableHashTableSize(size)];
            this.nextTable = new int[size];
            int i = 0;
            while (i <= this.currEntry) {
                this.linkIntoHashTable(i, this.hash(i));
                ++i;
            }
        }
    }

    private static int getSuitableHashTableSize(int size) {
        if ((size += (size + 2) / 3) < 0) {
            return Integer.MAX_VALUE;
        }
        int low = 0;
        int high = PRIMES.length;
        while (low < high) {
            int mid = low + high >>> 1;
            int p = PRIMES[mid];
            if (p < size) {
                low = mid + 1;
                continue;
            }
            if (p > size) {
                high = mid;
                continue;
            }
            return p;
        }
        if (low == PRIMES.length) {
            return Integer.MAX_VALUE;
        }
        return PRIMES[low];
    }

    protected int hash(int pos) {
        throw new UnsupportedOperationException();
    }

    final int hashToOffset(int hash) {
        int offset = hash % this.hashTable.length;
        if (offset < 0) {
            offset += this.hashTable.length - 1;
        }
        return offset;
    }

    protected final void linkIntoHashTable(int i, int hash) {
        if (this.nextTable == null) {
            return;
        }
        int j = this.hashTable[hash];
        if (j == 0) {
            this.hashTable[hash] = i + 1;
        } else {
            int k;
            --j;
            while ((k = this.nextTable[j]) != 0 && k != j + 1) {
                j = k - 1;
            }
            this.nextTable[j] = i + 1;
        }
    }

    public final int capacity() {
        if (this.nextTable == null) {
            return 8;
        }
        return this.nextTable.length;
    }

    protected void removeEntry(int i, int hash) {
        int k;
        int j;
        if (this.nextTable == null) {
            --this.currEntry;
            return;
        }
        if (this.hashTable[hash] == i + 1) {
            this.hashTable[hash] = this.nextTable[i];
        } else {
            j = this.hashTable[hash] - 1;
            while ((k = this.nextTable[j]) != 0 && k != i + 1) {
                j = k - 1;
            }
            this.nextTable[j] = this.nextTable[i];
        }
        if (i < this.currEntry) {
            System.arraycopy(this.nextTable, i + 1, this.nextTable, i, this.currEntry - i);
            j = 0;
            while (j < this.hashTable.length) {
                k = this.hashTable[j] - 1;
                if (k > i) {
                    this.hashTable[j] = k;
                }
                ++j;
            }
            j = 0;
            while (j < this.nextTable.length) {
                k = this.nextTable[j] - 1;
                if (k > i) {
                    this.nextTable[j] = k;
                }
                ++j;
            }
        }
        this.nextTable[this.currEntry] = 0;
        --this.currEntry;
    }

    public final void sort(Comparator<Object> c) {
        if (this.size() > 1) {
            this.quickSort(c, 0, this.size() - 1);
            this.rehash();
        }
    }

    private void quickSort(Comparator<Object> c, int p, int r) {
        if (p < r) {
            int q = this.partition(c, p, r);
            if (p < q) {
                this.quickSort(c, p, q);
            }
            if (++q < r) {
                this.quickSort(c, q, r);
            }
        }
    }

    protected int partition(Comparator<Object> c, int p, int r) {
        throw new UnsupportedOperationException();
    }

    public void dumpNexts() {
        if (this.nextTable == null) {
            return;
        }
        int i = 0;
        while (i < this.nextTable.length) {
            if (this.nextTable[i] != 0) {
                System.out.print(i);
                int j = this.nextTable[i] - 1;
                while (j >= 0) {
                    System.out.print(" -> " + j);
                    j = this.nextTable[j] - 1;
                }
                System.out.println("");
            }
            ++i;
        }
    }

    public int countCollisions() {
        if (this.nextTable == null) {
            return 0;
        }
        int numCollisions = 0;
        int i = 0;
        while (i < this.nextTable.length) {
            if (this.nextTable[i] != 0) {
                ++numCollisions;
            }
            ++i;
        }
        return numCollisions;
    }
}

