/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import java.util.Arrays;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.OverloadableOperator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPDependentEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPFunctionParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFunctionSet;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalMemberAccess;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExpressionTypes;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeOfDependentExpression;
import org.eclipse.core.runtime.CoreException;

public class EvalFunctionCall
extends CPPDependentEvaluation {
    private final ICPPEvaluation[] fArguments;
    private ICPPFunction fOverload = CPPFunction.UNINITIALIZED_FUNCTION;
    private IType fType;
    private boolean fCheckedIsConstantExpression;
    private boolean fIsConstantExpression;

    public EvalFunctionCall(ICPPEvaluation[] args, IASTNode pointOfDefinition) {
        this(args, EvalFunctionCall.findEnclosingTemplate(pointOfDefinition));
    }

    public EvalFunctionCall(ICPPEvaluation[] args, IBinding templateDefinition) {
        super(templateDefinition);
        this.fArguments = args;
    }

    public ICPPEvaluation[] getArguments() {
        return this.fArguments;
    }

    @Override
    public boolean isInitializerList() {
        return false;
    }

    @Override
    public boolean isFunctionSet() {
        return false;
    }

    @Override
    public boolean isTypeDependent() {
        return EvalFunctionCall.containsDependentType(this.fArguments);
    }

    @Override
    public boolean isValueDependent() {
        return EvalFunctionCall.containsDependentValue(this.fArguments);
    }

    @Override
    public boolean isConstantExpression(IASTNode point) {
        if (!this.fCheckedIsConstantExpression) {
            this.fCheckedIsConstantExpression = true;
            this.fIsConstantExpression = this.computeIsConstantExpression(point);
        }
        return this.fIsConstantExpression;
    }

    private boolean computeIsConstantExpression(IASTNode point) {
        return EvalFunctionCall.areAllConstantExpressions(this.fArguments, point) && EvalFunctionCall.isNullOrConstexprFunc(this.getOverload(point));
    }

    public ICPPFunction getOverload(IASTNode point) {
        if (this.fOverload == CPPFunction.UNINITIALIZED_FUNCTION) {
            this.fOverload = this.computeOverload(point);
        }
        return this.fOverload;
    }

    private ICPPFunction computeOverload(IASTNode point) {
        if (this.isTypeDependent()) {
            return null;
        }
        IType t = SemanticUtil.getNestedType(this.fArguments[0].getType(point), 13);
        if (t instanceof ICPPClassType) {
            return CPPSemantics.findOverloadedOperator(point, this.getTemplateDefinitionScope(), this.fArguments, t, OverloadableOperator.PAREN, CPPSemantics.LookupMode.NO_GLOBALS);
        }
        return null;
    }

    @Override
    public IType getType(IASTNode point) {
        if (this.fType == null) {
            this.fType = this.computeType(point);
        }
        return this.fType;
    }

    private IType computeType(IASTNode point) {
        if (this.isTypeDependent()) {
            return new TypeOfDependentExpression(this);
        }
        ICPPFunction overload = this.getOverload(point);
        if (overload != null) {
            return ExpressionTypes.typeFromFunctionCall(overload);
        }
        ICPPEvaluation function = this.fArguments[0];
        IType result = ExpressionTypes.typeFromFunctionCall(function.getType(point));
        if (function instanceof EvalMemberAccess) {
            result = ExpressionTypes.restoreTypedefs(result, ((EvalMemberAccess)function).getOwnerType());
        }
        return result;
    }

    @Override
    public IValue getValue(IASTNode point) {
        ICPPEvaluation eval = this.computeForFunctionCall(new ICPPEvaluation.ConstexprEvaluationContext(point));
        if (eval == this) {
            return Value.create(eval);
        }
        return eval.getValue(point);
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory(IASTNode point) {
        ICPPFunction overload = this.getOverload(point);
        if (overload != null) {
            return ExpressionTypes.valueCategoryFromFunctionCall(overload);
        }
        IType t = this.fArguments[0].getType(point);
        if (t instanceof IPointerType) {
            t = SemanticUtil.getNestedType(((IPointerType)t).getType(), 13);
        }
        if (t instanceof IFunctionType) {
            return ExpressionTypes.valueCategoryFromReturnType(((IFunctionType)t).getReturnType());
        }
        return IASTExpression.ValueCategory.PRVALUE;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        buffer.putShort((short)8);
        buffer.putInt(this.fArguments.length);
        ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            buffer.marshalEvaluation(arg, includeValue);
            ++n2;
        }
        this.marshalTemplateDefinition(buffer);
    }

    public static ISerializableEvaluation unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        int len = buffer.getInt();
        ICPPEvaluation[] args = new ICPPEvaluation[len];
        int i = 0;
        while (i < args.length) {
            args[i] = (ICPPEvaluation)buffer.unmarshalEvaluation();
            ++i;
        }
        IBinding templateDefinition = buffer.unmarshalBinding();
        return new EvalFunctionCall(args, templateDefinition);
    }

    @Override
    public ICPPEvaluation instantiate(InstantiationContext context, int maxDepth) {
        ICPPEvaluation[] args = EvalFunctionCall.instantiateCommaSeparatedSubexpressions(this.fArguments, context, maxDepth);
        if (args == this.fArguments) {
            return this;
        }
        if (args[0] instanceof EvalFunctionSet && this.getOverload(context.getPoint()) == null) {
            EvalFunctionSet functionSet = (EvalFunctionSet)args[0];
            args[0] = functionSet.resolveFunction(Arrays.copyOfRange(args, 1, args.length), context.getPoint());
        }
        return new EvalFunctionCall(args, this.getTemplateDefinition());
    }

    @Override
    public ICPPEvaluation computeForFunctionCall(CPPFunctionParameterMap parameterMap, ICPPEvaluation.ConstexprEvaluationContext context) {
        if (context.getStepsPerformed() >= 1024) {
            return EvalFixed.INCOMPLETE;
        }
        ICPPEvaluation[] args = this.fArguments;
        int i = 0;
        while (i < this.fArguments.length) {
            ICPPEvaluation arg = this.fArguments[i].computeForFunctionCall(parameterMap, context);
            if (arg != this.fArguments[i]) {
                if (args == this.fArguments) {
                    args = new ICPPEvaluation[this.fArguments.length];
                    System.arraycopy(this.fArguments, 0, args, 0, this.fArguments.length);
                }
                args[i] = arg;
            }
            ++i;
        }
        EvalFunctionCall eval = this;
        if (args != this.fArguments) {
            eval = new EvalFunctionCall(args, this.getTemplateDefinition());
        }
        return eval.computeForFunctionCall(context);
    }

    private ICPPEvaluation computeForFunctionCall(ICPPEvaluation.ConstexprEvaluationContext context) {
        if (this.isValueDependent()) {
            return this;
        }
        if (!EvalFunctionCall.areAllConstantExpressions(this.fArguments, 1, this.fArguments.length, context.getPoint())) {
            return this;
        }
        ICPPFunction function = this.getOverload(context.getPoint());
        if (function == null) {
            IBinding binding = null;
            if (this.fArguments[0] instanceof EvalBinding) {
                binding = ((EvalBinding)this.fArguments[0]).getBinding();
            } else if (this.fArguments[0] instanceof EvalMemberAccess) {
                binding = ((EvalMemberAccess)this.fArguments[0]).getMember();
            }
            if (binding instanceof ICPPFunction) {
                function = (ICPPFunction)binding;
            }
        }
        if (function == null) {
            return this;
        }
        ICPPEvaluation eval = CPPFunction.getReturnExpression(function, context.getPoint());
        if (eval == null) {
            if (!(function instanceof ICPPTemplateInstance) || ((ICPPTemplateInstance)((Object)function)).isExplicitSpecialization()) {
                return EvalFixed.INCOMPLETE;
            }
            ICPPTemplateInstance functionInstance = (ICPPTemplateInstance)((Object)function);
            IBinding specialized = functionInstance.getSpecializedBinding();
            if (!(specialized instanceof ICPPFunction)) {
                return this;
            }
            eval = CPPFunction.getReturnExpression((ICPPFunction)specialized, context.getPoint());
            if (eval == null) {
                return EvalFixed.INCOMPLETE;
            }
            InstantiationContext instantiationContext = new InstantiationContext(functionInstance.getTemplateParameterMap(), context.getPoint());
            return eval.instantiate(instantiationContext, 25);
        }
        CPPFunctionParameterMap parameterMap = this.buildParameterMap(function, context.getPoint());
        return eval.computeForFunctionCall(parameterMap, context.recordStep());
    }

    private CPPFunctionParameterMap buildParameterMap(ICPPFunction function, IASTNode point) {
        ICPPParameter[] parameters = function.getParameters();
        CPPFunctionParameterMap map = new CPPFunctionParameterMap(parameters.length);
        int j = 1;
        int i = 0;
        while (i < parameters.length) {
            ICPPParameter param = parameters[i];
            if (param.isParameterPack()) {
                j = this.fArguments.length;
            } else if (j < this.fArguments.length) {
                ICPPEvaluation argument = EvalFunctionCall.maybeApplyConversion(this.fArguments[j++], param.getType(), point);
                map.put(i, argument);
            } else if (param.hasDefaultValue()) {
                IValue value = param.getDefaultValue();
                ICPPEvaluation eval = value.getEvaluation();
                if (eval == null) {
                    eval = new EvalFixed(param.getType(), IASTExpression.ValueCategory.PRVALUE, value);
                }
                map.put(i, eval);
            }
            ++i;
        }
        return map;
    }

    @Override
    public int determinePackSize(ICPPTemplateParameterMap tpMap) {
        int r = Integer.MAX_VALUE;
        ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            r = CPPTemplates.combinePackSize(r, arg.determinePackSize(tpMap));
            ++n2;
        }
        return r;
    }

    @Override
    public boolean referencesTemplateParameter() {
        ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            if (arg.referencesTemplateParameter()) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

