/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.canonical;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.BasicDecorationNode;
import org.eclipse.gmf.runtime.notation.Compartment;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.canonical.DefaultUMLSemanticChildrenStrategy;
import org.eclipse.papyrusrt.umlrt.core.utils.TransitionUtils;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;

public class RTStateMachineSemanticChildrenStrategy
extends DefaultUMLSemanticChildrenStrategy {
    public List<? extends EObject> getCanonicalSemanticChildren(EObject semanticFromEditPart, View viewFromEditPart) {
        List<? extends EObject> result = super.getCanonicalSemanticChildren(semanticFromEditPart, viewFromEditPart);
        if (result != null) {
            if (this.isStateInRegion(viewFromEditPart)) {
                result.removeIf(Region.class::isInstance);
            } else if ((semanticFromEditPart instanceof State || semanticFromEditPart instanceof Region) && viewFromEditPart instanceof BasicDecorationNode) {
                result.removeIf(this::isConnectionPoint);
            }
            if (semanticFromEditPart instanceof State && ((State)semanticFromEditPart).getRegions().size() > 0 && this.isInternalTransitionCompartment(viewFromEditPart)) {
                result = this.getInternalTransitions((Region)((State)semanticFromEditPart).getRegions().get(0), viewFromEditPart);
            }
        }
        return result;
    }

    public List<? extends EObject> getCanonicalSemanticConnections(EObject semanticFromEditPart, View viewFromEditPart) {
        List result = super.getCanonicalSemanticConnections(semanticFromEditPart, viewFromEditPart);
        if (result != null && semanticFromEditPart instanceof State) {
            result.removeIf(o -> TransitionUtils.isInternalTransition((EObject)o));
        }
        return result;
    }

    protected List<? extends EObject> getInternalTransitions(Region region, View viewFromEditPart) {
        ArrayList result = null;
        Object owned = region.getTransitions();
        owned = Iterables.filter((Iterable)owned, e -> TransitionUtils.isInternalTransition((EObject)e));
        result = Lists.newArrayList((Iterable)owned);
        return result;
    }

    protected boolean isInternalTransitionCompartment(View viewFromEditPart) {
        return viewFromEditPart instanceof Compartment && "InternalTransitions".equals(((Compartment)viewFromEditPart).getType());
    }

    protected boolean isStateInRegion(View notationView) {
        boolean result = false;
        while (notationView instanceof BasicDecorationNode && notationView.eContainer() instanceof View) {
            notationView = (View)notationView.eContainer();
        }
        if ("State_Shape".equals(notationView.getType())) {
            result = notationView.eContainer() instanceof BasicDecorationNode;
        }
        return result;
    }

    protected boolean isConnectionPoint(EObject object) {
        boolean result = false;
        if (object instanceof Pseudostate) {
            switch (((Pseudostate)object).getKind()) {
                case ENTRY_POINT_LITERAL: 
                case EXIT_POINT_LITERAL: {
                    result = true;
                    break;
                }
                default: {
                    result = false;
                }
            }
        }
        return result;
    }
}

