/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.editpolicies;

import java.util.function.Supplier;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.Decoration;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.StringListValueStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.wrappers.GMFtoGEFCommandWrapper;
import org.eclipse.papyrus.infra.gmfdiag.common.adapter.SemanticAdapter;
import org.eclipse.papyrus.infra.gmfdiag.hyperlink.editpolicies.NavigationEditPolicy;
import org.eclipse.papyrus.uml.diagram.statemachine.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrusrt.umlrt.common.ui.preferences.DialogPreferences;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils.RelativePortLocation;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.utils.UMLRTStateMachineDiagramUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.commands.CreateNestedStateMachineDiagramCommand;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.commands.RerouteTransitionsToConnectionPointsCommand;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.editparts.IRTPseudostateEditPart;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.State;

public class RTCustomStateNavigationEditPolicy
extends NavigationEditPolicy {
    private static final String CONFIRMATION_DIALOG_ID = "org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.confirmCreateNestedSMD";

    protected org.eclipse.gef.commands.Command getOpenCommand(Request request) {
        org.eclipse.gef.commands.Command result;
        IFigure targetFigure;
        IGraphicalEditPart editPart;
        IFigure root;
        if (!(request instanceof SelectionRequest)) {
            return super.getOpenCommand(request);
        }
        Point location = ((SelectionRequest)request).getLocation().getCopy();
        if (this.getHost() instanceof IGraphicalEditPart && (root = FigureUtilities.getRoot((IFigure)(editPart = (IGraphicalEditPart)this.getHost()).getFigure())) != null && (targetFigure = root.findFigureAt(location)) != null && this.isInternalTransitionsDecorator(targetFigure)) {
            return GMFtoGEFCommandWrapper.wrap((ICommand)new ToggleCompartmentVisibilityCommand(this.getGraphicalHost()));
        }
        Diagram stateMachineDiagram = UMLRTStateMachineDiagramUtils.getStateMachineDiagram((State)this.getState());
        if (stateMachineDiagram != null) {
            result = super.getOpenCommand(request);
        } else {
            switch (this.promptToCreateNestedDiagram()) {
                case 3: {
                    result = super.getOpenCommand(request);
                    break;
                }
                case 2: {
                    CreateNestedStateMachineDiagramCommand createDiagram = new CreateNestedStateMachineDiagramCommand(this.getEditingDomain(), this.getState(), this.getGraphicalHost());
                    Supplier<Diagram> newDiagram = () -> RTCustomStateNavigationEditPolicy.lambda$0((ICommand)createDiagram);
                    CreateNestedStateMachineDiagramCommand composed = createDiagram;
                    ICommand rerouteTransitions = RerouteTransitionsToConnectionPointsCommand.createRerouteTransitionsCommand(this.getEditingDomain(), this.getState(), this.getGraphicalHost());
                    if (rerouteTransitions != null) {
                        composed = composed.compose((IUndoableOperation)rerouteTransitions);
                    }
                    composed = composed.compose((IUndoableOperation)this.getConnectionPointMatchingCommand(newDiagram));
                    result = GMFtoGEFCommandWrapper.wrap((ICommand)composed);
                    break;
                }
                default: {
                    result = null;
                }
            }
        }
        return result;
    }

    protected boolean isInternalTransitionsDecorator(IFigure targetFigure) {
        IFigure parentFigure = targetFigure.getParent();
        while (parentFigure != null) {
            if (parentFigure instanceof Decoration) {
                return true;
            }
            parentFigure = parentFigure.getParent();
        }
        return false;
    }

    int promptToCreateNestedDiagram() {
        Shell parentShell = this.getHost().getViewer().getControl().getShell();
        return DialogPreferences.yesNoCancel((Shell)parentShell, (String)"Convert to Composite State", (String)"Convert the state to a composite state and open a new diagram on its contents?", (String)CONFIRMATION_DIALOG_ID);
    }

    IGraphicalEditPart getGraphicalHost() {
        return (IGraphicalEditPart)this.getHost();
    }

    TransactionalEditingDomain getEditingDomain() {
        return this.getGraphicalHost().getEditingDomain();
    }

    State getState() {
        return (State)this.getGraphicalHost().resolveSemanticElement();
    }

    private ICommand getConnectionPointMatchingCommand(final Supplier<? extends Diagram> newDiagram) {
        return new AbstractTransactionalCommand(this.getEditingDomain(), "Arrange Connection Points", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                View frame;
                Diagram smd = (Diagram)newDiagram.get();
                View view = frame = smd == null ? null : ViewUtil.getChildBySemanticHint((View)smd, (String)"State_Shape_TN");
                if (frame instanceof Node) {
                    Rectangle frameRect = RTCustomStateNavigationEditPolicy.this.getBounds((Node)frame);
                    IGraphicalEditPart stateEP = RTCustomStateNavigationEditPolicy.this.getGraphicalHost();
                    Rectangle stateRect = RTCustomStateNavigationEditPolicy.this.getBounds(stateEP);
                    View stateView = stateEP.getNotationView();
                    for (Pseudostate connPt : RTCustomStateNavigationEditPolicy.this.getState().getConnectionPoints()) {
                        Rectangle connPtRect = RTCustomStateNavigationEditPolicy.this.getBounds(RTCustomStateNavigationEditPolicy.this.findChildNode(stateView, (EObject)connPt));
                        RelativePortLocation loc = RelativePortLocation.of((Rectangle)connPtRect, (Rectangle)stateRect);
                        String semanticHint = connPt.getKind() == PseudostateKind.ENTRY_POINT_LITERAL ? "Pseudostate_EntryPointShape" : "Pseudostate_ExitPointShape";
                        Node onFrame = ViewService.getInstance().createNode((IAdaptable)new SemanticAdapter((EObject)connPt, null), frame, semanticHint, -1, UMLDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                        Point moveTo = loc.applyTo(frameRect, IRTPseudostateEditPart.getDefaultSize(connPt.getKind()));
                        ViewUtil.setStructuralFeatureValue((View)onFrame, (EStructuralFeature)NotationPackage.Literals.LOCATION__X, (Object)moveTo.x());
                        ViewUtil.setStructuralFeatureValue((View)onFrame, (EStructuralFeature)NotationPackage.Literals.LOCATION__Y, (Object)moveTo.y());
                    }
                }
                return CommandResult.newOKCommandResult();
            }
        };
    }

    Rectangle getBounds(IGraphicalEditPart editPart) {
        return editPart.getFigure().getBounds().getCopy();
    }

    Node findChildNode(View parent, EObject element) {
        return parent.getChildren().stream().filter(Node.class::isInstance).map(Node.class::cast).filter(n -> n.getElement() == element).findFirst().get();
    }

    Rectangle getBounds(Node node) {
        Bounds result = (Bounds)node.getLayoutConstraint();
        return new Rectangle(result.getX(), result.getY(), result.getWidth(), result.getHeight());
    }

    private static /* synthetic */ Diagram lambda$0(ICommand iCommand) {
        return (Diagram)iCommand.getCommandResult().getReturnValue();
    }

    private static class ToggleCompartmentVisibilityCommand
    extends AbstractTransactionalCommand {
        private static final String CSS_CLASS = "cssClass";
        protected View view;
        protected boolean needsCreate;
        protected EStructuralFeature styleFeature;
        protected EditingDomain domain;
        protected Command command;
        protected StringListValueStyle style;
        boolean isPrepared = false;

        public ToggleCompartmentVisibilityCommand(IGraphicalEditPart part) {
            super(part.getEditingDomain(), "(Un)Apply Style", AbstractTransactionalCommand.getWorkspaceFiles((EObject)part.getPrimaryView()));
            this.view = part.getPrimaryView();
            this.domain = part.getEditingDomain();
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (!this.isPrepared) {
                this.prepare();
                this.isPrepared = true;
            }
            if (this.needsCreate) {
                this.view.getStyles().add((Object)this.style);
            }
            this.command.execute();
            return CommandResult.newOKCommandResult();
        }

        public boolean prepare() {
            this.style = (StringListValueStyle)this.view.getNamedStyle(NotationPackage.eINSTANCE.getStringListValueStyle(), CSS_CLASS);
            this.needsCreate = false;
            if (this.style == null) {
                this.needsCreate = true;
            }
            if (this.needsCreate) {
                this.style = NotationFactory.eINSTANCE.createStringListValueStyle();
                this.style.setName(CSS_CLASS);
            } else if (this.style.eResource() == null) {
                this.needsCreate = true;
            }
            this.command = !this.style.getStringListValue().contains((Object)"displayInternalTransitions") ? this.createCreationCommand() : this.createDeletionCommand();
            return this.command.canExecute();
        }

        protected Command createCreationCommand() {
            return AddCommand.create((EditingDomain)this.domain, (Object)this.style, (Object)NotationPackage.eINSTANCE.getStringListValueStyle_StringListValue(), (Object)"displayInternalTransitions", (int)-1);
        }

        protected Command createDeletionCommand() {
            return RemoveCommand.create((EditingDomain)this.domain, (Object)this.style, (Object)NotationPackage.eINSTANCE.getStringListValueStyle_StringListValue(), (Object)"displayInternalTransitions");
        }
    }
}

