/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.tracepointactions;

import java.util.Vector;
import org.eclipse.cdt.debug.core.breakpointactions.IBreakpointAction;
import org.eclipse.cdt.debug.ui.breakpointactions.IBreakpointActionPage;
import org.eclipse.cdt.debug.ui.breakpointactions.Messages;
import org.eclipse.cdt.dsf.gdb.internal.tracepointactions.CollectAction;
import org.eclipse.cdt.dsf.gdb.internal.tracepointactions.EvaluateAction;
import org.eclipse.cdt.dsf.gdb.internal.tracepointactions.ITracepointAction;
import org.eclipse.cdt.dsf.gdb.internal.tracepointactions.TracepointActionManager;
import org.eclipse.cdt.dsf.gdb.internal.tracepointactions.WhileSteppingAction;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.tracepointactions.MessagesForTracepointActions;
import org.eclipse.cdt.dsf.gdb.internal.ui.tracepointactions.TracepointGlobalActionsList;
import org.eclipse.cdt.dsf.gdb.internal.ui.tracepointactions.WhileSteppingActionPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TracepointActionDialog
extends Dialog {
    public static final String BREAKPOINT_ACTION_PAGE_EXTENSION_POINT_ID = "BreakpointActionPage";
    private static final String ACTION_PAGE_ELEMENT = "actionPage";
    private static final String TRACEPOINT_ACTION_DIALOG_LAST_SELECTED = "TracepointActionDialog.lastSelectedAction";
    private static final int TRACEPOINT_ACTIONS_COUNT = 3;
    private Composite actionArea;
    private Composite[] actionComposites;
    private ITracepointAction tracepointAction;
    private IBreakpointActionPage actionPage;
    private Vector<ITracepointAction> tracepointActions;
    private IBreakpointActionPage[] actionPages;
    private String actionName;
    private Text actionNameTextWidget;
    private Combo combo;
    private Composite dialogArea;
    private int lastSelectedActionTypeIndex;
    private IBreakpointAction originalAction;
    private boolean isSubAction;
    private TracepointGlobalActionsList parentGlobalList;
    private IExtension[] breakpointActionPageExtensions;
    private static final Point MINIMUM_SIZE = new Point(440, 540);

    public TracepointActionDialog(Shell parentShell, ITracepointAction action, TracepointGlobalActionsList parentList, boolean isSub) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
        this.originalAction = action;
        this.tracepointAction = action;
        this.lastSelectedActionTypeIndex = 0;
        this.isSubAction = isSub;
        this.parentGlobalList = parentList;
    }

    protected void cancelPressed() {
        this.actionPage.actionDialogCanceled();
        super.cancelPressed();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.originalAction == null) {
            newShell.setText(MessagesForTracepointActions.TracepointActions_ActionDialog_New);
        } else {
            newShell.setText(this.originalAction.getName());
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(final Composite parent) {
        this.dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.dialogArea.setLayout((Layout)gridLayout);
        Label actionNameLabel = new Label(this.dialogArea, 0);
        actionNameLabel.setText(MessagesForTracepointActions.TracepointActions_ActionDialog_Name);
        this.actionNameTextWidget = new Text(this.dialogArea, 2048);
        this.addDecorator(this.dialogArea, this.actionNameTextWidget);
        Label breakpointActionTypeLabel = new Label(this.dialogArea, 0);
        breakpointActionTypeLabel.setText(MessagesForTracepointActions.TracepointActions_ActionDialog_Type);
        this.combo = new Combo(this.dialogArea, 8);
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    TracepointActionDialog.this.showActionComposite();
                    Point p = parent.computeSize(MINIMUM_SIZE.x, MINIMUM_SIZE.y);
                    TracepointActionDialog.this.getShell().setSize(TracepointActionDialog.this.getShell().computeSize(p.x, p.y));
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        });
        this.combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.tracepointActions = new Vector(3);
        this.tracepointActions.add((ITracepointAction)new CollectAction());
        this.tracepointActions.add((ITracepointAction)new EvaluateAction());
        if (!this.isSubAction) {
            this.tracepointActions.add((ITracepointAction)new WhileSteppingAction());
        }
        this.actionPages = new IBreakpointActionPage[3];
        this.actionComposites = new Composite[3];
        if (!this.tracepointActions.isEmpty()) {
            String lastTypeName = GdbUIPlugin.getDefault().getPreferenceStore().getString(TRACEPOINT_ACTION_DIALOG_LAST_SELECTED);
            if (this.tracepointAction != null) {
                lastTypeName = this.tracepointAction.getTypeName();
                this.actionName = this.tracepointAction.getName();
            }
            int i = 0;
            while (i < this.tracepointActions.size()) {
                this.tracepointActions.get(i).setName(this.tracepointActions.get(i).getDefaultName());
                String actionTypeName = this.tracepointActions.get(i).getTypeName();
                this.combo.add(actionTypeName);
                if (actionTypeName.equals(lastTypeName)) {
                    this.lastSelectedActionTypeIndex = i;
                    if (this.tracepointAction != null) {
                        this.tracepointActions.add(i, this.tracepointAction);
                        this.tracepointActions.remove(i + 1);
                    }
                }
                ++i;
            }
            this.combo.select(this.lastSelectedActionTypeIndex);
            if (this.originalAction != null) {
                this.combo.setEnabled(false);
            }
            this.actionArea = new Composite(this.dialogArea, 0);
            this.actionArea.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
            this.actionArea.setLayout((Layout)new StackLayout());
            try {
                this.showActionComposite();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return this.dialogArea;
    }

    public IBreakpointAction getTracepointAction() {
        return this.tracepointAction;
    }

    public String getActionName() {
        return this.actionName;
    }

    protected Point getInitialSize() {
        return MINIMUM_SIZE;
    }

    protected void okPressed() {
        if (this.originalAction == null) {
            GdbUIPlugin.getDefault().getPreferenceStore().setValue(TRACEPOINT_ACTION_DIALOG_LAST_SELECTED, this.tracepointAction.getTypeName());
        }
        String newName = this.actionNameTextWidget.getText();
        if (this.originalAction == null || !this.originalAction.getName().equals(newName)) {
            this.actionName = TracepointActionManager.getInstance().makeUniqueActionName(newName);
            this.tracepointAction.setName(this.actionName);
        }
        this.actionPage.actionDialogOK();
        super.okPressed();
    }

    void showActionComposite() throws CoreException {
        int selectedTypeIndex;
        this.lastSelectedActionTypeIndex = selectedTypeIndex = this.combo.getSelectionIndex();
        this.tracepointAction = this.tracepointActions.get(selectedTypeIndex);
        this.actionPage = this.actionPages[selectedTypeIndex];
        if (this.actionPage == null) {
            this.actionPages[selectedTypeIndex] = this.getActionPage((IBreakpointAction)this.tracepointActions.get(selectedTypeIndex));
            this.actionPage = this.actionPages[selectedTypeIndex];
            if (this.actionPage instanceof WhileSteppingActionPage) {
                ((WhileSteppingActionPage)this.actionPage).setParentGlobalList(this.parentGlobalList);
            }
        }
        if (this.actionComposites[selectedTypeIndex] == null) {
            Composite actionComposite;
            this.actionComposites[selectedTypeIndex] = actionComposite = this.actionPages[selectedTypeIndex].createComposite((IBreakpointAction)this.tracepointAction, this.actionArea, 0);
        }
        this.actionName = this.tracepointAction.getName();
        this.actionNameTextWidget.setText(this.actionName);
        StackLayout stacklayout = (StackLayout)this.actionArea.getLayout();
        stacklayout.topControl = this.actionComposites[selectedTypeIndex];
        this.actionArea.layout();
    }

    public IExtension[] getBreakpointActionPageExtensions() {
        if (this.breakpointActionPageExtensions == null) {
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.debug.ui", BREAKPOINT_ACTION_PAGE_EXTENSION_POINT_ID);
            this.breakpointActionPageExtensions = point == null ? new IExtension[0] : point.getExtensions();
        }
        return this.breakpointActionPageExtensions;
    }

    private IBreakpointActionPage getActionPage(IBreakpointAction breakpointAction) {
        IExtension[] actionExtensions = this.getBreakpointActionPageExtensions();
        IBreakpointActionPage actionPageResult = null;
        try {
            int i = 0;
            while (i < actionExtensions.length && actionPageResult == null) {
                IConfigurationElement[] elements = actionExtensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length && actionPageResult == null) {
                    IConfigurationElement element = elements[j];
                    if (element.getName().equals(ACTION_PAGE_ELEMENT) && element.getAttribute("actionType").equals(breakpointAction.getIdentifier())) {
                        actionPageResult = (IBreakpointActionPage)element.createExecutableExtension("class");
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return actionPageResult;
    }

    private void addDecorator(Composite parent, final Text control) {
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalIndent = FieldDecorationRegistry.getDefault().getMaximumDecorationWidth();
        control.setLayoutData((Object)gd);
        final ControlDecoration decoration = new ControlDecoration((Control)control, 16512, parent);
        decoration.hide();
        control.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String name = control.getText();
                if (name.trim().isEmpty()) {
                    decoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
                    decoration.setDescriptionText(Messages.getString((String)"ActionDialog.ErrEmptyName"));
                    decoration.show();
                } else {
                    decoration.hide();
                }
                TracepointActionDialog.this.validate();
            }
        });
    }

    private void validate() {
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(!this.actionNameTextWidget.getText().trim().isEmpty());
        }
    }
}

