/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.papyrus.cdt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrusrt.codegen.CodeGenPlugin;
import org.eclipse.papyrusrt.codegen.IEObjectLocator;
import org.eclipse.papyrusrt.codegen.UserEditableRegion;
import org.eclipse.papyrusrt.umlrt.core.utils.CodeSnippetUtils;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.Vertex;

public class UMLEObjectLocator
implements IEObjectLocator {
    public static final String LANGUAGE = "C++";
    private ModelSet modelSet = new ModelSet();

    private Package getRoot(String uri) {
        Package result = null;
        URI resourceUri = URI.createURI((String)uri);
        if ("uml".equals(resourceUri.fileExtension())) {
            Resource r = this.modelSet.getResource(resourceUri, true);
            result = (Package)EcoreUtil.getObjectByType((Collection)r.getContents(), (EClassifier)UMLPackage.Literals.PACKAGE);
        }
        return result;
    }

    public EObject getEObject(UserEditableRegion.Label label) {
        ArrayList<String> qualifiedNames = new ArrayList<String>();
        qualifiedNames.addAll(Arrays.asList(label.getQualifiedName().split("::")));
        Package nextPackage = this.getRoot(label.getUri());
        if (nextPackage == null) {
            return null;
        }
        Class capsuleOrClass = null;
        qualifiedNames.remove(0);
        while (!qualifiedNames.isEmpty()) {
            String qname = (String)qualifiedNames.remove(0);
            Package pkg = nextPackage.getNestedPackage(qname);
            if (pkg == null) {
                capsuleOrClass = (Class)nextPackage.getPackagedElement(qname, false, UMLPackage.Literals.CLASS, false);
                break;
            }
            nextPackage = pkg;
        }
        EObject result = null;
        if (capsuleOrClass == null) {
            CodeGenPlugin.error((String)("Element not found : " + label.getQualifiedName()));
        } else if (label.getType().equals(UMLPackage.Literals.OPERATION.getName().toLowerCase())) {
            Operation op = capsuleOrClass.getOwnedOperation(label.getDetails(), null, null);
            OpaqueBehavior method = null;
            if (op.getMethods().isEmpty()) {
                method = (OpaqueBehavior)capsuleOrClass.createOwnedBehavior(null, UMLPackage.Literals.OPAQUE_BEHAVIOR);
                op.getMethods().add((Object)method);
            } else {
                method = (OpaqueBehavior)op.getMethods().get(0);
            }
            if (!method.getLanguages().contains((Object)LANGUAGE)) {
                method.getLanguages().add((Object)LANGUAGE);
            }
            result = method;
        } else {
            EObject smElement = this.getSMElement(capsuleOrClass, qualifiedNames);
            result = this.getUserCodeElement(smElement, label.getType(), label.getDetails());
        }
        return result;
    }

    private EObject getUserCodeElement(EObject container, String type, String details) {
        Behavior result = null;
        if (type.equals(UMLPackage.Literals.TRANSITION.getName().toLowerCase())) {
            Transition t = this.getTransition(container, details);
            if (t != null) {
                result = t.getEffect();
            }
        } else if (type.equals(UMLPackage.Literals.STATE__ENTRY.getName())) {
            if (container instanceof State) {
                State s = (State)container;
                result = s.getEntry();
            }
        } else if (type.equals(UMLPackage.Literals.STATE__EXIT.getName())) {
            if (container instanceof State) {
                State s = (State)container;
                result = s.getExit();
            }
        } else if (type.equals(UMLPackage.Literals.TRANSITION__GUARD.getName())) {
            Transition t = this.getTransition(container, details);
            if (t != null) {
                result = t.getGuard();
            }
        } else if (type.equals(UMLPackage.Literals.TRANSITION__TRIGGER.getName())) {
            String[] tokens = details.split(">>");
            Transition transition = this.getTransition(container, tokens[0]);
            UserEditableRegion.TriggerDetail tdetail = new UserEditableRegion.TriggerDetail(tokens[1]);
            Trigger trigger = null;
            for (Trigger t : transition.getTriggers()) {
                Operation message;
                Event event = t.getEvent();
                if (event == null || !(event instanceof CallEvent) || (message = ((CallEvent)event).getOperation()) == null || !tdetail.getSignal().equals(message.getName()) || !this.comparetriggerPorts((List<Port>)t.getPorts(), tdetail.getPorts())) continue;
                trigger = t;
                break;
            }
            if (trigger != null) {
                result = CodeSnippetUtils.getTriggerGuard(trigger);
            }
        }
        return result;
    }

    private EObject getSMElement(Class capsuleOrClass, List<String> qnameRelativeToSM) {
        Region r;
        StateMachine sm = (StateMachine)capsuleOrClass.getOwnedBehaviors().get(0);
        Region nextRegion = r = (Region)sm.getRegions().get(0);
        StateMachine result = sm;
        while (!qnameRelativeToSM.isEmpty()) {
            Vertex v = nextRegion.getSubvertex(qnameRelativeToSM.remove(0));
            if (v == null) {
                CodeGenPlugin.error((String)"No matching element found.");
                break;
            }
            if (!((State)v).getRegions().isEmpty()) {
                nextRegion = (Region)((State)v).getRegions().get(0);
            }
            result = v;
        }
        if (!qnameRelativeToSM.isEmpty()) {
            CodeGenPlugin.error((String)"No matching element found");
            result = null;
        }
        return result;
    }

    private Transition getTransition(EObject container, String transitionDetails) {
        Transition result = null;
        Region region = null;
        region = container instanceof StateMachine ? (Region)((StateMachine)container).getRegions().get(0) : (Region)((State)container).getRegions().get(0);
        if (region != null) {
            UserEditableRegion.TransitionDetails details = new UserEditableRegion.TransitionDetails(transitionDetails);
            for (Transition t : region.getTransitions()) {
                if (!UMLEObjectLocator.getSMQualifiedName((EObject)t.getSource()).equals(details.getSourceQname()) || !UMLEObjectLocator.getSMQualifiedName((EObject)t.getTarget()).equals(details.getTargetQname())) continue;
                if (details.getTriggerDetails().isEmpty()) {
                    result = t;
                    break;
                }
                if (details.getTriggerDetails().size() != t.getTriggers().size()) continue;
                boolean found = false;
                for (UserEditableRegion.TriggerDetail detail : details.getTriggerDetails()) {
                    found = false;
                    for (Trigger trigger : t.getTriggers()) {
                        Operation message;
                        Event event = trigger.getEvent();
                        if (event == null || !(event instanceof CallEvent) || (message = ((CallEvent)event).getOperation()) == null || !detail.getSignal().equals(message.getName()) || !this.comparetriggerPorts((List<Port>)trigger.getPorts(), detail.getPorts())) continue;
                        found = true;
                        break;
                    }
                    if (!found) break;
                }
                if (!found) continue;
                result = t;
                break;
            }
        }
        return result;
    }

    private boolean comparetriggerPorts(List<Port> ports, List<String> expectedPorts) {
        ArrayList<String> actualPorts = new ArrayList<String>();
        for (Port p : ports) {
            actualPorts.add(p.getName());
        }
        actualPorts.retainAll(expectedPorts);
        return actualPorts.size() == expectedPorts.size();
    }

    public static String getSMQualifiedName(EObject eObject) {
        String result = "";
        EObject container = eObject;
        while (container != null && !(container instanceof StateMachine)) {
            if (container instanceof Vertex) {
                if (result.length() != 0) {
                    result = "::" + result;
                }
                result = String.valueOf(((Vertex)container).getName()) + result;
            }
            container = container.eContainer();
        }
        return result;
    }

    public EObject saveSource(UserEditableRegion.Label label, String source) {
        Constraint guard;
        ValueSpecification value;
        EObject eo = this.getEObject(label);
        if (eo instanceof OpaqueBehavior) {
            OpaqueBehavior ob = (OpaqueBehavior)eo;
            ob.getBodies().clear();
            ob.getBodies().add((Object)source);
        } else if (eo instanceof Constraint && (value = (guard = (Constraint)eo).getSpecification()) instanceof OpaqueExpression) {
            ((OpaqueExpression)value).getBodies().clear();
            ((OpaqueExpression)value).getBodies().add((Object)source);
        }
        return eo;
    }
}

