/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.papyrus.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrusrt.codegen.CodeGenPlugin;
import org.eclipse.papyrusrt.codegen.UserEditableRegion;
import org.eclipse.papyrusrt.codegen.papyrus.UMLRTGenerator;
import org.eclipse.papyrusrt.codegen.papyrus.cdt.EditorUtil;
import org.eclipse.papyrusrt.codegen.papyrus.cdt.UMLEObjectLocator;
import org.eclipse.papyrusrt.codegen.papyrus.internal.UMLRTCppCodeGen;
import org.eclipse.papyrusrt.umlrt.core.utils.CodeSnippetUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.NewElementUtil;
import org.eclipse.papyrusrt.umlrt.core.utils.StateUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.UMLPackage;

public class EditSourceAction
extends Action {
    private String label;
    private EObject context;

    public EditSourceAction(EObject context, String label) {
        this.label = label;
        this.context = context;
    }

    public String getText() {
        return this.label;
    }

    public void run() {
        IFile file = this.getFile((NamedElement)this.context);
        UserEditableRegion.Label tag = this.getLabel(this.context);
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.context);
        if (this.context.eClass().equals(UMLPackage.Literals.STATE)) {
            if ("Entry Code".equals(this.label)) {
                tag.setType(UMLPackage.Literals.STATE__ENTRY.getName());
            } else {
                tag.setType(UMLPackage.Literals.STATE__EXIT.getName());
            }
        } else if (this.context instanceof Transition) {
            if ("Transition Guard Code".equals(this.label)) {
                tag.setType(UMLPackage.Literals.TRANSITION__GUARD.getName().toLowerCase());
            }
        } else if (this.context instanceof Trigger) {
            tag.setType(UMLPackage.Literals.TRANSITION__TRIGGER.getName().toLowerCase());
        }
        Command command = this.getCreateCommand(domain);
        if (command != null && command.canExecute()) {
            domain.getCommandStack().execute(command);
            try {
                ModelSet modelSet = ServiceUtils.getInstance().getModelSet(null);
                if (modelSet != null) {
                    modelSet.save((IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (IOException | ServiceException e) {
                CodeGenPlugin.error((Throwable)e);
            }
        }
        EObject root = EcoreUtil.getRootContainer((EObject)this.context);
        String top = UMLRTCppCodeGen.getTopCapsuleName((Element)root);
        IStatus result = UMLRTGenerator.getInstance().generate(Collections.singletonList(root), top, true);
        if (result.getSeverity() == 4) {
            MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 33);
            messageBox.setText("Error");
            messageBox.setMessage("Code generation failed!");
            messageBox.open();
        } else {
            MultiStatus rc = new MultiStatus("org.eclipse.papyrusrt.codegen.papyrus", 0, "Edit Source Action Status", null);
            EditorUtil.openEditor(file, tag, rc);
        }
    }

    private Command getCreateCommand(TransactionalEditingDomain domain) {
        Trigger trigger;
        RecordingCommand result = null;
        if (this.context.eClass().equals(UMLPackage.Literals.STATE)) {
            final State state = (State)this.context;
            if ("Entry Code".equals(this.label) && state.getEntry() == null) {
                result = new RecordingCommand(domain, "New Entry"){

                    protected void doExecute() {
                        OpaqueBehavior action = CodeSnippetUtils.createOpaqueBehaviorWithDefaultLanguage((Element)state);
                        action.setName(NewElementUtil.getUniqueName((NamedElement)action, (String)"onEntry"));
                        state.setEntry((Behavior)action);
                    }
                };
            } else if (state.getExit() == null) {
                result = new RecordingCommand(domain, "New Exit"){

                    protected void doExecute() {
                        OpaqueBehavior action = CodeSnippetUtils.createOpaqueBehaviorWithDefaultLanguage((Element)state);
                        action.setName(NewElementUtil.getUniqueName((NamedElement)action, (String)"onExit"));
                        state.setExit((Behavior)action);
                    }
                };
            }
        } else if (this.context instanceof Transition) {
            final Transition transition = (Transition)this.context;
            if ("Transition Guard Code".equals(this.label) && transition.getGuard() == null) {
                result = new RecordingCommand(domain, "New Guard"){

                    protected void doExecute() {
                        Constraint guard = CodeSnippetUtils.createGuard((Namespace)transition);
                        transition.setGuard(guard);
                    }
                };
            } else if (transition.getEffect() == null) {
                result = new RecordingCommand(domain, "New Effect"){

                    protected void doExecute() {
                        OpaqueBehavior action = CodeSnippetUtils.createOpaqueBehaviorWithDefaultLanguage((Element)transition);
                        transition.setEffect((Behavior)action);
                    }
                };
            }
        } else if (this.context instanceof Trigger && CodeSnippetUtils.getTriggerGuard((Trigger)(trigger = (Trigger)this.context)) == null) {
            result = new RecordingCommand(domain, "New Trigger Guard"){

                protected void doExecute() {
                    CodeSnippetUtils.createGuard((Namespace)((Transition)trigger.eContainer()), Collections.singletonList(trigger));
                }
            };
        }
        return result;
    }

    public UserEditableRegion.Label getLabel(EObject context) {
        UserEditableRegion.Label label = new UserEditableRegion.Label();
        label.setQualifiedName(this.getParentQualifiedName(context));
        if (context instanceof Transition) {
            label.setType(UMLPackage.Literals.TRANSITION.getName().toLowerCase());
            label.setDetails(this.getTransitionDetails((Transition)context));
        } else if (context.eClass().equals(UMLPackage.Literals.OPERATION)) {
            label.setType(UMLPackage.Literals.OPERATION.getName().toLowerCase());
            label.setDetails(((Operation)context).getName());
        } else if (context.eClass().equals(UMLPackage.Literals.STATE)) {
            label.setQualifiedName(String.valueOf(label.getQualifiedName()) + "::" + ((State)context).getName());
        } else if (context instanceof Trigger) {
            Transition transition = (Transition)context.eContainer();
            label.setQualifiedName(this.getParentQualifiedName((EObject)transition));
            String details = this.getTransitionDetails(transition);
            details.concat(">>" + this.getTriggerDetails((Trigger)context));
            label.setDetails(details);
        }
        label.setUri(context.eResource().getURI().toString());
        return label;
    }

    public String getTransitionDetails(Transition transition) {
        EObject sourceVertex = this.getImplicitVertex((EObject)transition.getSource());
        EObject targetVertex = this.getImplicitVertex((EObject)transition.getTarget());
        String sourceQname = UMLEObjectLocator.getSMQualifiedName(sourceVertex);
        String targetQname = UMLEObjectLocator.getSMQualifiedName(targetVertex);
        UserEditableRegion.TransitionDetails details = new UserEditableRegion.TransitionDetails(sourceQname, targetQname);
        for (Trigger t : transition.getTriggers()) {
            Operation message;
            ArrayList<String> ports = new ArrayList<String>();
            for (Port p : t.getPorts()) {
                ports.add(p.getName());
            }
            Event event = t.getEvent();
            if (event == null || !(event instanceof CallEvent) || (message = ((CallEvent)event).getOperation()) == null || message.getName() == null) continue;
            details.addTriggerDetail(message.getName(), ports);
        }
        return details.getTagString();
    }

    public String getTriggerDetails(Trigger trigger) {
        Operation message;
        ArrayList<String> ports = new ArrayList<String>();
        for (Port p : trigger.getPorts()) {
            ports.add(p.getName());
        }
        Event event = trigger.getEvent();
        if (event != null && event instanceof CallEvent && (message = ((CallEvent)event).getOperation()) != null && message.getName() != null) {
            UserEditableRegion.TriggerDetail detail = new UserEditableRegion.TriggerDetail(message.getName(), ports);
            return detail.getTagString();
        }
        return "";
    }

    private EObject getImplicitVertex(EObject vertex) {
        PseudostateKind kind;
        if (vertex instanceof Pseudostate && ((kind = ((Pseudostate)vertex).getKind()) == PseudostateKind.ENTRY_POINT_LITERAL || kind == PseudostateKind.EXIT_POINT_LITERAL)) {
            return vertex.eContainer();
        }
        return vertex;
    }

    public String getParentQualifiedName(EObject object) {
        ArrayList<String> names = new ArrayList<String>();
        EObject container = object.eContainer();
        while (container != null) {
            if (container instanceof State && StateUtils.isRTState((State)((State)container))) {
                names.add(0, ((State)container).getName());
            } else if (container instanceof Class && !(container instanceof StateMachine)) {
                names.add(0, ((Class)container).getName());
            } else if (container instanceof Package) {
                names.add(0, ((Package)container).getName());
            }
            container = container.eContainer();
        }
        return String.join((CharSequence)"::", names);
    }

    public IFile getFile(NamedElement element) {
        IProject project = UMLRTGenerator.getInstance().getProject((EObject)element);
        Class clazz = null;
        NamedElement container = element;
        while (container != null) {
            if (container instanceof Class && !(container instanceof StateMachine)) {
                clazz = (Class)container;
                break;
            }
            container = container.eContainer();
        }
        if (clazz != null) {
            IFolder srcFolder = project.getFolder("src");
            return srcFolder.getFile(String.valueOf(clazz.getName()) + ".cc");
        }
        return null;
    }
}

