/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.util.DiagramEditPartsUtil;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.uml2.uml.ExecutionOccurrenceSpecification;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.PartDecomposition;

public class FragmentsOrderer {
    private static final float HALF_UNIT = 0.5f;
    private static final float CONVERT_UNIT = 1.0f;
    private InteractionFragment fragmentRoot;
    private IGraphicalEditPart fragmentRootEditPart;
    private Map<InteractionFragment, Float> fragmentPositions;
    private Map<InteractionFragment, Integer> fragmentIndexes;
    private Map<View, Float[]> cachePositions;

    public FragmentsOrderer(IGraphicalEditPart fragmentRootEditPart) {
        this.fragmentRootEditPart = fragmentRootEditPart;
    }

    public void addCachePosition(View view, Float[] position) {
        if (this.cachePositions == null) {
            this.cachePositions = new HashMap<View, Float[]>(1);
        }
        this.cachePositions.put(view, position);
    }

    private boolean prepared() {
        if (this.fragmentRootEditPart == null) {
            return false;
        }
        EObject element = this.fragmentRootEditPart.resolveSemanticElement();
        if (!(element instanceof Interaction) && !(element instanceof InteractionOperand)) {
            return false;
        }
        this.fragmentRoot = (InteractionFragment)element;
        this.fragmentPositions = new HashMap<InteractionFragment, Float>();
        this.fragmentIndexes = new HashMap<InteractionFragment, Integer>();
        EList<InteractionFragment> orderingFragments = this.getOrderingFragments();
        return orderingFragments != null && !orderingFragments.isEmpty();
    }

    private void computeNewIndexes() {
        this.fragmentIndexes.clear();
        this.computePositions();
        ArrayList<Map.Entry<InteractionFragment, Float>> positionalEntries = new ArrayList<Map.Entry<InteractionFragment, Float>>(this.fragmentPositions.entrySet());
        Collections.sort(positionalEntries, new Comparator<Map.Entry<InteractionFragment, Float>>(){

            @Override
            public int compare(Map.Entry<InteractionFragment, Float> o1, Map.Entry<InteractionFragment, Float> o2) {
                Float v1 = o1.getValue();
                Float v2 = o2.getValue();
                if (v1 != null && v2 != null) {
                    if (v1.floatValue() < v2.floatValue()) {
                        return -1;
                    }
                    if (v1.floatValue() > v2.floatValue()) {
                        return 1;
                    }
                }
                return 0;
            }
        });
        int i = 0;
        while (i < positionalEntries.size()) {
            Map.Entry entry = (Map.Entry)positionalEntries.get(i);
            this.fragmentIndexes.put((InteractionFragment)entry.getKey(), i);
            ++i;
        }
    }

    private EList<InteractionFragment> getOrderingFragments() {
        EList fragments = null;
        if (this.fragmentRoot instanceof Interaction) {
            fragments = ((Interaction)this.fragmentRoot).getFragments();
        } else if (this.fragmentRoot instanceof InteractionOperand) {
            fragments = ((InteractionOperand)this.fragmentRoot).getFragments();
        }
        return fragments;
    }

    private View getGraphicalView(EObject eObj) {
        if (eObj instanceof ExecutionOccurrenceSpecification) {
            ExecutionSpecification execution = ((ExecutionOccurrenceSpecification)eObj).getExecution();
            return this.getGraphicalView((EObject)execution);
        }
        if (eObj instanceof MessageOccurrenceSpecification) {
            return this.getGraphicalView((EObject)((MessageOccurrenceSpecification)eObj).getMessage());
        }
        if (eObj instanceof PartDecomposition) {
            EList covereds = ((PartDecomposition)eObj).getCovereds();
            if (covereds.size() == 1) {
                return this.getGraphicalView((EObject)covereds.get(0));
            }
        } else if (eObj != null) {
            List views = DiagramEditPartsUtil.getEObjectViews((EObject)eObj);
            if (views.size() == 1) {
                return (View)views.get(0);
            }
            return null;
        }
        return null;
    }

    private Float getPosition(InteractionFragment fragment) {
        Rectangle bounds;
        if (fragment == null) {
            return null;
        }
        View view = this.getGraphicalView((EObject)fragment);
        if (view == null) {
            return null;
        }
        Float[] preferPosition = this.cachePositions != null ? this.cachePositions.get(view) : null;
        EObject hostElement = ViewUtil.resolveSemanticElement((View)view);
        EditPart editPart = DiagramEditPartsUtil.getEditPartFromView((View)view, (EditPart)this.fragmentRootEditPart);
        if (fragment instanceof MessageOccurrenceSpecification && hostElement instanceof Message && editPart instanceof ConnectionNodeEditPart) {
            boolean isStart = fragment == ((Message)hostElement).getSendEvent();
            Point location = this.getAbsoluteEdgeExtremity((ConnectionNodeEditPart)editPart, isStart, preferPosition);
            if (location != null) {
                return Float.valueOf(isStart ? (float)location.y - 0.5f : (float)location.y + 0.5f);
            }
        } else if (fragment instanceof ExecutionOccurrenceSpecification && hostElement instanceof ExecutionSpecification && editPart instanceof IGraphicalEditPart) {
            Rectangle bounds2 = this.getAbsoluteBounds((IGraphicalEditPart)editPart, preferPosition);
            if (bounds2 != null) {
                if (bounds2.height <= 0) {
                    bounds2.height = 50;
                }
                if (fragment == ((ExecutionSpecification)hostElement).getStart()) {
                    return Float.valueOf((float)bounds2.y - 0.5f);
                }
                return Float.valueOf((float)bounds2.bottom() + 0.5f);
            }
        } else if (view instanceof Shape && editPart instanceof IGraphicalEditPart && (bounds = this.getAbsoluteBounds((IGraphicalEditPart)editPart, preferPosition)) != null) {
            return Float.valueOf((float)bounds.y * 1.0f);
        }
        return null;
    }

    private Point getAbsoluteEdgeExtremity(ConnectionNodeEditPart editPart, boolean isStart, Float[] preferPosition) {
        if (editPart == null) {
            return null;
        }
        PointList points = editPart.getConnectionFigure().getPoints().getCopy();
        if (points.size() == 2 && new Point(0, 0).equals((Object)points.getFirstPoint()) && new Point(100, 100).equals((Object)points.getLastPoint())) {
            if (preferPosition != null) {
                if (isStart && preferPosition[0] != null) {
                    return new Point(0, preferPosition[0].intValue());
                }
                if (!isStart && preferPosition[1] != null) {
                    return new Point(0, preferPosition[1].intValue());
                }
            }
            return SequenceUtil.getAbsoluteEdgeExtremity(editPart, isStart, false);
        }
        return SequenceUtil.getAbsoluteEdgeExtremity(editPart, isStart, true);
    }

    private Rectangle getAbsoluteBounds(IGraphicalEditPart editPart, Float[] preferPosition) {
        if (editPart == null) {
            return null;
        }
        Rectangle rect = editPart.getFigure().getBounds().getCopy();
        if (rect.isEmpty() && rect.x == 0 && rect.y == 0) {
            LayoutConstraint constraint;
            View view = editPart.getNotationView();
            if (view instanceof Node && (constraint = ((Node)view).getLayoutConstraint()) instanceof Bounds) {
                Bounds bounds = (Bounds)constraint;
                if (bounds.getX() > 0) {
                    rect.x = bounds.getX();
                }
                if (bounds.getY() > 0) {
                    rect.y = bounds.getY();
                } else if (preferPosition != null && preferPosition.length > 0 && preferPosition[0] != null) {
                    rect.y = preferPosition[0].intValue();
                }
                if (bounds.getWidth() != -1) {
                    rect.width = bounds.getWidth();
                }
                if (bounds.getHeight() != -1) {
                    rect.height = bounds.getHeight();
                }
            }
            Rectangle parentRect = this.getAbsoluteBounds((IGraphicalEditPart)editPart.getParent(), null);
            rect.x += parentRect.x;
            rect.y += parentRect.y;
        } else {
            rect = SequenceUtil.getAbsoluteBounds(editPart);
        }
        return rect;
    }

    public void ordering() {
        if (this.prepared()) {
            this.safelyChangeOrder();
        }
        this.clear();
    }

    protected void computePositions() {
        EList<InteractionFragment> orderingFragments = this.getOrderingFragments();
        if (orderingFragments == null || orderingFragments.isEmpty()) {
            return;
        }
        for (InteractionFragment fragment : orderingFragments) {
            Float newPos = this.getPosition(fragment);
            this.fragmentPositions.put(fragment, newPos);
        }
    }

    private void clear() {
        if (this.fragmentIndexes != null) {
            this.fragmentIndexes.clear();
            this.fragmentIndexes = null;
        }
        if (this.fragmentPositions != null) {
            this.fragmentPositions.clear();
            this.fragmentPositions = null;
        }
        this.fragmentRoot = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void safelyChangeOrder() {
        EList<InteractionFragment> orderingFragments;
        EList<InteractionFragment> eList = orderingFragments = this.getOrderingFragments();
        synchronized (eList) {
            this.computeNewIndexes();
            for (InteractionFragment fragment : new ArrayList<InteractionFragment>((Collection<InteractionFragment>)orderingFragments)) {
                Integer newPos;
                int oldPos = orderingFragments.indexOf((Object)fragment);
                if (oldPos == -1 || (newPos = this.fragmentIndexes.get(fragment)) == null || oldPos == newPos || newPos < 0 || newPos >= orderingFragments.size()) continue;
                orderingFragments.move(newPos.intValue(), oldPos);
            }
        }
    }
}

