/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.infra.tools.util.StringHelper;
import org.eclipse.papyrus.uml.tools.utils.MultiplicityElementUtil;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.papyrus.uml.tools.utils.PropertyUtil;
import org.eclipse.papyrus.uml.tools.utils.ValueSpecificationUtil;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.ValueSpecification;

public class SignalUtil {
    private static String getCustomPropertyLabel(Message e, Property property, Collection<String> displayValue) {
        boolean multiLine;
        String modifiers;
        StringBuffer buffer = new StringBuffer();
        buffer.append(" ");
        if (displayValue.contains("visibility")) {
            buffer.append(NamedElementUtil.getVisibilityAsSign((NamedElement)property));
        }
        if (displayValue.contains("derived") && property.isDerived()) {
            buffer.append("/");
        }
        boolean showEqualMark = false;
        if (displayValue.contains("parametersName")) {
            buffer.append(" ");
            String name = StringHelper.trimToEmpty((String)property.getName());
            if (name.trim().length() > 0) {
                showEqualMark = true;
            }
            buffer.append(name);
        }
        if (displayValue.contains("parametersType")) {
            if (property.getType() != null) {
                buffer.append(": " + StringHelper.trimToEmpty((String)property.getType().getName()));
            } else {
                buffer.append(": <Undefined>");
            }
            showEqualMark = true;
        }
        if (displayValue.contains("multiplicity")) {
            String multiplicity = MultiplicityElementUtil.getMultiplicityAsString((MultiplicityElement)property);
            buffer.append(multiplicity);
        }
        if (displayValue.contains("derived")) {
            String value = SignalUtil.getValue(e, property);
            if (value != null) {
                if (showEqualMark) {
                    buffer.append(" = ");
                }
                buffer.append(value);
            }
        } else if (displayValue.contains("parametersDefault") && property.getDefaultValue() != null) {
            if (showEqualMark) {
                buffer.append(" = ");
            }
            buffer.append(ValueSpecificationUtil.getSpecificationValue((ValueSpecification)property.getDefaultValue()));
        }
        if (displayValue.contains("modifiers") && !(modifiers = PropertyUtil.getModifiersAsString((Property)property, (boolean)(multiLine = displayValue.contains("multiline")))).equals("")) {
            if (multiLine) {
                buffer.append("\n");
            }
            if (!buffer.toString().endsWith(" ")) {
                buffer.append(" ");
            }
            buffer.append(modifiers);
        }
        return buffer.toString();
    }

    private static String getValue(Message e, Property property) {
        try {
            Signal signal = (Signal)property.getOwner();
            int index = signal.getOwnedAttributes().indexOf((Object)property);
            EList arguments = e.getArguments();
            if (arguments.size() > index) {
                return ValueSpecificationUtil.getSpecificationValue((ValueSpecification)((ValueSpecification)arguments.get(index)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getCustomLabel(Message message, Signal signal, Collection<String> displayValue) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(" ");
        if (displayValue.contains("visibility")) {
            buffer.append(NamedElementUtil.getVisibilityAsSign((NamedElement)signal));
        }
        if (displayValue.contains("name")) {
            buffer.append(" ");
            buffer.append(StringHelper.trimToEmpty((String)signal.getName()));
        }
        buffer.append("(");
        buffer.append(SignalUtil.getPropertiesAsString(message, signal, displayValue));
        buffer.append(")");
        return buffer.toString();
    }

    private static String getPropertiesAsString(Message e, Signal signal, Collection<String> displayValue) {
        StringBuffer propertiesString = new StringBuffer();
        boolean firstProperty = true;
        for (Property property : signal.getOwnedAttributes()) {
            String propertyString = SignalUtil.getCustomPropertyLabel(e, property, displayValue).trim();
            if (propertyString.equals("")) continue;
            if (!firstProperty) {
                propertiesString.append(", ");
            }
            propertiesString.append(propertyString);
            firstProperty = false;
        }
        return propertiesString.toString();
    }
}

