/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.DiscardChangesActionHandler;
import org.eclipse.egit.ui.internal.dialogs.CommitSelectDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.widgets.Shell;

public class ReplaceWithPreviousActionHandler
extends DiscardChangesActionHandler {
    @Override
    protected String gatherRevision(ExecutionEvent event) throws ExecutionException {
        IResource[] resources = this.getSelectedResources(event);
        try {
            List<RevCommit> pcs = this.findPreviousCommits(Arrays.asList(resources));
            int parentCount = pcs.size();
            if (parentCount == 0) {
                MessageDialog.openError((Shell)this.getShell(event), (String)UIText.ReplaceWithPreviousActionHandler_NoParentCommitDialogTitle, (String)MessageFormat.format(UIText.ReplaceWithPreviousActionHandler_NoParentCommitDialogMessage, resources[0].getName()));
                throw new OperationCanceledException();
            }
            if (parentCount > 1) {
                CommitSelectDialog dlg = new CommitSelectDialog(this.getShell(event), pcs);
                if (dlg.open() == 0) {
                    return dlg.getSelectedCommit().getName();
                }
                throw new OperationCanceledException();
            }
            return pcs.get(0).getName();
        }
        catch (IOException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean isEnabled() {
        IResource[] selectedResources = this.getSelectedResources();
        return super.isEnabled() && selectedResources.length == 1 && this.selectionMapsToSingleRepository();
    }
}

