/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.decorators;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.decorators.DecoratableResource;
import org.eclipse.egit.ui.internal.decorators.DecoratableResourceAdapter;
import org.eclipse.egit.ui.internal.decorators.DecoratableResourceHelper;
import org.eclipse.egit.ui.internal.resources.IResourceState;
import org.eclipse.egit.ui.internal.resources.ResourceStateFactory;
import org.eclipse.jgit.lib.Repository;

public class DecoratableResourceMapping
extends DecoratableResource {
    private static final String MULTIPLE = "*";
    public static final int RESOURCE_MAPPING = 16;
    private ResourceMapping mapping;

    public DecoratableResourceMapping(ResourceMapping mapping) throws IOException {
        super(null);
        this.mapping = mapping;
        HashSet<Repository> repositories = new HashSet<Repository>();
        HashSet<IResourceState.StagingState> stagingStates = new HashSet<IResourceState.StagingState>();
        List<IResource> extractResourcesFromMapping = this.extractResourcesFromMapping();
        boolean anyIsTracked = false;
        boolean anyIsConflict = false;
        boolean anyIsDirty = false;
        for (IResource mappingResource : extractResourcesFromMapping) {
            IndexDiffData indexDiffData;
            if (mappingResource == null || (indexDiffData = ResourceStateFactory.getInstance().getIndexDiffDataOrNull(mappingResource)) == null) continue;
            Repository repository = ResourceUtil.getRepository((IResource)mappingResource);
            repositories.add(repository);
            DecoratableResourceAdapter adapter = new DecoratableResourceAdapter(indexDiffData, mappingResource);
            if (adapter.isTracked()) {
                anyIsTracked = true;
            }
            if (adapter.hasConflicts()) {
                anyIsConflict = true;
            }
            if (adapter.isDirty()) {
                anyIsDirty = true;
            }
            stagingStates.add(adapter.getStagingState());
        }
        if (anyIsTracked) {
            this.setTracked(true);
        }
        if (anyIsConflict) {
            this.setConflicts(true);
        }
        if (anyIsDirty) {
            this.setDirty(true);
        }
        if (stagingStates.isEmpty()) {
            this.setStagingState(IResourceState.StagingState.NOT_STAGED);
        } else if (stagingStates.size() == 1) {
            IResourceState.StagingState state = (IResourceState.StagingState)((Object)stagingStates.iterator().next());
            if (state != null) {
                this.setStagingState(state);
            }
        } else {
            this.setStagingState(IResourceState.StagingState.MODIFIED);
        }
        DecoratableResourceMapping.decorateRepositoryInformation(this, repositories);
    }

    protected static void decorateRepositoryInformation(DecoratableResource resource, Collection<Repository> repositories) throws IOException {
        if (repositories.size() == 1) {
            Repository repository = repositories.iterator().next();
            resource.repositoryName = DecoratableResourceHelper.getRepositoryName(repository);
            resource.branch = DecoratableResourceHelper.getShortBranch(repository);
            resource.branchStatus = DecoratableResourceHelper.getBranchStatus(repository);
        } else if (repositories.size() > 1) {
            HashSet<String> branches = new HashSet<String>(2);
            for (Repository repository : repositories) {
                branches.add(DecoratableResourceHelper.getShortBranch(repository));
                if (branches.size() > 1) break;
            }
            if (branches.size() == 1) {
                resource.repositoryName = MULTIPLE;
                resource.branch = (String)branches.iterator().next();
            }
        }
    }

    private List<IResource> extractResourcesFromMapping() {
        ResourceTraversal[] traversals;
        try {
            traversals = this.mapping.getTraversals(null, null);
        }
        catch (CoreException e) {
            Activator.logError(e.getMessage(), e);
            return Collections.emptyList();
        }
        if (traversals.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<IResource> result = new ArrayList<IResource>();
        ResourceTraversal[] resourceTraversalArray = traversals;
        int n = traversals.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceTraversal traversal = resourceTraversalArray[n2];
            IResource[] resources = traversal.getResources();
            result.addAll(Arrays.asList(resources));
            ++n2;
        }
        return result;
    }

    @Override
    public int getType() {
        return 16;
    }

    @Override
    public String getName() {
        return "<unknown>";
    }
}

