/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetectorExtension;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetectorExtension2;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.texteditor.HyperlinkDetectorDescriptor;

public class HyperlinkSourceViewer
extends SourceViewer {
    private Configuration configuration;
    private Set<String> preferenceKeysForEnablement;
    private Set<String> preferenceKeysForActivation;
    private IPropertyChangeListener hyperlinkChangeListener;

    public HyperlinkSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        super(parent, ruler, styles);
    }

    public HyperlinkSourceViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles) {
        super(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles);
    }

    public void configure(SourceViewerConfiguration config) {
        super.configure(config);
        if (config instanceof Configuration) {
            this.configuration = (Configuration)config;
            this.configurePreferenceKeys();
            this.hyperlinkChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    String property = event.getProperty();
                    if (HyperlinkSourceViewer.this.preferenceKeysForEnablement.contains(property)) {
                        HyperlinkSourceViewer.this.resetHyperlinkDetectors();
                        final Control control = HyperlinkSourceViewer.this.getControl();
                        if (control != null && !control.isDisposed()) {
                            control.getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!control.isDisposed()) {
                                        HyperlinkSourceViewer.this.refresh();
                                    }
                                }
                            });
                        }
                    } else if (HyperlinkSourceViewer.this.preferenceKeysForActivation.contains(property)) {
                        HyperlinkSourceViewer.this.resetHyperlinkDetectors();
                    }
                }
            };
            EditorsUI.getPreferenceStore().addPropertyChangeListener(this.hyperlinkChangeListener);
        } else {
            this.configuration = null;
            this.hyperlinkChangeListener = null;
        }
    }

    private void configurePreferenceKeys() {
        this.preferenceKeysForEnablement = new HashSet<String>();
        this.preferenceKeysForActivation = new HashSet<String>();
        this.preferenceKeysForEnablement.add("hyperlinksEnabled");
        this.preferenceKeysForActivation.add("hyperlinkKeyModifier");
        Map targets = this.configuration.getHyperlinkDetectorTargets((ISourceViewer)this);
        HyperlinkDetectorDescriptor[] hyperlinkDetectorDescriptorArray = EditorsUI.getHyperlinkDetectorRegistry().getHyperlinkDetectorDescriptors();
        int n = hyperlinkDetectorDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            HyperlinkDetectorDescriptor desc = hyperlinkDetectorDescriptorArray[n2];
            if (targets.keySet().contains(desc.getTargetId())) {
                this.preferenceKeysForEnablement.add(desc.getId());
                this.preferenceKeysForActivation.add(String.valueOf(desc.getId()) + "_stateMask");
            }
            ++n2;
        }
    }

    private void resetHyperlinkDetectors() {
        IHyperlinkDetector[] detectors = this.configuration.getHyperlinkDetectors((ISourceViewer)this);
        int stateMask = this.configuration.getHyperlinkStateMask((ISourceViewer)this);
        this.setHyperlinkDetectors(detectors, stateMask);
    }

    public void unconfigure() {
        super.unconfigure();
        if (this.hyperlinkChangeListener != null) {
            EditorsUI.getPreferenceStore().removePropertyChangeListener(this.hyperlinkChangeListener);
        }
        this.preferenceKeysForEnablement = null;
        this.preferenceKeysForActivation = null;
    }

    private static int getConfiguredDefaultMask() {
        int mask = HyperlinkSourceViewer.computeStateMask(EditorsUI.getPreferenceStore().getString("hyperlinkKeyModifier"));
        if (mask == -1) {
            mask = EditorsUI.getPreferenceStore().getInt("hyperlinkKeyModifierMask");
        }
        return mask;
    }

    private static final int findLocalizedModifier(String modifierName) {
        if (modifierName == null) {
            return 0;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)262144))) {
            return 262144;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)131072))) {
            return 131072;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)65536))) {
            return 65536;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)0x400000))) {
            return 0x400000;
        }
        return 0;
    }

    private static final int computeStateMask(String modifiers) {
        if (modifiers == null) {
            return -1;
        }
        if (modifiers.length() == 0) {
            return 0;
        }
        int stateMask = 0;
        StringTokenizer modifierTokenizer = new StringTokenizer(modifiers, ",;.:+-* ");
        while (modifierTokenizer.hasMoreTokens()) {
            int modifier = HyperlinkSourceViewer.findLocalizedModifier(modifierTokenizer.nextToken());
            if (modifier == 0 || (stateMask & modifier) == modifier) {
                return -1;
            }
            stateMask |= modifier;
        }
        return stateMask;
    }

    public static class Configuration
    extends TextSourceViewerConfiguration {
        public Configuration() {
        }

        public Configuration(IPreferenceStore preferenceStore) {
            super(preferenceStore);
        }

        public final IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
            IHyperlinkDetector[] detectors = this.internalGetHyperlinkDetectors(sourceViewer);
            if (detectors != null && detectors.length > 0 && this.getHyperlinkStateMask(sourceViewer) == 0) {
                int defaultMask = HyperlinkSourceViewer.getConfiguredDefaultMask();
                IHyperlinkDetector[] newDetectors = new IHyperlinkDetector[detectors.length * 2];
                int j = 0;
                IHyperlinkDetector[] iHyperlinkDetectorArray = detectors;
                int n = detectors.length;
                int n2 = 0;
                while (n2 < n) {
                    IHyperlinkDetector original = iHyperlinkDetectorArray[n2];
                    if (original instanceof IHyperlinkDetectorExtension2) {
                        int mask = ((IHyperlinkDetectorExtension2)original).getStateMask();
                        if (mask == -1) {
                            newDetectors[j++] = new FixedMaskHyperlinkDetector(original, defaultMask);
                            if (defaultMask != 0) {
                                newDetectors[j++] = new NoMaskHyperlinkDetector(original);
                            }
                        } else {
                            newDetectors[j++] = original;
                            if (mask != 0) {
                                newDetectors[j++] = new NoMaskHyperlinkDetector(original);
                            }
                        }
                    } else {
                        newDetectors[j++] = original;
                    }
                    ++n2;
                }
                IHyperlinkDetector[] result = new IHyperlinkDetector[j];
                System.arraycopy(newDetectors, 0, result, 0, j);
                return result;
            }
            return detectors;
        }

        @Nullable
        protected IHyperlinkDetector[] internalGetHyperlinkDetectors(ISourceViewer sourceViewer) {
            return super.getHyperlinkDetectors(sourceViewer);
        }

        protected Map getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
            return super.getHyperlinkDetectorTargets(sourceViewer);
        }
    }

    private static class FixedMaskHyperlinkDetector
    extends InternalHyperlinkDetector {
        private final int mask;

        protected FixedMaskHyperlinkDetector(IHyperlinkDetector delegate, int mask) {
            super(delegate);
            this.mask = mask;
        }

        public int getStateMask() {
            return this.mask;
        }
    }

    private static abstract class InternalHyperlinkDetector
    implements IHyperlinkDetector,
    IHyperlinkDetectorExtension,
    IHyperlinkDetectorExtension2 {
        protected IHyperlinkDetector delegate;

        protected InternalHyperlinkDetector(IHyperlinkDetector delegate) {
            this.delegate = delegate;
        }

        public final IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
            return this.delegate.detectHyperlinks(textViewer, region, canShowMultipleHyperlinks);
        }

        public final void dispose() {
            if (this.delegate instanceof IHyperlinkDetectorExtension) {
                ((IHyperlinkDetectorExtension)this.delegate).dispose();
            }
        }
    }

    protected static class NoMaskHyperlinkDetector
    extends FixedMaskHyperlinkDetector {
        private NoMaskHyperlinkDetector(IHyperlinkDetector delegate) {
            super(delegate, 0);
        }
    }
}

