/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.op.SubmoduleUpdateOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIRepositoryUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.egit.ui.internal.repository.tree.command.SubmoduleCommand;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.swt.widgets.Shell;

public class SubmoduleUpdateCommand
extends SubmoduleCommand<RepositoryTreeNode<?>> {
    /*
     * Enabled aggressive exception aggregation
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        final Map<Repository, List<String>> repoPaths = this.getSubmodules(this.getSelectedNodes(event));
        if (!repoPaths.isEmpty()) {
            try {
                boolean submodulesNodeSelected = false;
                ArrayList<Object> subRepos = new ArrayList<Object>();
                for (RepositoryTreeNode repositoryTreeNode : this.getSelectedNodes(event)) {
                    if (repositoryTreeNode.getType() != RepositoryTreeNodeType.SUBMODULES) continue;
                    submodulesNodeSelected = true;
                    SubmoduleWalk walk = SubmoduleWalk.forIndex((Repository)repositoryTreeNode.getRepository());
                    while (walk.next()) {
                        Repository subRepo = walk.getRepository();
                        subRepos.add(subRepo);
                    }
                    break block2;
                }
                if (!submodulesNodeSelected) {
                    for (Map.Entry entry : repoPaths.entrySet()) {
                        if (entry.getValue() == null) continue;
                        for (String path : (List)entry.getValue()) {
                            Repository subRepo = SubmoduleWalk.getSubmoduleRepository((Repository)((Repository)entry.getKey()), (String)path);
                            subRepos.add(subRepo);
                        }
                    }
                }
                Shell shell = this.getActiveShell(event);
                for (Repository subRepo : subRepos) {
                    String repoName = Activator.getDefault().getRepositoryUtil().getRepositoryName(subRepo);
                    if (UIRepositoryUtils.handleUncommittedFiles(subRepo, shell, MessageFormat.format(UIText.SubmoduleUpdateCommand_UncommittedChanges, repoName))) continue;
                    return null;
                }
            }
            catch (Exception e) {
                Activator.handleError(UIText.SubmoduleUpdateCommand_UpdateError, e, true);
                return null;
            }
            WorkspaceJob job = new WorkspaceJob(UIText.SubmoduleUpdateCommand_Title){

                public IStatus runInWorkspace(IProgressMonitor monitor) {
                    monitor.beginTask("", repoPaths.size());
                    try {
                        for (Map.Entry entry : repoPaths.entrySet()) {
                            SubmoduleUpdateOperation op = new SubmoduleUpdateOperation((Repository)entry.getKey());
                            if (entry.getValue() != null) {
                                for (String path : (List)entry.getValue()) {
                                    op.addPath(path);
                                }
                            }
                            op.execute((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                    }
                    catch (CoreException e) {
                        Activator.logError(UIText.SubmoduleUpdateCommand_UpdateError, e);
                    }
                    return Status.OK_STATUS;
                }

                public boolean belongsTo(Object family) {
                    if (JobFamilies.SUBMODULE_UPDATE.equals(family)) {
                        return true;
                    }
                    return super.belongsTo(family);
                }
            };
            job.setUser(true);
            job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            job.schedule();
        }
        return null;
    }
}

