/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.migration.rsa.transformation;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.StringValueStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.infra.core.resource.IEMFModel;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.ModelMultiException;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.emf.resource.DependencyManagementHelper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.tools.util.StringHelper;
import org.eclipse.papyrus.migration.rsa.Activator;
import org.eclipse.papyrus.migration.rsa.RSAToPapyrusParameters.Config;
import org.eclipse.papyrus.migration.rsa.RSAToPapyrusParameters.MappingParameters;
import org.eclipse.papyrus.migration.rsa.RSAToPapyrusParameters.URIMapping;
import org.eclipse.papyrus.migration.rsa.concurrent.ResourceAccessHelper;
import org.eclipse.papyrus.migration.rsa.internal.schedule.JobWrapper;
import org.eclipse.papyrus.migration.rsa.internal.schedule.Scheduler;
import org.eclipse.papyrus.migration.rsa.internal.schedule.TransformationWrapper;
import org.eclipse.papyrus.migration.rsa.transformation.DependencyAnalysisHelper;
import org.eclipse.papyrus.migration.rsa.transformation.ImportTransformation;
import org.eclipse.papyrus.migration.rsa.transformation.MigrationModelSet;
import org.eclipse.papyrus.migration.rsa.transformation.RepairStereotypes;
import org.eclipse.papyrus.migration.rsa.transformation.ui.URIMappingDialog;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.Stereotype;

public class ImportTransformationLauncher {
    protected static final long SECOND = 1000000000L;
    protected static final long MILLIS = 1000000L;
    protected final Config config;
    protected final Control baseControl;
    protected long ownExecutionTime;
    protected long ownLoadingTime;
    protected long ownRepairStereotypesTime;
    protected long ownRepairLibrariesTime;
    protected long resolveAllDependencies;
    protected Job importDependenciesJob;
    protected long transformationsExecutionTime = 0L;
    protected DependencyAnalysisHelper analysisHelper;
    protected static final String CONSOLE_NAME = "Model Import Results";
    protected final Map<ImportTransformation, Long> loadingTimeV2 = new HashMap<ImportTransformation, Long>();
    protected final Map<ImportTransformation, Long> proxiesTime = new HashMap<ImportTransformation, Long>();
    protected final Map<ImportTransformation, Long> stereoTime = new HashMap<ImportTransformation, Long>();
    protected final Map<ImportTransformation, Long> totalTimeV2 = new HashMap<ImportTransformation, Long>();

    public ImportTransformationLauncher(Config config) {
        this(config, null);
    }

    public ImportTransformationLauncher(Config config, Control baseControl) {
        this.config = config;
        this.baseControl = baseControl;
    }

    public void run(List<URI> urisToImport) {
        LinkedList<ImportTransformation> transformations = new LinkedList<ImportTransformation>();
        this.analysisHelper = new DependencyAnalysisHelper(this.config);
        for (URI uri : urisToImport) {
            ImportTransformation transformation = this.createTransformation(uri);
            transformations.add(transformation);
        }
        this.importModels(transformations);
    }

    protected ImportTransformation createTransformation(URI transformationURI) {
        return new ImportTransformation(transformationURI, this.config, this.analysisHelper);
    }

    protected void importModels(final List<ImportTransformation> transformations) {
        this.importDependenciesJob = new Job("Import Models"){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus result = ImportTransformationLauncher.this.importModels(monitor, transformations);
                if (monitor.isCanceled()) {
                    return new Status(8, "org.eclipse.papyrus.migration.rsa", "Operation Canceled");
                }
                long cumulatedLoadingTime = 0L;
                long cumulatedTransformationTime = 0L;
                long cumulatedHandleDanglingTime = 0L;
                long cumulatedImportExtensionsTime = 0L;
                for (ImportTransformation transformation : transformations) {
                    cumulatedLoadingTime += transformation.getLoadingTime();
                    cumulatedImportExtensionsTime += transformation.getImportExtensionsTime();
                    cumulatedHandleDanglingTime += transformation.getHandleDanglingRefTime();
                    cumulatedTransformationTime += transformation.getExecutionTime();
                    ImportTransformationLauncher.this.log("Import " + transformation.getModelName());
                    ImportTransformationLauncher.this.log("First phase (0-50%):");
                    ImportTransformationLauncher.this.log("\tTotal loading time: " + ImportTransformationLauncher.this.timeFormat(transformation.getLoadingTime()));
                    ImportTransformationLauncher.this.log("\tTotal Import Extensions time: " + ImportTransformationLauncher.this.timeFormat(transformation.getImportExtensionsTime()));
                    ImportTransformationLauncher.this.log("\tTotal Handle Dangling References time: " + ImportTransformationLauncher.this.timeFormat(transformation.getHandleDanglingRefTime()));
                    ImportTransformationLauncher.this.log("\tTotal execution time: " + ImportTransformationLauncher.this.timeFormat(transformation.getExecutionTime()));
                    Long loadingTime = ImportTransformationLauncher.this.loadingTimeV2.get(transformation);
                    Long repairProxiesTime = ImportTransformationLauncher.this.proxiesTime.get(transformation);
                    Long repairStereoTime = ImportTransformationLauncher.this.stereoTime.get(transformation);
                    Long totalPhase2 = ImportTransformationLauncher.this.totalTimeV2.get(transformation);
                    ImportTransformationLauncher.this.log("Second phase (50-100%):");
                    ImportTransformationLauncher.this.log("\tTotal loading time: " + ImportTransformationLauncher.this.timeFormat(loadingTime));
                    ImportTransformationLauncher.this.log("\tTotal fix proxies time: " + ImportTransformationLauncher.this.timeFormat(repairProxiesTime));
                    ImportTransformationLauncher.this.log("\tTotal fix stereotypes time: " + ImportTransformationLauncher.this.timeFormat(repairStereoTime));
                    ImportTransformationLauncher.this.log("\tTotal execution time: " + ImportTransformationLauncher.this.timeFormat(totalPhase2));
                    ImportTransformationLauncher.this.log("Total");
                    ImportTransformationLauncher.this.log("\tTotal execution time: " + ImportTransformationLauncher.this.timeFormat(transformation.getExecutionTime() + totalPhase2));
                    ImportTransformationLauncher.this.log("\n");
                }
                int nbThreads = Math.max(1, ImportTransformationLauncher.this.config.getMaxThreads());
                ImportTransformationLauncher.this.log("First phase (0-50%) / " + nbThreads + " Threads");
                ImportTransformationLauncher.this.log("\tCumulated Transformation Time: " + ImportTransformationLauncher.this.timeFormat(cumulatedTransformationTime));
                ImportTransformationLauncher.this.log("\tCumulated Loading Time: " + ImportTransformationLauncher.this.timeFormat(cumulatedLoadingTime));
                ImportTransformationLauncher.this.log("\tCumulated Handle Dangling Refs Time: " + ImportTransformationLauncher.this.timeFormat(cumulatedHandleDanglingTime));
                ImportTransformationLauncher.this.log("\tCumulated Import Extensions Time: " + ImportTransformationLauncher.this.timeFormat(cumulatedImportExtensionsTime));
                ImportTransformationLauncher.this.log("\tTotal Transformation Time: " + ImportTransformationLauncher.this.timeFormat(ImportTransformationLauncher.this.transformationsExecutionTime));
                ImportTransformationLauncher.this.log("Second phase (50-100%) / " + nbThreads + " Threads");
                ImportTransformationLauncher.this.log("\tTotal Handle all Dangling References: " + ImportTransformationLauncher.this.timeFormat(ImportTransformationLauncher.this.resolveAllDependencies));
                ImportTransformationLauncher.this.log("\tCumulated Loading Time: " + ImportTransformationLauncher.this.timeFormat(ImportTransformationLauncher.this.ownLoadingTime));
                ImportTransformationLauncher.this.log("\tCumulated Fix Libraries Time: " + ImportTransformationLauncher.this.timeFormat(ImportTransformationLauncher.this.ownRepairLibrariesTime));
                ImportTransformationLauncher.this.log("\tCumulated Fix Stereotypes Time: " + ImportTransformationLauncher.this.timeFormat(ImportTransformationLauncher.this.ownRepairStereotypesTime));
                ImportTransformationLauncher.this.log("\tTotal Fix Dependencies Time: " + ImportTransformationLauncher.this.timeFormat(ImportTransformationLauncher.this.ownExecutionTime));
                ImportTransformationLauncher.this.log("Total");
                ImportTransformationLauncher.this.log("\tCumulated Total time: " + ImportTransformationLauncher.this.timeFormat(ImportTransformationLauncher.this.ownExecutionTime + cumulatedTransformationTime));
                ImportTransformationLauncher.this.log("\tTotal time: " + ImportTransformationLauncher.this.timeFormat(ImportTransformationLauncher.this.ownExecutionTime + ImportTransformationLauncher.this.transformationsExecutionTime));
                ImportTransformationLauncher.this.log("Import Complete");
                ImportTransformationLauncher.this.log("");
                return result;
            }
        };
        this.importDependenciesJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                String message;
                MultiStatus multiStatus = new MultiStatus("org.eclipse.papyrus.migration.rsa", 0, "", null);
                multiStatus.merge(event.getResult());
                for (ImportTransformation transformation : transformations) {
                    multiStatus.merge(transformation.getStatus());
                }
                int severity = multiStatus.getSeverity();
                switch (severity) {
                    case 0: {
                        message = "The selected models have been successfully imported";
                        break;
                    }
                    case 8: {
                        message = "Operation canceled";
                        break;
                    }
                    case 2: {
                        message = "The selected models have been imported; some warnings have been reported";
                        break;
                    }
                    default: {
                        message = "Some errors occurred during model import";
                    }
                }
                this.handle((IStatus)new MultiStatus("org.eclipse.papyrus.migration.rsa", severity, multiStatus.getChildren(), message, null));
            }

            protected void handle(final IStatus status) {
                if (ImportTransformationLauncher.this.baseControl == null) {
                    int severity = status.getSeverity();
                    if (severity == 0 || severity == 8) {
                        return;
                    }
                    StatusManager.getManager().handle(status, 1);
                    return;
                }
                Display display = ImportTransformationLauncher.this.baseControl.getDisplay();
                if (status.getSeverity() == 0) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openInformation((Shell)(this).ImportTransformationLauncher.this.baseControl.getShell(), (String)"Import models", (String)status.getMessage());
                        }
                    });
                } else if (status.getSeverity() == 8) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openInformation((Shell)(this).ImportTransformationLauncher.this.baseControl.getShell(), (String)"Import models", (String)status.getMessage());
                        }
                    });
                } else {
                    StatusManager.getManager().handle(status, 4);
                }
            }
        });
        this.importDependenciesJob.setUser(true);
        this.importDependenciesJob.schedule();
    }

    protected void log(String message) {
        System.out.println(message);
        MessageConsole console = this.getConsole();
        MessageConsoleStream out = console.newMessageStream();
        out.println(message);
    }

    protected MessageConsole getConsole() {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager consoleManager = plugin.getConsoleManager();
        IConsole[] existing = consoleManager.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (CONSOLE_NAME.equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        MessageConsole rsaConsole = new MessageConsole(CONSOLE_NAME, null);
        consoleManager.addConsoles(new IConsole[]{rsaConsole});
        return rsaConsole;
    }

    protected String timeFormat(Long nano) {
        if (nano == null) {
            return "?";
        }
        long seconds = nano / 1000000000L;
        if (seconds < 1L) {
            long millis = nano / 1000000L;
            return String.format("%s ms", millis);
        }
        return String.format("%d:%02d:%02d", seconds / 3600L, seconds % 3600L / 60L, seconds % 60L);
    }

    protected IStatus importModels(IProgressMonitor monitor, List<ImportTransformation> transformations) {
        long begin = System.nanoTime();
        monitor.setTaskName("Waiting for import tasks to complete...");
        int numTasks = transformations.size() * 2;
        monitor.beginTask("Importing Models...", numTasks);
        LinkedList<TransformationWrapper> tasks = new LinkedList<TransformationWrapper>();
        for (ImportTransformation transformation : transformations) {
            tasks.add(new TransformationWrapper(transformation));
        }
        Scheduler scheduler = new Scheduler(this.config.getMaxThreads());
        scheduler.schedule(monitor, tasks);
        long end = System.nanoTime();
        this.transformationsExecutionTime = end - begin;
        if (monitor.isCanceled()) {
            return new Status(8, "org.eclipse.papyrus.migration.rsa", "Operation canceled");
        }
        this.handleModelDependencies(transformations, monitor);
        return Status.OK_STATUS;
    }

    protected void handleModelDependencies(List<ImportTransformation> transformations, IProgressMonitor monitor) {
        long begin = System.nanoTime();
        long timeToIgnore = 0L;
        final HashMap<URI, URI> urisToReplace = new HashMap<URI, URI>();
        final HashMap<URI, URI> profileUrisToReplace = new HashMap<URI, URI>();
        for (ImportTransformation transformation : transformations) {
            urisToReplace.putAll(transformation.getURIMappings());
            profileUrisToReplace.putAll(transformation.getProfileURIMappings());
        }
        monitor.subTask("Analysing unresolved references...");
        long startResolveAll = System.nanoTime();
        this.analysisHelper.resolveAllMappings(urisToReplace, profileUrisToReplace);
        long endResolveAll = System.nanoTime();
        this.resolveAllDependencies = endResolveAll - startResolveAll;
        if (!this.config.getMappingParameters().getUriMappings().isEmpty() || !this.config.getMappingParameters().getProfileUriMappings().isEmpty()) {
            long beginDialog = System.nanoTime();
            MappingParameters parameters = this.confirmURIMappings(this.config.getMappingParameters());
            long endDialog = System.nanoTime();
            timeToIgnore = endDialog - beginDialog;
            this.config.setMappingParameters(parameters);
            ImportTransformationLauncher.populateURIMap(parameters.getUriMappings(), urisToReplace);
            ImportTransformationLauncher.populateURIMap(parameters.getUriMappings(), profileUrisToReplace);
            ImportTransformationLauncher.populateURIMap(parameters.getProfileUriMappings(), profileUrisToReplace);
        }
        this.removeEmptyMappings(urisToReplace);
        LinkedList<JobWrapper> tasks = new LinkedList<JobWrapper>();
        for (final ImportTransformation transformation : transformations) {
            Job transformationJob = new Job("Importing dependencies for " + transformation.getModelName()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected IStatus run(IProgressMonitor monitor) {
                    long startFix = System.nanoTime();
                    IStatus fixStatus = ImportTransformationLauncher.this.fixDependencies(transformation, monitor, urisToReplace, profileUrisToReplace);
                    long endFix = System.nanoTime();
                    ImportTransformationLauncher importTransformationLauncher = ImportTransformationLauncher.this;
                    synchronized (importTransformationLauncher) {
                        ImportTransformationLauncher.this.totalTimeV2.put(transformation, endFix - startFix);
                    }
                    return fixStatus;
                }
            };
            tasks.add(new JobWrapper(transformationJob));
        }
        Scheduler scheduler = new Scheduler(this.config.getMaxThreads());
        scheduler.schedule(monitor, tasks);
        long end = System.nanoTime();
        this.ownExecutionTime = end - begin - timeToIgnore;
    }

    protected void removeEmptyMappings(Map<URI, URI> urisToReplace) {
        Iterator<Map.Entry<URI, URI>> iterator = urisToReplace.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<URI, URI> entry = iterator.next();
            if (!entry.getKey().equals(entry.getValue())) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus fixDependencies(ImportTransformation transformation, IProgressMonitor monitor, Map<URI, URI> urisToReplace, Map<URI, URI> profileUrisToReplace) {
        IStatus repairDisplayStatus;
        ImportTransformationLauncher importTransformationLauncher;
        Collection<Resource> resourcesToRepair;
        monitor.subTask("Importing dependencies for " + transformation.getModelName());
        MigrationModelSet modelSet = new MigrationModelSet();
        try {
            URI targetURI = transformation.getTargetURI();
            if (targetURI == null) {
                monitor.worked(1);
                return Status.OK_STATUS;
            }
            long startLoading = System.nanoTime();
            modelSet.loadModels(transformation.getTargetURI());
            resourcesToRepair = this.resolveOwnResources((ModelSet)modelSet);
            long endLoading = System.nanoTime();
            importTransformationLauncher = this;
            synchronized (importTransformationLauncher) {
                this.ownLoadingTime += endLoading - startLoading;
                this.loadingTimeV2.put(transformation, endLoading - startLoading);
            }
        }
        catch (ModelMultiException e) {
            Activator.log.error((Throwable)e);
            monitor.worked(1);
            return new Status(4, "org.eclipse.papyrus.migration.rsa", "An exception occurred when repairing library dependencies", (Throwable)e);
        }
        try {
            long startProxies = System.nanoTime();
            modelSet.freeze();
            try {
                this.repairProxies((ModelSet)modelSet, resourcesToRepair, urisToReplace, monitor);
            }
            finally {
                modelSet.unfreeze();
            }
            long endProxies = System.nanoTime();
            ImportTransformationLauncher importTransformationLauncher2 = this;
            synchronized (importTransformationLauncher2) {
                this.ownRepairLibrariesTime += endProxies - startProxies;
                this.proxiesTime.put(transformation, endProxies - startProxies);
            }
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
            return new Status(4, "org.eclipse.papyrus.migration.rsa", "An exception occurred when repairing library dependencies", (Throwable)ex);
        }
        RepairStereotypes repairStereotypesAction = new RepairStereotypes((ModelSet)modelSet, resourcesToRepair, profileUrisToReplace);
        try {
            long startStereotypes = System.nanoTime();
            repairStereotypesAction.execute();
            long endStereotypes = System.nanoTime();
            importTransformationLauncher = this;
            synchronized (importTransformationLauncher) {
                this.ownRepairStereotypesTime += endStereotypes - startStereotypes;
                this.stereoTime.put(transformation, endStereotypes - startStereotypes);
            }
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
            return new Status(4, "org.eclipse.papyrus.migration.rsa", "An exception occurred when repairing profiles/stereotypes", (Throwable)ex);
        }
        if (this.config.isRemoveUnmappedProfilesAndStereotypes()) {
            try {
                for (final Resource resource : resourcesToRepair) {
                    final LinkedList<EObject> eObjectsToDelete = new LinkedList<EObject>();
                    TreeIterator allContents = resource.getAllContents();
                    while (allContents.hasNext()) {
                        URI profileURI;
                        ProfileApplication profileApplication;
                        Profile appliedProfile;
                        EObject next = (EObject)allContents.next();
                        if (next.eResource() != resource) {
                            allContents.prune();
                            continue;
                        }
                        URI eClassURI = EcoreUtil.getURI((EObject)next.eClass());
                        if (StringHelper.equals((String)"epx", (String)eClassURI.fileExtension())) {
                            eObjectsToDelete.add(next);
                            allContents.prune();
                            continue;
                        }
                        if (!(next instanceof ProfileApplication) || (appliedProfile = (profileApplication = (ProfileApplication)next).getAppliedProfile()) == null || !StringHelper.equals((String)"epx", (String)(profileURI = EcoreUtil.getURI((EObject)appliedProfile)).fileExtension())) continue;
                        eObjectsToDelete.add(next);
                        allContents.prune();
                    }
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            for (EObject eObject : eObjectsToDelete) {
                                EObject parentElement = eObject.eContainer();
                                if (parentElement == null) {
                                    resource.getContents().remove((Object)eObject);
                                    continue;
                                }
                                EStructuralFeature containingFeature = eObject.eContainingFeature();
                                EcoreUtil.remove((EObject)parentElement, (EStructuralFeature)containingFeature, (Object)eObject);
                            }
                        }
                    };
                    ImportTransformationLauncher.runFastTransaction(modelSet.getTransactionalEditingDomain(), runnable);
                }
            }
            catch (Exception ex) {
                Activator.log.error((Throwable)ex);
                return new Status(4, "org.eclipse.papyrus.migration.rsa", "An exception occurred when repairing profiles/stereotypes", (Throwable)ex);
            }
        }
        if (!(repairDisplayStatus = this.repairStereotypeDisplay((ModelSet)modelSet, resourcesToRepair)).isOK()) {
            return repairDisplayStatus;
        }
        try {
            for (Resource resource : resourcesToRepair) {
                ResourceAccessHelper.INSTANCE.saveResource(resource, null);
            }
            monitor.worked(1);
            TransactionalEditingDomain domain = modelSet.getTransactionalEditingDomain();
            InternalTransactionalEditingDomain internalDomain = (InternalTransactionalEditingDomain)domain;
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("no_undo", true);
            options.put("no_validation", true);
            options.put("no_triggers", true);
            options.put("unprotected", true);
            InternalTransaction fastTransaction = internalDomain.startTransaction(false, options);
            try {
                EMFHelper.unload((ResourceSet)modelSet);
            }
            finally {
                fastTransaction.commit();
            }
            domain.dispose();
        }
        catch (IOException ex) {
            Activator.log.error((Throwable)ex);
        }
        catch (RollbackException ex) {
            Activator.log.error((Throwable)ex);
        }
        catch (InterruptedException ex) {
            Activator.log.error((Throwable)ex);
        }
        return Status.OK_STATUS;
    }

    protected IStatus repairStereotypeDisplay(ModelSet modelSet, Collection<Resource> resourcesToRepair) {
        HashMap nodesToCreate = new HashMap();
        TransactionalEditingDomain domain = modelSet.getTransactionalEditingDomain();
        InternalTransactionalEditingDomain internalDomain = (InternalTransactionalEditingDomain)domain;
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("no_undo", true);
        options.put("no_validation", true);
        options.put("no_triggers", true);
        options.put("unprotected", true);
        LinkedList<StringValueStyle> stylesToDelete = new LinkedList<StringValueStyle>();
        try {
            InternalTransaction fastTransaction = internalDomain.startTransaction(false, options);
            for (Resource resource : resourcesToRepair) {
                if (!"notation".equals(resource.getURI().fileExtension())) continue;
                TreeIterator contents = resource.getAllContents();
                block9: while (contents.hasNext()) {
                    String value;
                    StringValueStyle style;
                    EObject next = (EObject)contents.next();
                    if (next instanceof StringValueStyle && "stereotypeDisplayBackup".equals((style = (StringValueStyle)next).getName())) {
                        stylesToDelete.add(style);
                        continue;
                    }
                    if (!(next instanceof View)) {
                        contents.prune();
                        continue;
                    }
                    View content = (View)next;
                    StringValueStyle stereotypeDisplay = (StringValueStyle)content.getNamedStyle(NotationPackage.eINSTANCE.getStringValueStyle(), "stereotypeDisplayBackup");
                    if (stereotypeDisplay == null || (value = stereotypeDisplay.getStringValue()) == null) continue;
                    switch (value) {
                        case "None": {
                            EObject semanticElement = content.getElement();
                            if (!(semanticElement instanceof Element)) continue block9;
                            Element umlElement = (Element)semanticElement;
                            EList stereotypes = umlElement.getAppliedStereotypes();
                            LinkedList<DecorationNode> childNodesToCreate = new LinkedList<DecorationNode>();
                            nodesToCreate.put(content, childNodesToCreate);
                            for (Stereotype appliedStereotype : stereotypes) {
                                DecorationNode stereotypeLabel = NotationFactory.eINSTANCE.createDecorationNode();
                                stereotypeLabel.setType("StereotypeLabel");
                                stereotypeLabel.setVisible(false);
                                StringValueStyle stereotypeStyle = (StringValueStyle)stereotypeLabel.createStyle(NotationPackage.eINSTANCE.getStringValueStyle());
                                stereotypeStyle.setName("stereotype");
                                stereotypeStyle.setStringValue(appliedStereotype.getQualifiedName());
                                stereotypeLabel.setElement((EObject)appliedStereotype);
                                stereotypeLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
                                childNodesToCreate.add(stereotypeLabel);
                            }
                            continue block9;
                        }
                    }
                }
            }
            for (Map.Entry entry : nodesToCreate.entrySet()) {
                View parent = (View)entry.getKey();
                for (DecorationNode decorationNode : (List)entry.getValue()) {
                    parent.getPersistedChildren().add((Object)decorationNode);
                }
            }
            for (StringValueStyle stringValueStyle : stylesToDelete) {
                EObject container = stringValueStyle.eContainer();
                EReference feature = stringValueStyle.eContainmentFeature();
                if (container == null || feature == null) continue;
                if (feature.isMany()) {
                    List values = (List)container.eGet((EStructuralFeature)feature);
                    values.remove(stringValueStyle);
                    continue;
                }
                container.eUnset((EStructuralFeature)feature);
            }
            fastTransaction.commit();
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
            return new Status(4, "org.eclipse.papyrus.migration.rsa", "An error occurred while trying to migrate Stereotype Display", (Throwable)ex);
        }
        return Status.OK_STATUS;
    }

    protected Collection<Resource> resolveOwnResources(ModelSet modelSet) {
        UmlModel umlModel = (UmlModel)modelSet.getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
        if (umlModel == null) {
            return Collections.emptySet();
        }
        Resource mainResource = umlModel.getResource();
        if (mainResource == null) {
            return Collections.emptySet();
        }
        TreeIterator contents = mainResource.getAllContents();
        while (contents.hasNext()) {
            contents.next();
        }
        HashSet<Resource> resourcesToRepair = new HashSet<Resource>();
        for (Resource resource : modelSet.getResources()) {
            if (!this.isMainModelResource(modelSet, resource)) continue;
            resourcesToRepair.add(resource);
        }
        return resourcesToRepair;
    }

    protected boolean isMainModelResource(ModelSet modelSet, Resource resource) {
        IEMFModel logicalModel;
        IModel model = modelSet.getModelFor((Object)resource);
        return model instanceof IEMFModel && ((logicalModel = (IEMFModel)model).getResource() == resource || logicalModel.isControlled(resource));
    }

    protected void repairProxies(ModelSet modelSet, final Collection<Resource> resourcesToRepair, final Map<URI, URI> urisToReplace, IProgressMonitor monitor) throws InterruptedException, RollbackException {
        final TransactionalEditingDomain domain = modelSet.getTransactionalEditingDomain();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DependencyManagementHelper.batchUpdateDependencies((Map)urisToReplace, (Collection)resourcesToRepair, (EditingDomain)domain);
            }
        };
        ImportTransformationLauncher.runFastTransaction(domain, runnable);
    }

    protected static final void runFastTransaction(TransactionalEditingDomain domain, Runnable runnable) throws InterruptedException, RollbackException {
        InternalTransactionalEditingDomain internalDomain = (InternalTransactionalEditingDomain)domain;
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("no_undo", true);
        options.put("no_validation", true);
        options.put("no_triggers", true);
        options.put("unprotected", true);
        InternalTransaction fastTransaction = internalDomain.startTransaction(false, options);
        try {
            runnable.run();
        }
        finally {
            fastTransaction.commit();
        }
    }

    protected static void populateURIMap(List<URIMapping> mappings, Map<URI, URI> uriMap) {
        for (URIMapping mapping : mappings) {
            if (mapping == null) continue;
            String source = mapping.getSourceURI();
            String target = mapping.getTargetURI();
            if (source == null || target == null || source.trim().isEmpty() || target.trim().isEmpty()) continue;
            URI sourceURI = URI.createURI((String)mapping.getSourceURI());
            URI targetURI = URI.createURI((String)mapping.getTargetURI());
            if (uriMap.containsKey(sourceURI)) continue;
            uriMap.put(sourceURI, targetURI);
        }
    }

    protected MappingParameters confirmURIMappings(final MappingParameters mappingParameters) {
        List<URIMapping> flatMappings = this.analysisHelper.flattenURIMappings(mappingParameters);
        this.analysisHelper.propagateURIMappings(flatMappings, mappingParameters);
        if (this.config.isAlwaysAcceptSuggestedMappings()) {
            return mappingParameters;
        }
        final AtomicReference<MappingParameters> newParameters = new AtomicReference<MappingParameters>(mappingParameters);
        if (this.baseControl != null && !this.baseControl.isDisposed()) {
            this.baseControl.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    newParameters.set(ImportTransformationLauncher.this.openMappingsDialog(mappingParameters));
                }
            });
        }
        return newParameters.get();
    }

    protected MappingParameters openMappingsDialog(MappingParameters mappingParameters) {
        Shell shell = this.baseControl.getShell();
        URIMappingDialog dialog = new URIMappingDialog(shell, mappingParameters, this.analysisHelper);
        dialog.open();
        return (MappingParameters)dialog.getResult()[0];
    }

    public void waitForCompletion() throws Exception {
        this.importDependenciesJob.join();
    }

    public IStatus getResult() {
        return this.importDependenciesJob.getResult();
    }
}

