/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.migration.rsa.transformation;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.resource.impl.URIMappingRegistryImpl;
import org.eclipse.papyrus.migration.rsa.RSAToPapyrusParameters.URIMapping;
import org.eclipse.papyrus.migration.rsa.transformation.DependencyAnalysisHelper;

class ProfileMappingAwareURIConverter
extends ExtensibleURIConverterImpl {
    private final ResourceSet owner;
    private final DependencyAnalysisHelper dependencyHelper;
    private final Map<URI, Optional<URIMapping>> profileMappings = Maps.newConcurrentMap();

    public ProfileMappingAwareURIConverter(ResourceSet owner, DependencyAnalysisHelper dependencyHelper) {
        this.owner = owner;
        this.dependencyHelper = dependencyHelper;
    }

    protected ExtensibleURIConverterImpl.URIMap getInternalURIMap() {
        if (this.uriMap == null) {
            final ExtensibleURIConverterImpl.URIMap delegate = super.getInternalURIMap();
            this.uriMap = (ExtensibleURIConverterImpl.URIMap)new URIMappingRegistryImpl(){
                private static final long serialVersionUID = 1L;

                protected URI delegatedGetURI(URI uri) {
                    URI result;
                    if (!"epx".equalsIgnoreCase(uri.fileExtension())) {
                        result = delegate.getURI(uri);
                    } else {
                        Optional mapping = ProfileMappingAwareURIConverter.this.getProfileMapping(uri);
                        result = mapping.map(m -> URI.createURI((String)m.getTargetURI())).orElseGet(() -> delegate.getURI(uri));
                    }
                    return result;
                }
            }.map();
        }
        return this.uriMap;
    }

    private Optional<URIMapping> getProfileMapping(URI uri) {
        return this.profileMappings.computeIfAbsent(uri, this::findProfileMapping);
    }

    private Optional<URIMapping> findProfileMapping(URI uri) {
        URIMapping result = URIConverter.INSTANCE.exists(uri, null) ? null : this.dependencyHelper.findExistingProfileMapping(uri, this.owner);
        return Optional.ofNullable(result);
    }
}

