/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.trans.from.uml;

import com.google.common.base.Objects;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.papyrusrt.codegen.CodeGenPlugin;
import org.eclipse.papyrusrt.xtumlrt.common.CommonElement;
import org.eclipse.papyrusrt.xtumlrt.external.predefined.RTSModelLibraryUtils;
import org.eclipse.papyrusrt.xtumlrt.external.predefined.UMLRTProfileUtil;
import org.eclipse.papyrusrt.xtumlrt.trans.from.uml.GenerationProperties;
import org.eclipse.papyrusrt.xtumlrt.util.DetailedException;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.RedefinableElement;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;

public abstract class UML2xtumlrtTranslator {
    private static final String XTUMLRT_EXTENSION = "xtumlrt";
    private BiMap<Element, CommonElement> generated;
    private List<EObject> orderedGeneratedList;
    private Map<CommonElement, CommonElement> extra;
    private Set<Element> changed;
    private List<EObject> inputElements;
    private Path outputPath;

    public UML2xtumlrtTranslator() {
        this.resetAll();
        UML2xtumlrtTranslator.init();
    }

    private static Object init() {
        XMIResourceFactoryImpl _xblockexpression = null;
        Resource.Factory.Registry registry = Resource.Factory.Registry.INSTANCE;
        Map _extensionToFactoryMap = registry.getExtensionToFactoryMap();
        XMIResourceFactoryImpl _xMIResourceFactoryImpl = new XMIResourceFactoryImpl();
        _xblockexpression = _extensionToFactoryMap.put(XTUMLRT_EXTENSION, _xMIResourceFactoryImpl);
        return _xblockexpression;
    }

    public Set<Element> resetAll() {
        HashSet _newHashSet;
        HashMap _newHashMap;
        HashBiMap _create;
        HashSet _xblockexpression = null;
        if (this.generated != null) {
            Set _keySet = this.generated.keySet();
            for (Element umlElement : _keySet) {
                this.resetTranslateCache((EObject)umlElement);
            }
        }
        this.generated = _create = HashBiMap.create();
        ArrayList<EObject> _arrayList = new ArrayList<EObject>();
        this.orderedGeneratedList = _arrayList;
        this.extra = _newHashMap = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
        _xblockexpression = this.changed = (_newHashSet = CollectionLiterals.newHashSet((Object[])new Element[0]));
        return _xblockexpression;
    }

    public List<EObject> getAllGenerated() {
        return this.orderedGeneratedList;
    }

    public CommonElement getGenerated(Element umlElement) {
        return (CommonElement)this.generated.get((Object)umlElement);
    }

    public Element getSource(CommonElement element) {
        BiMap _inverse = this.generated.inverse();
        return (Element)_inverse.get((Object)element);
    }

    public void replace(CommonElement existingElement, CommonElement replacement) {
        BiMap _inverse = this.generated.inverse();
        Element sourceUMLElement = (Element)_inverse.get((Object)existingElement);
        if (sourceUMLElement != null) {
            this.generated.put((Object)sourceUMLElement, (Object)replacement);
            GenerationProperties.setGenProperties(sourceUMLElement, replacement);
        }
    }

    public CommonElement addNewGenerated(CommonElement element, CommonElement newGenerated) {
        return this.extra.put(newGenerated, element);
    }

    public CommonElement getIntermediateSource(CommonElement generatedElement) {
        return this.extra.get(generatedElement);
    }

    public CommonElement resetGeneratedCache(Element umlElement) {
        return (CommonElement)this.generated.remove((Object)umlElement);
    }

    public boolean setChangeSet(Collection<EObject> changedElements) {
        Functions.Function1<EObject, Boolean> _function = new Functions.Function1<EObject, Boolean>(){

            public Boolean apply(EObject it) {
                return it instanceof Element;
            }
        };
        Iterable _filter = IterableExtensions.filter(changedElements, (Functions.Function1)_function);
        Functions.Function1<EObject, Element> _function_1 = new Functions.Function1<EObject, Element>(){

            public Element apply(EObject it) {
                return (Element)it;
            }
        };
        Iterable _map = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
        return Iterables.addAll(this.changed, (Iterable)_map);
    }

    public IStatus generate(List<EObject> inputElements, Path outputPath) {
        MultiStatus _xblockexpression = null;
        this.inputElements = inputElements;
        this.outputPath = outputPath;
        MultiStatus result = new MultiStatus("org.eclipse.papyrusrt.codegen", 1, "UML-RT to xtUMLrt translator invoked", null);
        try {
            HashSet _newHashSet;
            for (Element element : this.changed) {
                this.resetGeneratedCache(element);
                this.resetTranslateCache((EObject)element);
            }
            long start = System.currentTimeMillis();
            for (EObject target : inputElements) {
                if (!(target instanceof Element)) {
                    String _string = target.toString();
                    String _plus = "Ignoring element " + _string;
                    String _plus_1 = String.valueOf(_plus) + ": it is not a UML2 element.";
                    IStatus _info = CodeGenPlugin.info((String)_plus_1);
                    result.add(_info);
                    continue;
                }
                this.translateElement((Element)target);
            }
            this.changed = _newHashSet = CollectionLiterals.newHashSet((Object[])new Element[0]);
            long _currentTimeMillis = System.currentTimeMillis();
            long _minus = _currentTimeMillis - start;
            String _plus_2 = "Translated model to xtUMLrt sucessfully " + Long.valueOf(_minus);
            String _plus_3 = String.valueOf(_plus_2) + "ms";
            IStatus _info_1 = CodeGenPlugin.info((String)_plus_3);
            result.add(_info_1);
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                IStatus _error = CodeGenPlugin.error((String)"Error while translating model to xtUMLrt", (Throwable)e);
                result.add(_error);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public boolean write() {
        boolean _xblockexpression = false;
        boolean success = true;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        for (EObject target : this.inputElements) {
            Path fileName;
            Resource _eResource;
            URI uri;
            String _path;
            Path elementPath;
            if (!(target instanceof Element) || (elementPath = Paths.get(_path = (uri = (_eResource = ((Element)target).eResource()).getURI()).path(), new String[0])) == null || (fileName = elementPath.getFileName()) == null) continue;
            String fileNameStr = fileName.toString();
            int _lastIndexOf = fileNameStr.lastIndexOf(".");
            String fileNameWithoutExt = fileNameStr.substring(0, _lastIndexOf);
            String newFileName = String.valueOf(fileNameWithoutExt) + "." + XTUMLRT_EXTENSION;
            Path _resolve = this.outputPath.resolve(newFileName);
            String fullPath = _resolve.toString();
            URI _createFileURI = URI.createFileURI((String)fullPath);
            Resource resource = resourceSet.createResource(_createFileURI);
            CommonElement gen = this.getGenerated((Element)target);
            EList _contents = resource.getContents();
            _contents.add((Object)gen);
            Set _values = this.generated.values();
            for (CommonElement eobj : _values) {
                boolean _isSystemElement;
                if (!(eobj instanceof CommonElement) || !(_isSystemElement = RTSModelLibraryUtils.isSystemElement((CommonElement)eobj))) continue;
                EList _contents_1 = resource.getContents();
                _contents_1.add((Object)eobj);
            }
            try {
                resource.save(Collections.EMPTY_MAP);
            }
            catch (Throwable _t) {
                if (_t instanceof IOException) {
                    IOException cfr_ignored_0 = (IOException)_t;
                    success = false;
                    continue;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        _xblockexpression = success;
        return _xblockexpression;
    }

    public abstract CommonElement translate(Element var1);

    public abstract Enumerator translateEnum(Enum<?> var1);

    public abstract void resetTranslateCache(EObject var1);

    public CommonElement translateOptionalElement(Element umlElement) {
        CommonElement _xifexpression = null;
        _xifexpression = umlElement == null ? null : this.translateElement(umlElement);
        return _xifexpression;
    }

    public CommonElement translateElement(Element umlElement) {
        CommonElement _xblockexpression = null;
        boolean _containsKey = this.generated.containsKey((Object)umlElement);
        if (_containsKey) {
            return (CommonElement)this.generated.get((Object)umlElement);
        }
        CommonElement translated = this.translate(umlElement);
        if (translated != null && !UMLRTProfileUtil.isProtocolContainer((Element)umlElement)) {
            this.generated.put((Object)umlElement, (Object)translated);
        }
        this.orderedGeneratedList.add((EObject)translated);
        _xblockexpression = translated;
        return _xblockexpression;
    }

    public Enumerator translateKind(Enum<?> kind) {
        try {
            Enumerator _xblockexpression = null;
            Enumerator translated = this.translateEnum(kind);
            if (translated == null) {
                Class<?> _class = kind.getClass();
                throw new TranslationException(kind, "-", Enum.class, Enumerator.class, _class, null, "The result of translating this element did not yield an EMF Enumerator");
            }
            _xblockexpression = translated;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public CommonElement translateFeature(Element umlElement, String featureName, Class<?> expectedSourceType, Class<?> expectedTargetType) {
        return this.translateFeature(umlElement, featureName, expectedSourceType, expectedTargetType, false);
    }

    public CommonElement translateFeature(Element umlElement, String featureName, Class<?> expectedSourceType, Class<?> expectedTargetType, boolean sourceMaybeNull) {
        CommonElement _xblockexpression = null;
        this.checkFeature(umlElement, featureName, expectedSourceType, expectedTargetType);
        EStructuralFeature feature = this.getFeature(umlElement, featureName, expectedSourceType, expectedTargetType);
        Object featureContent = umlElement.eGet(feature);
        if (sourceMaybeNull && featureContent == null) {
            return null;
        }
        this.checkFeatureContent(umlElement, featureName, expectedSourceType, expectedTargetType, featureContent);
        CommonElement result = this.translateElement((Element)featureContent);
        Class<?> _class = featureContent.getClass();
        this.checkFeatureResult(umlElement, featureName, expectedSourceType, expectedTargetType, _class, result);
        _xblockexpression = result;
        return _xblockexpression;
    }

    public Enumerator translateEnumFeature(Element umlElement, String featureName, Class<?> expectedSourceType, Class<?> expectedTargetType) {
        Enumerator _xblockexpression = null;
        this.checkFeature(umlElement, featureName, expectedSourceType, expectedTargetType);
        EStructuralFeature feature = this.getFeature(umlElement, featureName, expectedSourceType, expectedTargetType);
        Object featureContent = umlElement.eGet(feature);
        this.checkKindFeatureContent(umlElement, featureName, expectedSourceType, expectedTargetType, featureContent);
        Enumerator result = this.translateKind((Enum)featureContent);
        Class<?> _class = featureContent.getClass();
        this.checkFeatureResult(umlElement, featureName, expectedSourceType, expectedTargetType, _class, result);
        _xblockexpression = result;
        return _xblockexpression;
    }

    public EStructuralFeature getFeature(Element umlElement, final String featureName, Class<?> expectedSourceType, Class<?> expectedTargetType) {
        try {
            EStructuralFeature _xblockexpression = null;
            EClass _eClass = umlElement.eClass();
            EList _eAllStructuralFeatures = _eClass.getEAllStructuralFeatures();
            Functions.Function1<EStructuralFeature, Boolean> _function = new Functions.Function1<EStructuralFeature, Boolean>(){

                public Boolean apply(EStructuralFeature it) {
                    String _name = it.getName();
                    return Objects.equal((Object)_name, (Object)featureName);
                }
            };
            EStructuralFeature feature = (EStructuralFeature)IterableExtensions.findFirst((Iterable)_eAllStructuralFeatures, (Functions.Function1)_function);
            if (feature == null) {
                throw new TranslationException(umlElement, featureName, expectedSourceType, expectedSourceType, null, null, "Attempting to translate a feature which doesn't exist in a UML element");
            }
            _xblockexpression = feature;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void checkFeature(Element umlElement, String featureName, Class<?> expectedSourceType, Class<?> expectedTargetType) {
        try {
            if (umlElement == null && featureName == null) {
                throw new TranslationException(null, null, expectedSourceType, expectedTargetType, null, null, "Attempting to translate a null feature of a null UML element");
            }
            if (umlElement == null && featureName != null) {
                throw new TranslationException(null, featureName, expectedSourceType, expectedTargetType, null, null, "Attempting to translate a feature of a null UML element");
            }
            if (featureName == null) {
                throw new TranslationException(umlElement, null, expectedSourceType, expectedTargetType, null, null, "Attempting to translate a null feature of a UML element");
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void checkFeatureContent(Element umlElement, String featureName, Class<?> expectedSourceType, Class<?> expectedTargetType, Object featureContent) {
        try {
            boolean _not;
            if (featureContent == null) {
                throw new TranslationException(umlElement, featureName, expectedSourceType, expectedTargetType, null, null, "The value of this UML element feature is null but should not be null");
            }
            if (!(featureContent instanceof Element)) {
                Class<?> _class = featureContent.getClass();
                throw new TranslationException(umlElement, featureName, expectedSourceType, expectedTargetType, _class, null, "Feature value is not a UML element");
            }
            boolean _isInstance = expectedSourceType.isInstance(featureContent);
            boolean bl = _not = !_isInstance;
            if (_not) {
                Class<?> _class_1 = featureContent.getClass();
                throw new TranslationException(umlElement, featureName, expectedSourceType, expectedTargetType, _class_1, null, "The actual type of this feature's value does not match its expected type");
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void checkKindFeatureContent(Element umlElement, String featureName, Class<?> expectedSourceType, Class<?> expectedTargetType, Object featureContent) {
        try {
            boolean _not;
            if (featureContent == null) {
                throw new TranslationException(umlElement, featureName, expectedSourceType, expectedTargetType, null, null, "The value of a UML element feature is null");
            }
            if (!(featureContent instanceof Enumeration) && !(featureContent instanceof Enum)) {
                Class<?> _class = featureContent.getClass();
                throw new TranslationException(umlElement, featureName, expectedSourceType, expectedTargetType, _class, null, "Feature value is not a UML enumeration");
            }
            boolean _isInstance = expectedSourceType.isInstance(featureContent);
            boolean bl = _not = !_isInstance;
            if (_not) {
                Class<?> _class_1 = featureContent.getClass();
                throw new TranslationException(umlElement, featureName, expectedSourceType, expectedTargetType, _class_1, null, "The actual type of this feature's value does not match its expected type");
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void checkFeatureResult(Element umlElement, String featureName, Class<?> expectedSourceType, Class<?> expectedTargetType, Class<?> actualSourceType, Object result) {
        try {
            boolean _not;
            boolean _isInstance = expectedTargetType.isInstance(result);
            boolean bl = _not = !_isInstance;
            if (_not) {
                Class<?> _class = result.getClass();
                throw new TranslationException(umlElement, featureName, expectedSourceType, expectedTargetType, actualSourceType, _class, "The translated element's type does not match the expected type");
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected void translateRedefinableElement(RedefinableElement element, org.eclipse.papyrusrt.xtumlrt.common.RedefinableElement newElement) {
        if (element.getRedefinedElements() != null && !element.getRedefinedElements().isEmpty()) {
            EList _redefinedElements = element.getRedefinedElements();
            RedefinableElement redefinedElement = (RedefinableElement)_redefinedElements.get(0);
            CommonElement _translateElement = this.translateElement((Element)redefinedElement);
            newElement.setRedefines((org.eclipse.papyrusrt.xtumlrt.common.RedefinableElement)_translateElement);
        }
    }

    @Data
    public static class TranslationException
    extends DetailedException {
        private final Object element;
        private final String feature;
        private final Class<?> expectedSourceType;
        private final Class<?> expectedTargetType;
        private final Class<?> actualSourceType;
        private final Class<?> actualTargetType;
        private final String msg;

        public String toString() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"Translation error: ");
            _builder.append((Object)this.msg, "");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"  ");
            _builder.append((Object)"UML element: ");
            String _uMLElementInfoStr = this.getUMLElementInfoStr();
            _builder.append((Object)_uMLElementInfoStr, "  ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"  ");
            _builder.append((Object)"Feature: ");
            _builder.append((Object)this.feature, "  ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"  ");
            _builder.append((Object)"Expected UML type: ");
            CharSequence _maybeNullStr = this.maybeNullStr(this.expectedSourceType);
            _builder.append((Object)_maybeNullStr, "  ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"  ");
            _builder.append((Object)"Actual UML type: ");
            CharSequence _maybeNullStr_1 = this.maybeNullStr(this.actualSourceType);
            _builder.append((Object)_maybeNullStr_1, "  ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"  ");
            CharSequence _compatibleTypes = this.compatibleTypes(this.expectedSourceType, this.actualSourceType, "UML element");
            _builder.append((Object)_compatibleTypes, "  ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"  ");
            _builder.append((Object)"Expected translated type: ");
            CharSequence _maybeNullStr_2 = this.maybeNullStr(this.expectedTargetType);
            _builder.append((Object)_maybeNullStr_2, "  ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"  ");
            _builder.append((Object)"Actual translated type: ");
            CharSequence _maybeNullStr_3 = this.maybeNullStr(this.actualTargetType);
            _builder.append((Object)_maybeNullStr_3, "  ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"  ");
            CharSequence _compatibleTypes_1 = this.compatibleTypes(this.expectedTargetType, this.actualTargetType, "translated element");
            _builder.append((Object)_compatibleTypes_1, "  ");
            _builder.newLineIfNotEmpty();
            return _builder.toString();
        }

        public CharSequence maybeNullStr(Class<?> c) {
            StringConcatenation _builder = new StringConcatenation();
            if (c == null) {
                _builder.append((Object)"<undefined>");
            } else {
                String _name = c.getName();
                _builder.append((Object)_name, "");
            }
            return _builder;
        }

        public String getUMLElementInfoStr() {
            if (this.element == null) {
                return "null UML element";
            }
            if (this.element instanceof NamedElement) {
                return ((NamedElement)this.element).getQualifiedName();
            }
            if (this.element instanceof Enum) {
                return ((Enum)this.element).name();
            }
            String _string = this.element.toString();
            return "non-UML element: " + _string;
        }

        public CharSequence compatibleTypes(Class<?> source, Class<?> target, String item) {
            StringConcatenation _builder = new StringConcatenation();
            if (source != null && target != null) {
                boolean _not;
                boolean _isAssignableFrom = source.isAssignableFrom(target);
                if (_isAssignableFrom) {
                    _builder.append((Object)"[OK] ");
                } else {
                    _builder.append((Object)"[ERROR] ");
                }
                _builder.append((Object)"The actual ");
                _builder.append((Object)item, "");
                _builder.append((Object)" type is ");
                boolean _isAssignableFrom_1 = source.isAssignableFrom(target);
                boolean bl = _not = !_isAssignableFrom_1;
                if (_not) {
                    _builder.append((Object)"NOT ");
                }
                _builder.append((Object)"compatible with the expected ");
                _builder.append((Object)item, "");
                _builder.append((Object)" type");
            }
            return _builder;
        }

        public TranslationException(Object element, String feature, Class<?> expectedSourceType, Class<?> expectedTargetType, Class<?> actualSourceType, Class<?> actualTargetType, String msg) {
            this.element = element;
            this.feature = feature;
            this.expectedSourceType = expectedSourceType;
            this.expectedTargetType = expectedTargetType;
            this.actualSourceType = actualSourceType;
            this.actualTargetType = actualTargetType;
            this.msg = msg;
        }

        @Pure
        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.element == null ? 0 : this.element.hashCode());
            result = 31 * result + (this.feature == null ? 0 : this.feature.hashCode());
            result = 31 * result + (this.expectedSourceType == null ? 0 : this.expectedSourceType.hashCode());
            result = 31 * result + (this.expectedTargetType == null ? 0 : this.expectedTargetType.hashCode());
            result = 31 * result + (this.actualSourceType == null ? 0 : this.actualSourceType.hashCode());
            result = 31 * result + (this.actualTargetType == null ? 0 : this.actualTargetType.hashCode());
            result = 31 * result + (this.msg == null ? 0 : this.msg.hashCode());
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            TranslationException other = (TranslationException)((Object)obj);
            if (this.element == null ? other.element != null : !this.element.equals(other.element)) {
                return false;
            }
            if (this.feature == null ? other.feature != null : !this.feature.equals(other.feature)) {
                return false;
            }
            if (this.expectedSourceType == null ? other.expectedSourceType != null : !this.expectedSourceType.equals(other.expectedSourceType)) {
                return false;
            }
            if (this.expectedTargetType == null ? other.expectedTargetType != null : !this.expectedTargetType.equals(other.expectedTargetType)) {
                return false;
            }
            if (this.actualSourceType == null ? other.actualSourceType != null : !this.actualSourceType.equals(other.actualSourceType)) {
                return false;
            }
            if (this.actualTargetType == null ? other.actualTargetType != null : !this.actualTargetType.equals(other.actualTargetType)) {
                return false;
            }
            return !(this.msg == null ? other.msg != null : !this.msg.equals(other.msg));
        }

        @Pure
        public Object getElement() {
            return this.element;
        }

        @Pure
        public String getFeature() {
            return this.feature;
        }

        @Pure
        public Class<?> getExpectedSourceType() {
            return this.expectedSourceType;
        }

        @Pure
        public Class<?> getExpectedTargetType() {
            return this.expectedTargetType;
        }

        @Pure
        public Class<?> getActualSourceType() {
            return this.actualSourceType;
        }

        @Pure
        public Class<?> getActualTargetType() {
            return this.actualTargetType;
        }

        @Pure
        public String getMsg() {
            return this.msg;
        }
    }
}

