/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service;

import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.model.ICAddressBreakpoint;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICBreakpointExtension;
import org.eclipse.cdt.debug.core.model.ICDynamicPrintf;
import org.eclipse.cdt.debug.core.model.ICFunctionBreakpoint;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.ICTracepoint;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.service.IDsfBreakpointExtension;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.ISourceLookup;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.internal.tracepointactions.CollectAction;
import org.eclipse.cdt.dsf.gdb.internal.tracepointactions.EvaluateAction;
import org.eclipse.cdt.dsf.gdb.internal.tracepointactions.ITracepointAction;
import org.eclipse.cdt.dsf.gdb.internal.tracepointactions.TracepointActionManager;
import org.eclipse.cdt.dsf.gdb.internal.tracepointactions.WhileSteppingAction;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIProcesses;
import org.eclipse.cdt.dsf.mi.service.MIBreakpointDMData;
import org.eclipse.cdt.dsf.mi.service.MIBreakpoints;
import org.eclipse.cdt.dsf.mi.service.MIBreakpointsManager;
import org.eclipse.cdt.dsf.mi.service.command.output.MIBreakpoint;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.osgi.framework.BundleContext;

public class MIBreakpointsSynchronizer
extends AbstractDsfService
implements MIBreakpointsManager.IMIBreakpointsTrackingListener {
    private static final String CE_EXCEPTION_CATCH = "exception catch";
    private static final String CE_EXCEPTION_THROW = "exception throw";
    private static final String TC_COLLECT = "collect ";
    private static final String TC_TEVAL = "teval ";
    private static final String TC_WHILE_STEPPING = "while-stepping ";
    private static final String TC_END = "end";
    private IMICommandControl fConnection;
    private MIBreakpoints fBreakpointsService;
    private MIBreakpointsManager fBreakpointsManager;
    private Set<IBreakpoints.IBreakpointsTargetDMContext> fTrackedTargets = new HashSet<IBreakpoints.IBreakpointsTargetDMContext>();
    private Map<IBreakpoints.IBreakpointsTargetDMContext, Map<String, MIBreakpoint>> fCreatedTargetBreakpoints = new HashMap<IBreakpoints.IBreakpointsTargetDMContext, Map<String, MIBreakpoint>>();
    private Map<IBreakpoints.IBreakpointsTargetDMContext, Set<String>> fDeletedTargetBreakpoints = new HashMap<IBreakpoints.IBreakpointsTargetDMContext, Set<String>>();
    private Map<IBreakpoints.IBreakpointsTargetDMContext, Map<String, MIBreakpoint>> fPendingModifications = new HashMap<IBreakpoints.IBreakpointsTargetDMContext, Map<String, MIBreakpoint>>();

    public MIBreakpointsSynchronizer(DsfSession session) {
        super(session);
    }

    protected BundleContext getBundleContext() {
        return GdbPlugin.getBundleContext();
    }

    public void initialize(final RequestMonitor rm) {
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(rm){

            protected void handleSuccess() {
                MIBreakpointsSynchronizer.this.doInitialize(rm);
            }
        });
    }

    private void doInitialize(RequestMonitor rm) {
        this.fConnection = (IMICommandControl)this.getServicesTracker().getService(IMICommandControl.class);
        this.fBreakpointsService = (MIBreakpoints)this.getServicesTracker().getService(MIBreakpoints.class);
        this.fBreakpointsManager = (MIBreakpointsManager)((Object)this.getServicesTracker().getService(MIBreakpointsManager.class));
        if (this.fConnection == null || this.fBreakpointsService == null && this.fBreakpointsManager == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", "Service is not available"));
            rm.done();
            return;
        }
        this.fBreakpointsManager.addBreakpointsTrackingListener(this);
        this.getSession().addServiceEventListener((Object)this, null);
        this.register(new String[]{MIBreakpointsSynchronizer.class.getName()}, new Hashtable());
        rm.done();
    }

    public void shutdown(RequestMonitor rm) {
        this.fTrackedTargets.clear();
        this.fCreatedTargetBreakpoints.clear();
        this.fDeletedTargetBreakpoints.clear();
        this.fPendingModifications.clear();
        this.getSession().removeServiceEventListener((Object)this);
        MIBreakpointsManager bm = this.getBreakpointsManager();
        if (bm != null) {
            bm.removeBreakpointsTrackingListener(this);
        }
        this.unregister();
        super.shutdown(rm);
    }

    @Override
    public void breakpointTrackingStarted(IBreakpoints.IBreakpointsTargetDMContext bpTargetDMC) {
        this.fTrackedTargets.add(bpTargetDMC);
    }

    @Override
    public void breakpointTrackingStopped(IBreakpoints.IBreakpointsTargetDMContext bpTargetDMC) {
        this.fTrackedTargets.remove(bpTargetDMC);
    }

    private IMICommandControl getCommandControl() {
        return this.fConnection;
    }

    private MIBreakpoints getBreakpointsService() {
        return this.fBreakpointsService;
    }

    private MIBreakpointsManager getBreakpointsManager() {
        return this.fBreakpointsManager;
    }

    public void targetBreakpointCreated(final MIBreakpoint miBpt) {
        if (this.isCatchpoint(miBpt)) {
            return;
        }
        IMICommandControl commandControl = this.getCommandControl();
        MIBreakpoints breakpointsService = this.getBreakpointsService();
        final MIBreakpointsManager bm = this.getBreakpointsManager();
        if (commandControl == null || breakpointsService == null || bm == null) {
            return;
        }
        final IBreakpoints.IBreakpointsTargetDMContext bpTargetDMC = this.getBreakpointsTargetContext(commandControl, miBpt);
        if (bpTargetDMC == null) {
            return;
        }
        Map<String, MIBreakpointDMData> contextBreakpoints = breakpointsService.getBreakpointMap(bpTargetDMC);
        if (contextBreakpoints == null) {
            contextBreakpoints = breakpointsService.createNewBreakpointMap(bpTargetDMC);
        }
        contextBreakpoints.put(miBpt.getNumber(), new MIBreakpointDMData(miBpt));
        Map<String, MIBreakpoint> targetMap = this.fCreatedTargetBreakpoints.get(bpTargetDMC);
        if (targetMap == null) {
            targetMap = new HashMap<String, MIBreakpoint>();
            this.fCreatedTargetBreakpoints.put(bpTargetDMC, targetMap);
        }
        targetMap.put(miBpt.getNumber(), miBpt);
        String debuggerPath = this.getFileName(miBpt);
        this.getSource(bpTargetDMC, debuggerPath, new DataRequestMonitor<String>((Executor)this.getExecutor(), null){

            @ConfinedToDsfExecutor(value="fExecutor")
            protected void handleSuccess() {
                String fileName = (String)this.getData();
                if (fileName == null) {
                    fileName = MIBreakpointsSynchronizer.this.getFileName(miBpt);
                }
                ICBreakpoint plBpt = MIBreakpointsSynchronizer.this.getPlatformBreakpoint(miBpt, fileName);
                String threadId = miBpt.getThreadId();
                boolean isThreadSpecific = threadId != null && !threadId.isEmpty() && !"0".equals(threadId);
                try {
                    Map map;
                    if (plBpt == null) {
                        plBpt = MIBreakpointsSynchronizer.this.createPlatformBreakpoint(fileName, miBpt);
                        if (isThreadSpecific) {
                            MIBreakpointsSynchronizer.this.setThreadSpecificBreakpoint(plBpt, miBpt);
                        }
                    } else if (MIBreakpointsSynchronizer.this.isBreakpointTargetTracked(bpTargetDMC)) {
                        if (isThreadSpecific) {
                            MIBreakpointsSynchronizer.this.setThreadSpecificBreakpoint(plBpt, miBpt);
                        }
                        bm.breakpointAdded((IBreakpoint)plBpt);
                    }
                    if ((map = (Map)MIBreakpointsSynchronizer.this.fPendingModifications.get(bpTargetDMC)) != null) {
                        MIBreakpoint mod = (MIBreakpoint)map.remove(miBpt.getNumber());
                        if (mod != null) {
                            MIBreakpointsSynchronizer.this.targetBreakpointModified(bpTargetDMC, plBpt, mod);
                        }
                    } else {
                        MIBreakpointsSynchronizer.this.targetBreakpointModified(bpTargetDMC, plBpt, miBpt);
                    }
                }
                catch (CoreException e) {
                    GdbPlugin.log(this.getStatus());
                }
                super.handleSuccess();
            }
        });
    }

    public void targetBreakpointDeleted(final String id) {
        MIBreakpoints breakpointsService = this.getBreakpointsService();
        final MIBreakpointsManager bm = this.getBreakpointsManager();
        if (breakpointsService == null || bm == null) {
            return;
        }
        final IBreakpoints.IBreakpointsTargetDMContext bpTargetDMC = breakpointsService.getBreakpointTargetContext(id);
        if (bpTargetDMC != null) {
            final MIBreakpoints.MIBreakpointDMContext bpDMC = new MIBreakpoints.MIBreakpointDMContext(breakpointsService, new IDMContext[]{bpTargetDMC}, id);
            breakpointsService.getBreakpointDMData(bpDMC, new DataRequestMonitor<IBreakpoints.IBreakpointDMData>((Executor)this.getExecutor(), null){

                @ConfinedToDsfExecutor(value="fExecutor")
                protected void handleSuccess() {
                    if (!(this.getData() instanceof MIBreakpointDMData)) {
                        return;
                    }
                    MIBreakpointDMData data = (MIBreakpointDMData)this.getData();
                    if ("catchpoint".equals(data.getBreakpointType())) {
                        return;
                    }
                    IBreakpoint plBpt = bm.findPlatformBreakpoint(bpDMC);
                    if (plBpt instanceof ICBreakpoint) {
                        HashSet<String> set = (HashSet<String>)MIBreakpointsSynchronizer.this.fDeletedTargetBreakpoints.get(bpTargetDMC);
                        if (set == null) {
                            set = new HashSet<String>();
                            MIBreakpointsSynchronizer.this.fDeletedTargetBreakpoints.put(bpTargetDMC, set);
                        }
                        set.add(id);
                        try {
                            String threadId = data.getThreadId();
                            if (!threadId.equals("0")) {
                                IDsfBreakpointExtension bpExtension = (IDsfBreakpointExtension)((ICBreakpoint)plBpt).getExtension("org.eclipse.cdt.dsf.gdb", ICBreakpointExtension.class);
                                IMIProcesses processes = (IMIProcesses)MIBreakpointsSynchronizer.this.getServicesTracker().getService(IMIProcesses.class);
                                if (processes == null) {
                                    return;
                                }
                                IMIContainerDMContext contDMC = processes.createContainerContextFromThreadId(MIBreakpointsSynchronizer.this.getCommandControl().getContext(), data.getThreadId());
                                if (contDMC == null) {
                                    return;
                                }
                                IRunControl.IExecutionDMContext[] execDMCs = bpExtension.getThreadFilters((IRunControl.IContainerDMContext)contDMC);
                                ArrayList<IRunControl.IExecutionDMContext> list = new ArrayList<IRunControl.IExecutionDMContext>(execDMCs.length);
                                IRunControl.IExecutionDMContext[] iExecutionDMContextArray = execDMCs;
                                int n = execDMCs.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IRunControl.IExecutionDMContext c = iExecutionDMContextArray[n2];
                                    if (c instanceof IMIExecutionDMContext && !((IMIExecutionDMContext)c).getThreadId().equals(threadId)) {
                                        list.add(c);
                                    }
                                    ++n2;
                                }
                                if (!list.isEmpty()) {
                                    bpExtension.setThreadFilters(list.toArray(new IRunControl.IExecutionDMContext[list.size()]));
                                } else {
                                    bm.uninstallBreakpoint(bpTargetDMC, (ICBreakpoint)plBpt, new RequestMonitor((Executor)MIBreakpointsSynchronizer.this.getExecutor(), null));
                                }
                            } else {
                                bm.uninstallBreakpoint(bpTargetDMC, (ICBreakpoint)plBpt, new RequestMonitor((Executor)MIBreakpointsSynchronizer.this.getExecutor(), null));
                            }
                        }
                        catch (CoreException e) {
                            GdbPlugin.log(e.getStatus());
                        }
                    }
                }
            });
        }
    }

    public void targetBreakpointModified(MIBreakpoint miBpt) {
        if (this.isCatchpoint(miBpt)) {
            return;
        }
        IMICommandControl commandControl = this.getCommandControl();
        MIBreakpoints breakpointsService = this.getBreakpointsService();
        MIBreakpointsManager bm = this.getBreakpointsManager();
        if (commandControl != null && breakpointsService != null && bm != null) {
            IBreakpoints.IBreakpointsTargetDMContext bpTargetDMC = this.getBreakpointsTargetContext(commandControl, miBpt);
            if (bpTargetDMC == null) {
                return;
            }
            Map<String, MIBreakpointDMData> contextBreakpoints = breakpointsService.getBreakpointMap(bpTargetDMC);
            if (contextBreakpoints == null) {
                return;
            }
            IBreakpoint b = bm.findPlatformBreakpoint(new MIBreakpoints.MIBreakpointDMContext(breakpointsService, new IDMContext[]{bpTargetDMC}, miBpt.getNumber()));
            if (!(b instanceof ICBreakpoint)) {
                Map<String, MIBreakpoint> map = this.fPendingModifications.get(bpTargetDMC);
                if (map == null) {
                    map = new HashMap<String, MIBreakpoint>();
                    this.fPendingModifications.put(bpTargetDMC, map);
                }
                map.put(miBpt.getNumber(), miBpt);
            } else {
                ICBreakpoint plBpt = (ICBreakpoint)b;
                this.targetBreakpointModified(bpTargetDMC, plBpt, miBpt);
            }
        }
    }

    private void targetBreakpointModified(IBreakpoints.IBreakpointsTargetDMContext bpTargetDMC, ICBreakpoint plBpt, MIBreakpoint miBpt) {
        Map<String, MIBreakpointDMData> contextBreakpoints = this.getBreakpointsService().getBreakpointMap(bpTargetDMC);
        MIBreakpointDMData oldData = contextBreakpoints.get(miBpt.getNumber());
        contextBreakpoints.put(miBpt.getNumber(), new MIBreakpointDMData(miBpt));
        try {
            if (plBpt.isEnabled() != miBpt.isEnabled()) {
                plBpt.setEnabled(miBpt.isEnabled());
            }
            if (!plBpt.getCondition().equals(miBpt.getCondition())) {
                plBpt.setCondition(miBpt.getCondition());
            }
            if (plBpt.getIgnoreCount() != miBpt.getIgnoreCount()) {
                plBpt.setIgnoreCount(miBpt.getIgnoreCount());
            }
            if (oldData.isPending() != miBpt.isPending()) {
                if (miBpt.isPending()) {
                    plBpt.decrementInstallCount();
                } else {
                    plBpt.incrementInstallCount();
                }
            }
            if (plBpt instanceof ICTracepoint && miBpt.isTracepoint()) {
                ICTracepoint plTpt = (ICTracepoint)plBpt;
                if (plTpt.getPassCount() != miBpt.getPassCount()) {
                    plTpt.setPassCount(miBpt.getPassCount());
                }
                if (!miBpt.getCommands().equals(plBpt.getMarker().getAttribute("BREAKPOINT_ACTIONS"))) {
                    StringBuilder sb = new StringBuilder();
                    boolean first = true;
                    String[] commands = miBpt.getCommands().split("%_#");
                    ITracepointAction[] iTracepointActionArray = this.getActionsFromCommands(commands);
                    int n = iTracepointActionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ITracepointAction action = iTracepointActionArray[n2];
                        if (first) {
                            first = false;
                        } else {
                            sb.append("%_#");
                        }
                        sb.append(action.getName());
                        ++n2;
                    }
                    miBpt.setCommands(sb.toString());
                    plBpt.getMarker().setAttribute("BREAKPOINT_ACTIONS", (Object)sb.toString());
                }
            } else if (plBpt instanceof ICDynamicPrintf) {
                miBpt.isDynamicPrintf();
            }
        }
        catch (CoreException e) {
            contextBreakpoints.put(miBpt.getNumber(), oldData);
            GdbPlugin.log(e.getStatus());
        }
    }

    private void setThreadSpecificBreakpoint(ICBreakpoint plBpt, MIBreakpoint miBpt) {
        try {
            IMIProcesses processes = (IMIProcesses)this.getServicesTracker().getService(IMIProcesses.class);
            if (processes == null) {
                return;
            }
            String threadId = miBpt.getThreadId();
            IMIContainerDMContext contDMC = processes.createContainerContextFromThreadId(this.getCommandControl().getContext(), threadId);
            if (contDMC == null) {
                return;
            }
            IProcesses.IProcessDMContext procDmc = (IProcesses.IProcessDMContext)DMContexts.getAncestorOfType((IDMContext)contDMC, IProcesses.IProcessDMContext.class);
            if (procDmc == null) {
                return;
            }
            IDsfBreakpointExtension bpExtension = (IDsfBreakpointExtension)plBpt.getExtension("org.eclipse.cdt.dsf.gdb", ICBreakpointExtension.class);
            IRunControl.IExecutionDMContext[] execDMCs = bpExtension.getThreadFilters((IRunControl.IContainerDMContext)contDMC);
            if (execDMCs == null) {
                execDMCs = new IRunControl.IExecutionDMContext[]{};
            }
            IRunControl.IExecutionDMContext[] iExecutionDMContextArray = execDMCs;
            int n = execDMCs.length;
            int n2 = 0;
            while (n2 < n) {
                IRunControl.IExecutionDMContext execDMC = iExecutionDMContextArray[n2];
                String ctxThreadId = ((IMIExecutionDMContext)execDMC).getThreadId();
                if (execDMC instanceof IMIExecutionDMContext && ctxThreadId.equals(threadId)) {
                    return;
                }
                ++n2;
            }
            IRunControl.IExecutionDMContext[] newExecDMCs = new IRunControl.IExecutionDMContext[execDMCs.length + 1];
            System.arraycopy(execDMCs, 0, newExecDMCs, 0, execDMCs.length);
            newExecDMCs[execDMCs.length] = processes.createExecutionContext(contDMC, processes.createThreadContext(procDmc, threadId), threadId);
            bpExtension.setThreadFilters(newExecDMCs);
        }
        catch (CoreException e) {
            GdbPlugin.log(e);
        }
    }

    private ICBreakpoint getPlatformBreakpoint(MIBreakpoint miBpt, String fileName) {
        IBreakpoint[] iBreakpointArray = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
        int n = iBreakpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint b = iBreakpointArray[n2];
            if (b instanceof ICTracepoint && miBpt.isTracepoint() && this.isPlatformTracepoint((ICTracepoint)b, miBpt, fileName)) {
                return (ICBreakpoint)b;
            }
            if (b instanceof ICDynamicPrintf && miBpt.isDynamicPrintf() && this.isPlatformDynamicPrintf((ICDynamicPrintf)b, miBpt, fileName)) {
                return (ICBreakpoint)b;
            }
            if (b instanceof ICWatchpoint && miBpt.isWatchpoint() && this.isPlatformWatchpoint((ICWatchpoint)b, miBpt)) {
                return (ICBreakpoint)b;
            }
            if (b instanceof ICLineBreakpoint && !miBpt.isWatchpoint() && !this.isCatchpoint(miBpt) && !miBpt.isTracepoint() && !miBpt.isDynamicPrintf() && this.isPlatformLineBreakpoint((ICLineBreakpoint)b, miBpt, fileName)) {
                return (ICBreakpoint)b;
            }
            ++n2;
        }
        return null;
    }

    private ICBreakpoint createPlatformBreakpoint(String fileName, MIBreakpoint miBpt) throws CoreException {
        if (miBpt.isWatchpoint()) {
            return this.createPlatformWatchpoint(fileName, miBpt);
        }
        if (miBpt.isTracepoint()) {
            return this.createPlatformTracepoint(fileName, miBpt);
        }
        if (miBpt.isDynamicPrintf()) {
            return this.createPlatformDynamicPrintf(fileName, miBpt);
        }
        return this.createPlatformLocationBreakpoint(fileName, miBpt);
    }

    private ICBreakpoint createPlatformLocationBreakpoint(String fileName, MIBreakpoint miBpt) throws CoreException {
        if (this.isAddressBreakpoint(miBpt)) {
            return this.createPlatformAddressBreakpoint(fileName, miBpt);
        }
        if (this.isFunctionBreakpoint(miBpt)) {
            return this.createPlatformFunctionBreakpoint(fileName, miBpt);
        }
        return this.createPlatformLineBreakpoint(fileName, miBpt);
    }

    private ICBreakpoint createPlatformAddressBreakpoint(String fileName, MIBreakpoint miBpt) throws CoreException {
        IResource resource = this.getResource(fileName);
        int type = 0;
        if (miBpt.isTemporary()) {
            type |= 1;
        }
        if (miBpt.isHardware()) {
            type |= 2;
        }
        try {
            return CDIDebugModel.createAddressBreakpoint(null, null, (IResource)resource, (int)type, (IAddress)this.getPlatformAddress(miBpt.getAddress()), (boolean)miBpt.isEnabled(), (int)miBpt.getIgnoreCount(), (String)miBpt.getCondition(), (boolean)true);
        }
        catch (NumberFormatException e) {
            throw new CoreException((IStatus)new Status(4, GdbPlugin.getUniqueIdentifier(), String.format("Invalid breakpoint address: %s", miBpt.getAddress())));
        }
    }

    private ICBreakpoint createPlatformFunctionTracepoint(String fileName, MIBreakpoint miBpt) throws CoreException {
        IResource resource = this.getResource(fileName);
        int type = 0;
        if (miBpt.isTemporary()) {
            type |= 1;
        }
        if (miBpt.isHardware()) {
            type |= 2;
        }
        return CDIDebugModel.createFunctionTracepoint((String)fileName, (IResource)resource, (int)type, (String)this.getFunctionName(miBpt), (int)-1, (int)-1, (int)this.getLineNumber(miBpt), (boolean)miBpt.isEnabled(), (int)miBpt.getIgnoreCount(), (String)miBpt.getCondition(), (boolean)true);
    }

    private ICBreakpoint createPlatformLineTracepoint(String fileName, MIBreakpoint miBpt) throws CoreException {
        IResource resource = this.getResource(fileName);
        int type = 0;
        if (miBpt.isTemporary()) {
            type |= 1;
        }
        if (miBpt.isHardware()) {
            type |= 2;
        }
        return CDIDebugModel.createLineTracepoint((String)fileName, (IResource)resource, (int)type, (int)this.getLineNumber(miBpt), (boolean)miBpt.isEnabled(), (int)miBpt.getIgnoreCount(), (String)miBpt.getCondition(), (boolean)true);
    }

    private ICBreakpoint createPlatformTracepoint(String fileName, MIBreakpoint miBpt) throws CoreException {
        if (this.isAddressBreakpoint(miBpt)) {
            return this.createPlatformAddressTracepoint(fileName, miBpt);
        }
        if (this.isFunctionBreakpoint(miBpt)) {
            return this.createPlatformFunctionTracepoint(fileName, miBpt);
        }
        return this.createPlatformLineTracepoint(fileName, miBpt);
    }

    private ICBreakpoint createPlatformAddressTracepoint(String fileName, MIBreakpoint miBpt) throws CoreException {
        IResource resource = this.getResource(fileName);
        int type = 0;
        if (miBpt.isTemporary()) {
            type |= 1;
        }
        if (miBpt.isHardware()) {
            type |= 2;
        }
        try {
            return CDIDebugModel.createAddressTracepoint(null, null, (IResource)resource, (int)type, (int)this.getLineNumber(miBpt), (IAddress)this.getPlatformAddress(miBpt.getAddress()), (boolean)miBpt.isEnabled(), (int)miBpt.getIgnoreCount(), (String)miBpt.getCondition(), (boolean)true);
        }
        catch (NumberFormatException e) {
            throw new CoreException((IStatus)new Status(4, GdbPlugin.getUniqueIdentifier(), String.format("Invalid breakpoint address: %s", miBpt.getAddress())));
        }
    }

    private ICBreakpoint createPlatformFunctionBreakpoint(String fileName, MIBreakpoint miBpt) throws CoreException {
        IResource resource = this.getResource(fileName);
        int type = 0;
        if (miBpt.isTemporary()) {
            type |= 1;
        }
        if (miBpt.isHardware()) {
            type |= 2;
        }
        return CDIDebugModel.createFunctionBreakpoint((String)fileName, (IResource)resource, (int)type, (String)this.getFunctionName(miBpt), (int)-1, (int)-1, (int)this.getLineNumber(miBpt), (boolean)miBpt.isEnabled(), (int)miBpt.getIgnoreCount(), (String)miBpt.getCondition(), (boolean)true);
    }

    private ICBreakpoint createPlatformLineBreakpoint(String fileName, MIBreakpoint miBpt) throws CoreException {
        IResource resource = this.getResource(fileName);
        int type = 0;
        if (miBpt.isTemporary()) {
            type |= 1;
        }
        if (miBpt.isHardware()) {
            type |= 2;
        }
        return CDIDebugModel.createLineBreakpoint((String)fileName, (IResource)resource, (int)type, (int)this.getLineNumber(miBpt), (boolean)miBpt.isEnabled(), (int)miBpt.getIgnoreCount(), (String)miBpt.getCondition(), (boolean)true);
    }

    private ICBreakpoint createPlatformDynamicPrintf(String fileName, MIBreakpoint miBpt) throws CoreException {
        if (this.isAddressBreakpoint(miBpt)) {
            return this.createPlatformAddressDynamicPrintf(fileName, miBpt);
        }
        return this.createPlatformLineDynamicPrintf(fileName, miBpt);
    }

    private ICBreakpoint createPlatformAddressDynamicPrintf(String fileName, MIBreakpoint miBpt) throws CoreException {
        IResource resource = this.getResource(fileName);
        int type = 0;
        if (miBpt.isTemporary()) {
            type |= 1;
        }
        if (miBpt.isHardware()) {
            type |= 2;
        }
        try {
            return CDIDebugModel.createAddressDynamicPrintf(null, null, (IResource)resource, (int)type, (int)this.getLineNumber(miBpt), (IAddress)this.getPlatformAddress(miBpt.getAddress()), (boolean)miBpt.isEnabled(), (int)miBpt.getIgnoreCount(), (String)miBpt.getCondition(), (String)miBpt.getPrintfString(), (boolean)true);
        }
        catch (NumberFormatException e) {
            throw new CoreException((IStatus)new Status(4, GdbPlugin.getUniqueIdentifier(), String.format("Invalid breakpoint address: %s", miBpt.getAddress())));
        }
    }

    private ICBreakpoint createPlatformFunctionDynamicPrintf(String fileName, MIBreakpoint miBpt) throws CoreException {
        IResource resource = this.getResource(fileName);
        int type = 0;
        if (miBpt.isTemporary()) {
            type |= 1;
        }
        if (miBpt.isHardware()) {
            type |= 2;
        }
        return CDIDebugModel.createFunctionDynamicPrintf((String)fileName, (IResource)resource, (int)type, (String)this.getFunctionName(miBpt), (int)-1, (int)-1, (int)this.getLineNumber(miBpt), (boolean)miBpt.isEnabled(), (int)miBpt.getIgnoreCount(), (String)miBpt.getCondition(), (String)miBpt.getPrintfString(), (boolean)true);
    }

    private ICBreakpoint createPlatformLineDynamicPrintf(String fileName, MIBreakpoint miBpt) throws CoreException {
        IResource resource = this.getResource(fileName);
        int type = 0;
        if (miBpt.isTemporary()) {
            type |= 1;
        }
        if (miBpt.isHardware()) {
            type |= 2;
        }
        return CDIDebugModel.createLineDynamicPrintf((String)fileName, (IResource)resource, (int)type, (int)this.getLineNumber(miBpt), (boolean)miBpt.isEnabled(), (int)miBpt.getIgnoreCount(), (String)miBpt.getCondition(), (String)miBpt.getPrintfString(), (boolean)true);
    }

    private ICBreakpoint createPlatformWatchpoint(String fileName, MIBreakpoint miBpt) throws CoreException {
        IResource resource = this.getResource(fileName);
        int type = 0;
        if (miBpt.isTemporary()) {
            type |= 1;
        }
        if (miBpt.isHardware()) {
            type |= 2;
        }
        return CDIDebugModel.createWatchpoint((String)fileName, (IResource)resource, (int)type, (miBpt.isAccessWatchpoint() || miBpt.isWriteWatchpoint() ? 1 : 0) != 0, (miBpt.isAccessWatchpoint() || miBpt.isReadWatchpoint() ? 1 : 0) != 0, (String)miBpt.getExpression(), (boolean)miBpt.isEnabled(), (int)miBpt.getIgnoreCount(), (String)miBpt.getCondition(), (boolean)true);
    }

    private IBreakpoints.IBreakpointsTargetDMContext getBreakpointsTargetContext(ICommandControlService commandControl, MIBreakpoint miBpt) {
        IMIProcesses processes = (IMIProcesses)this.getServicesTracker().getService(IMIProcesses.class);
        if (processes == null) {
            return null;
        }
        String threadId = miBpt != null ? miBpt.getThreadId() : null;
        IMIContainerDMContext contContext = processes.createContainerContextFromThreadId(commandControl.getContext(), threadId);
        if (contContext == null) {
            return null;
        }
        return (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)contContext, IBreakpoints.IBreakpointsTargetDMContext.class);
    }

    public void getTargetBreakpoint(IBreakpoints.IBreakpointsTargetDMContext context, Map<String, Object> attributes, DataRequestMonitor<MIBreakpoint> rm) {
        Map<String, MIBreakpoint> map = this.fCreatedTargetBreakpoints.get(context);
        if (map == null) {
            rm.done();
            return;
        }
        String type = (String)attributes.get("org.eclipse.cdt.dsf.debug.breakpoint.type");
        if ("breakpoint".equals(type)) {
            rm.done((Object)this.getTargetLineBreakpoint(map.values(), (String)attributes.get("org.eclipse.cdt.dsf.debug.breakpoint.fileName"), (Integer)attributes.get("org.eclipse.cdt.dsf.debug.breakpoint.lineNumber"), (String)attributes.get("org.eclipse.cdt.dsf.debug.breakpoint.function"), (String)attributes.get("org.eclipse.cdt.dsf.debug.breakpoint.address"), (Boolean)attributes.get("org.eclipse.cdt.dsf.debug.breakpoint.mi.isHardware"), (Boolean)attributes.get("org.eclipse.cdt.dsf.debug.breakpoint.mi.isTemporary")));
        } else if ("tracepoint".equals(type)) {
            rm.done((Object)this.getTargetTracepoint(map.values(), (String)attributes.get("org.eclipse.cdt.dsf.debug.breakpoint.fileName"), (Integer)attributes.get("org.eclipse.cdt.dsf.debug.breakpoint.lineNumber"), (String)attributes.get("org.eclipse.cdt.dsf.debug.breakpoint.function"), (String)attributes.get("org.eclipse.cdt.dsf.debug.breakpoint.address"), (Boolean)attributes.get("org.eclipse.cdt.dsf.debug.breakpoint.mi.isHardware"), (Boolean)attributes.get("org.eclipse.cdt.dsf.debug.breakpoint.mi.isTemporary")));
        } else if ("dynamicPrintf".equals(type)) {
            rm.done((Object)this.getTargetDPrintf(map.values(), (String)attributes.get("org.eclipse.cdt.dsf.debug.breakpoint.fileName"), (Integer)attributes.get("org.eclipse.cdt.dsf.debug.breakpoint.lineNumber"), (String)attributes.get("org.eclipse.cdt.dsf.debug.breakpoint.function"), (String)attributes.get("org.eclipse.cdt.dsf.debug.breakpoint.address"), (Boolean)attributes.get("org.eclipse.cdt.dsf.debug.breakpoint.mi.isHardware"), (Boolean)attributes.get("org.eclipse.cdt.dsf.debug.breakpoint.mi.isTemporary")));
        } else if ("watchpoint".equals(type)) {
            rm.done((Object)this.getTargetWatchpoint(map.values(), (String)attributes.get("org.eclipse.cdt.dsf.debug.breakpoint.expression"), (Boolean)attributes.get("org.eclipse.cdt.dsf.debug.breakpoint.read"), (Boolean)attributes.get("org.eclipse.cdt.dsf.debug.breakpoint.write"), (Boolean)attributes.get("org.eclipse.cdt.dsf.debug.breakpoint.mi.isHardware"), (Boolean)attributes.get("org.eclipse.cdt.dsf.debug.breakpoint.mi.isTemporary")));
        } else {
            rm.done();
        }
    }

    private MIBreakpoint getTargetLineBreakpoint(Collection<MIBreakpoint> targetBreakpoints, String fileName, Integer lineNumber, String function, String address, Boolean isHardware, Boolean isTemporary) {
        for (MIBreakpoint miBpt : targetBreakpoints) {
            if (miBpt.isWatchpoint() || this.isCatchpoint(miBpt) || miBpt.isTracepoint() || miBpt.isDynamicPrintf() || !this.compareBreakpointAttributes(miBpt, fileName, lineNumber, function, address, isHardware, isTemporary)) continue;
            return miBpt;
        }
        return null;
    }

    private MIBreakpoint getTargetTracepoint(Collection<MIBreakpoint> targetBreakpoints, String fileName, Integer lineNumber, String function, String address, Boolean isHardware, Boolean isTemporary) {
        for (MIBreakpoint miBpt : targetBreakpoints) {
            if (!miBpt.isTracepoint() || !this.compareBreakpointAttributes(miBpt, fileName, lineNumber, function, address, isHardware, isTemporary)) continue;
            return miBpt;
        }
        return null;
    }

    private MIBreakpoint getTargetDPrintf(Collection<MIBreakpoint> targetBreakpoints, String fileName, Integer lineNumber, String function, String address, Boolean isHardware, Boolean isTemporary) {
        for (MIBreakpoint miBpt : targetBreakpoints) {
            if (!miBpt.isDynamicPrintf() || !this.compareBreakpointAttributes(miBpt, fileName, lineNumber, function, address, isHardware, isTemporary)) continue;
            return miBpt;
        }
        return null;
    }

    private MIBreakpoint getTargetWatchpoint(Collection<MIBreakpoint> targetBreakpoints, String expression, boolean readAccess, boolean writeAccess, Boolean isHardware, Boolean isTemporary) {
        for (MIBreakpoint miBpt : targetBreakpoints) {
            if (!miBpt.isWatchpoint() || expression == null || !expression.equals(miBpt.getExpression()) || readAccess && writeAccess && !miBpt.isAccessWatchpoint() || readAccess && !writeAccess && !miBpt.isReadWatchpoint() || !readAccess && writeAccess && !miBpt.isWriteWatchpoint() || !this.compareBreakpointTypeAttributes(miBpt, isHardware, isTemporary)) continue;
            return miBpt;
        }
        return null;
    }

    private boolean compareBreakpointAttributes(MIBreakpoint miBpt, String fileName, Integer lineNumber, String function, String address, Boolean isHardware, Boolean isTemporary) {
        return this.compareBreakpointLocationAttributes(miBpt, fileName, lineNumber, function, address) && this.compareBreakpointTypeAttributes(miBpt, isHardware, isTemporary);
    }

    private boolean compareBreakpointLocationAttributes(MIBreakpoint miBpt, String fileName, Integer lineNumber, String function, String address) {
        if (this.isFunctionBreakpoint(miBpt) && (function == null || !function.equals(this.getFunctionName(miBpt)))) {
            return false;
        }
        if (this.isAddressBreakpoint(miBpt) && (address == null || !address.equals(this.getPlatformAddress(miBpt.getAddress()).toHexAddressString()))) {
            return false;
        }
        if (this.isLineBreakpoint(miBpt)) {
            String miBptFileName = this.getFileName(miBpt);
            if (fileName == null || miBptFileName == null || !new File(fileName).equals(new File(miBptFileName))) {
                return false;
            }
            if (lineNumber == null || lineNumber.intValue() != this.getLineNumber(miBpt)) {
                return false;
            }
        }
        return true;
    }

    private boolean compareBreakpointTypeAttributes(MIBreakpoint miBpt, Boolean isHardware, Boolean isTemporary) {
        if (isHardware == null && miBpt.isHardware() || isHardware != null && isHardware.booleanValue() != miBpt.isHardware()) {
            return false;
        }
        return (isTemporary != null || !miBpt.isTemporary()) && (isTemporary == null || isTemporary.booleanValue() == miBpt.isTemporary());
    }

    public void removeCreatedTargetBreakpoint(IBreakpoints.IBreakpointsTargetDMContext context, MIBreakpoint miBpt) {
        Map<String, MIBreakpoint> map = this.fCreatedTargetBreakpoints.get(context);
        if (map != null) {
            map.remove(miBpt.getNumber());
        }
    }

    private boolean isPlatformLineBreakpoint(ICLineBreakpoint plBpt, MIBreakpoint miBpt, String fileName) {
        block5: {
            if (plBpt instanceof ICAddressBreakpoint) {
                return this.isAddressBreakpoint(miBpt) ? this.isPlatformAddressBreakpoint((ICAddressBreakpoint)plBpt, miBpt) : false;
            }
            if (plBpt instanceof ICFunctionBreakpoint) {
                return this.isFunctionBreakpoint(miBpt) ? this.isPlatformFunctionBreakpoint((ICFunctionBreakpoint)plBpt, miBpt) : false;
            }
            try {
                if (fileName != null && plBpt.getSourceHandle() != null && new File(fileName).equals(new File(plBpt.getSourceHandle()))) break block5;
                return false;
            }
            catch (CoreException e) {
                GdbPlugin.log(e.getStatus());
                return false;
            }
        }
        return plBpt.getLineNumber() == this.getLineNumber(miBpt);
    }

    private boolean isPlatformFunctionBreakpoint(ICFunctionBreakpoint plBpt, MIBreakpoint miBpt) {
        try {
            return plBpt.getFunction() != null && plBpt.getFunction().equals(this.getFunctionName(miBpt));
        }
        catch (CoreException e) {
            GdbPlugin.log(e.getStatus());
            return false;
        }
    }

    private boolean isPlatformAddressBreakpoint(ICAddressBreakpoint plBpt, MIBreakpoint miBpt) {
        try {
            return plBpt.getAddress() != null && plBpt.getAddress().equals(this.getPlatformAddress(miBpt.getAddress()).toHexAddressString());
        }
        catch (CoreException e) {
            GdbPlugin.log(e.getStatus());
            return false;
        }
    }

    private boolean isPlatformWatchpoint(ICWatchpoint plBpt, MIBreakpoint miBpt) {
        try {
            if (plBpt.getExpression() != null && plBpt.getExpression().equals(miBpt.getExpression())) {
                if (miBpt.isAccessWatchpoint()) {
                    return plBpt.isWriteType() && plBpt.isReadType();
                }
                if (miBpt.isReadWatchpoint()) {
                    return !plBpt.isWriteType() && plBpt.isReadType();
                }
                if (miBpt.isWriteWatchpoint()) {
                    return plBpt.isWriteType() && !plBpt.isReadType();
                }
            }
        }
        catch (CoreException e) {
            GdbPlugin.log(e.getStatus());
        }
        return false;
    }

    private boolean isPlatformTracepoint(ICTracepoint plBpt, MIBreakpoint miBpt, String fileName) {
        return this.isPlatformLineBreakpoint((ICLineBreakpoint)plBpt, miBpt, fileName);
    }

    private boolean isPlatformDynamicPrintf(ICDynamicPrintf plBpt, MIBreakpoint miBpt, String fileName) {
        return this.isPlatformLineBreakpoint((ICLineBreakpoint)plBpt, miBpt, fileName);
    }

    public boolean isTargetBreakpointDeleted(IBreakpoints.IBreakpointsTargetDMContext context, String bpId, boolean remove) {
        Set<String> set = this.fDeletedTargetBreakpoints.get(context);
        if (set != null) {
            return remove ? set.remove(bpId) : set.contains(bpId);
        }
        return false;
    }

    private ITracepointAction[] getActionsFromCommands(String[] commands) {
        ArrayList<ITracepointAction> list = new ArrayList<ITracepointAction>();
        TracepointActionManager tam = TracepointActionManager.getInstance();
        WhileSteppingAction whileStepping = null;
        ArrayList<ITracepointAction> subActions = null;
        String[] stringArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            block22: {
                block17: {
                    ITracepointAction action2;
                    boolean found;
                    block19: {
                        String command;
                        block21: {
                            block20: {
                                block18: {
                                    command = stringArray[n2];
                                    found = false;
                                    for (ITracepointAction action2 : tam.getActions()) {
                                        if (!command.equals(action2.getSummary())) continue;
                                        if (whileStepping == null || subActions == null) {
                                            list.add(action2);
                                        } else {
                                            subActions.add(action2);
                                        }
                                        found = true;
                                        break;
                                    }
                                    if (found) break block17;
                                    action2 = null;
                                    if (!command.startsWith(TC_COLLECT)) break block18;
                                    action2 = this.createCollectAction(command.substring(TC_COLLECT.length()));
                                    break block19;
                                }
                                if (!command.startsWith(TC_TEVAL)) break block20;
                                action2 = this.createEvaluateAction(command.substring(TC_TEVAL.length()));
                                break block19;
                            }
                            if (!command.startsWith(TC_WHILE_STEPPING)) break block21;
                            whileStepping = this.createWhileSteppingAction(command.substring(TC_WHILE_STEPPING.length()));
                            if (whileStepping != null) {
                                subActions = new ArrayList<ITracepointAction>();
                            }
                            break block19;
                        }
                        if (!command.equals(TC_END)) break block19;
                        if (whileStepping == null || subActions == null) break block22;
                        StringBuilder sb = new StringBuilder();
                        boolean first = true;
                        for (ITracepointAction a : subActions) {
                            if (first) {
                                first = false;
                            } else {
                                sb.append(',');
                            }
                            sb.append(a.getName());
                        }
                        whileStepping.setSubActionsNames(sb.toString());
                        whileStepping.setSubActionsContent(sb.toString());
                        action2 = whileStepping;
                        for (ITracepointAction a : tam.getActions()) {
                            if (!whileStepping.getSummary().equals(a.getSummary())) continue;
                            action2 = a;
                            found = true;
                            break;
                        }
                        whileStepping = null;
                        subActions.clear();
                        subActions = null;
                    }
                    if (action2 != null) {
                        if (!found) {
                            TracepointActionManager.getInstance().addAction(action2);
                        }
                        if (whileStepping == null || subActions == null) {
                            list.add(action2);
                        } else {
                            subActions.add(action2);
                        }
                    }
                }
                TracepointActionManager.getInstance().saveActionData();
            }
            ++n2;
        }
        return list.toArray(new ITracepointAction[list.size()]);
    }

    private CollectAction createCollectAction(String collectStr) {
        CollectAction action = new CollectAction();
        action.setName(TracepointActionManager.getInstance().makeUniqueActionName(action.getDefaultName()));
        action.setCollectString(collectStr);
        return action;
    }

    private EvaluateAction createEvaluateAction(String evalStr) {
        EvaluateAction action = new EvaluateAction();
        action.setName(TracepointActionManager.getInstance().makeUniqueActionName(action.getDefaultName()));
        action.setEvalString(evalStr);
        return action;
    }

    private WhileSteppingAction createWhileSteppingAction(String str) {
        WhileSteppingAction action = new WhileSteppingAction();
        action.setName(TracepointActionManager.getInstance().makeUniqueActionName(action.getDefaultName()));
        try {
            action.setStepCount(Integer.parseInt(str.trim()));
        }
        catch (NumberFormatException e) {
            return null;
        }
        return action;
    }

    protected void getSource(IBreakpoints.IBreakpointsTargetDMContext bpTargetDMC, final String debuggerPath, final DataRequestMonitor<String> rm) {
        ISourceLookup sourceLookup = (ISourceLookup)this.getServicesTracker().getService(ISourceLookup.class);
        if (sourceLookup == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", "Source lookup service is not available"));
            rm.done();
            return;
        }
        ISourceLookup.ISourceLookupDMContext srcDmc = (ISourceLookup.ISourceLookupDMContext)DMContexts.getAncestorOfType((IDMContext)bpTargetDMC, ISourceLookup.ISourceLookupDMContext.class);
        if (srcDmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", "No source lookup context"));
            rm.done();
            return;
        }
        if (debuggerPath == null || debuggerPath.isEmpty()) {
            rm.done();
            return;
        }
        sourceLookup.getSource(srcDmc, debuggerPath, (DataRequestMonitor)new DataRequestMonitor<Object>((Executor)this.getExecutor(), rm){

            @ConfinedToDsfExecutor(value="fExecutor")
            protected void handleCompleted() {
                String fileName = null;
                if (this.isSuccess()) {
                    if (this.getData() instanceof IFile) {
                        fileName = ((IFile)this.getData()).getLocation().toOSString();
                    } else if (this.getData() instanceof File) {
                        fileName = ((File)this.getData()).getAbsolutePath();
                    } else if (this.getData() instanceof ITranslationUnit) {
                        IPath location = ((ITranslationUnit)this.getData()).getLocation();
                        if (location != null) {
                            fileName = location.toOSString();
                        }
                    } else if (this.getData() instanceof LocalFileStorage) {
                        fileName = ((LocalFileStorage)this.getData()).getFile().getAbsolutePath();
                    }
                }
                rm.setData((Object)(fileName != null && !fileName.isEmpty() ? fileName : debuggerPath));
                rm.done();
            }
        });
    }

    private boolean isFunctionBreakpoint(MIBreakpoint miBpt) {
        String origFunction = this.getFunctionFromOriginalLocation(miBpt.getOriginalLocation());
        if (miBpt.getFunction().isEmpty()) {
            return !origFunction.isEmpty();
        }
        String function = miBpt.getFunction();
        int index = function.indexOf(40);
        if (index > 0 && origFunction.indexOf(40) == -1) {
            return function.substring(0, index).equals(origFunction);
        }
        return function.equals(origFunction);
    }

    private boolean isAddressBreakpoint(MIBreakpoint miBpt) {
        return miBpt.getOriginalLocation().startsWith("*");
    }

    private boolean isLineBreakpoint(MIBreakpoint miBpt) {
        return !this.isFunctionBreakpoint(miBpt) && !this.isAddressBreakpoint(miBpt);
    }

    private IAddress getPlatformAddress(String miAddress) {
        int radix = 10;
        if (miAddress.startsWith("0x")) {
            radix = 16;
            miAddress = miAddress.substring(2);
        }
        return new Addr64(new BigInteger(miAddress, radix));
    }

    private boolean isBreakpointTargetTracked(IBreakpoints.IBreakpointsTargetDMContext btTargetDMC) {
        return this.fTrackedTargets.contains(btTargetDMC);
    }

    private String getFileName(MIBreakpoint miBpt) {
        String fileName;
        String string = fileName = miBpt.getFullName() != null && !miBpt.getFullName().isEmpty() ? miBpt.getFullName() : miBpt.getFile();
        if (fileName != null && !fileName.isEmpty()) {
            return fileName;
        }
        String origLocation = miBpt.getOriginalLocation();
        if (origLocation.isEmpty()) {
            GdbPlugin.log((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", "Invalid 'original-location' attribute"));
            return "";
        }
        if (origLocation.startsWith("*")) {
            return "";
        }
        int index = origLocation.lastIndexOf(58);
        return index > 0 ? origLocation.substring(0, index) : "";
    }

    private int getLineNumber(MIBreakpoint miBpt) {
        int lineNumber = miBpt.getLine();
        if (lineNumber != -1) {
            return lineNumber;
        }
        String origLocation = miBpt.getOriginalLocation();
        if (origLocation.isEmpty()) {
            GdbPlugin.log((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", "Invalid 'original-location' attribute"));
            return -1;
        }
        if (origLocation.startsWith("*")) {
            return -1;
        }
        int index = origLocation.lastIndexOf(58);
        if (index > 0 && origLocation.length() > index + 1) {
            try {
                return Integer.valueOf(origLocation.substring(index + 1, origLocation.length()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    private String getFunctionName(MIBreakpoint miBpt) {
        if (miBpt.getFunction() != null && !miBpt.getFunction().isEmpty()) {
            return miBpt.getFunction();
        }
        return this.getFunctionFromOriginalLocation(miBpt.getOriginalLocation());
    }

    private IResource getResource(String fileName) {
        IFile[] files;
        Object resource = null;
        resource = fileName == null || fileName.isEmpty() ? ResourcesPlugin.getWorkspace().getRoot() : ((files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(new File(fileName).toURI())).length > 0 ? files[0] : ResourcesPlugin.getWorkspace().getRoot());
        return resource;
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IExitedDMEvent e) {
        if (e.getDMContext() instanceof IBreakpoints.IBreakpointsTargetDMContext) {
            Set<String> deletedBreakpoints;
            Map<String, MIBreakpoint> modifications;
            IBreakpoints.IBreakpointsTargetDMContext bpTargetDMContext = (IBreakpoints.IBreakpointsTargetDMContext)e.getDMContext();
            Map<String, MIBreakpoint> createdBreakpoints = this.fCreatedTargetBreakpoints.remove(bpTargetDMContext);
            if (createdBreakpoints != null) {
                createdBreakpoints.clear();
            }
            if ((modifications = this.fPendingModifications.remove(bpTargetDMContext)) != null) {
                modifications.clear();
            }
            if ((deletedBreakpoints = this.fDeletedTargetBreakpoints.remove(bpTargetDMContext)) != null) {
                deletedBreakpoints.clear();
            }
        }
    }

    private String getFunctionFromOriginalLocation(String origLocation) {
        if (origLocation.isEmpty()) {
            GdbPlugin.log((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", "Invalid 'original-location' attribute"));
            return "";
        }
        if (origLocation.startsWith("*")) {
            return "";
        }
        int index = origLocation.lastIndexOf(58);
        String function = index >= 0 ? origLocation.substring(index + 1) : origLocation;
        try {
            Integer.valueOf(function);
            return "";
        }
        catch (NumberFormatException numberFormatException) {
            return function;
        }
    }

    protected boolean isCatchpoint(MIBreakpoint miBpt) {
        return miBpt.isCatchpoint() || !miBpt.isWatchpoint() && (CE_EXCEPTION_CATCH.equals(miBpt.getExpression()) || CE_EXCEPTION_THROW.equals(miBpt.getExpression()));
    }
}

