/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.cpp;

import org.eclipse.papyrusrt.codegen.CodeGenPlugin;
import org.eclipse.papyrusrt.codegen.cpp.CppCodePattern;
import org.eclipse.papyrusrt.codegen.cpp.profile.facade.RTCppGenerationProperties;
import org.eclipse.papyrusrt.codegen.cpp.rts.UMLRTRuntime;
import org.eclipse.papyrusrt.codegen.lang.cpp.Expression;
import org.eclipse.papyrusrt.codegen.lang.cpp.Type;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.CppClass;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.PrimitiveType;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.TypeBlob;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.Variable;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.ElementAccess;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.ExpressionBlob;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.IntegralLiteral;
import org.eclipse.papyrusrt.codegen.lang.cpp.external.StandardLibrary;
import org.eclipse.papyrusrt.xtumlrt.common.Attribute;
import org.eclipse.papyrusrt.xtumlrt.common.Capsule;
import org.eclipse.papyrusrt.xtumlrt.common.CommonElement;
import org.eclipse.papyrusrt.xtumlrt.common.Entity;
import org.eclipse.papyrusrt.xtumlrt.common.Enumeration;
import org.eclipse.papyrusrt.xtumlrt.common.MultiplicityElement;
import org.eclipse.papyrusrt.xtumlrt.common.Operation;
import org.eclipse.papyrusrt.xtumlrt.common.Parameter;
import org.eclipse.papyrusrt.xtumlrt.common.StructuredType;
import org.eclipse.papyrusrt.xtumlrt.common.TypedMultiplicityElement;
import org.eclipse.papyrusrt.xtumlrt.util.QualifiedNames;
import org.eclipse.papyrusrt.xtumlrt.util.UndefinedValueException;
import org.eclipse.papyrusrt.xtumlrt.util.XTUMLRTUtil;

public final class TypesUtil {
    private TypesUtil() {
    }

    public static Type createCppType(CppCodePattern cpp, org.eclipse.papyrusrt.xtumlrt.common.NamedElement element, org.eclipse.papyrusrt.xtumlrt.common.Type modelType) {
        Type type = null;
        if (modelType != null) {
            type = TypesUtil.createType(cpp, modelType);
        }
        if (element instanceof Attribute) {
            Attribute attr = (Attribute)element;
            if (RTCppGenerationProperties.getAttributeProperties((CommonElement)element) != null) {
                type = TypesUtil.applyAttributeProperties(type, attr);
            } else if (attr.isReadOnly()) {
                type = type.const_();
            }
        } else if (element instanceof Parameter) {
            if (modelType == null) {
                type = UMLRTRuntime.UMLRTObject.UMLRTTypedValue.getType();
            }
            if (RTCppGenerationProperties.getParameterProperties((CommonElement)element) != null) {
                type = TypesUtil.applyParameterProperties(type, (TypedMultiplicityElement)((Parameter)element));
            }
        } else if (element instanceof Operation && RTCppGenerationProperties.getParameterProperties((CommonElement)((Operation)element).getReturnType()) != null) {
            type = TypesUtil.applyParameterProperties(type, ((Operation)element).getReturnType());
        }
        if (type == null) {
            throw new RuntimeException("unable to create C++ type for " + QualifiedNames.fullName((org.eclipse.papyrusrt.xtumlrt.common.NamedElement)element));
        }
        type = TypesUtil.applyUpperBoundary(type, element);
        return type;
    }

    public static Expression createRTTypeAccess(CppCodePattern cpp, org.eclipse.papyrusrt.xtumlrt.common.NamedElement element, org.eclipse.papyrusrt.xtumlrt.common.Type modelType) {
        Expression rtTypeAccess = UMLRTRuntime.UMLRTObject.UMLRTType((Type)TypesUtil.createCppType(cpp, element, modelType));
        if (rtTypeAccess == null) {
            Type systemType = UMLRTRuntime.getSystemType((org.eclipse.papyrusrt.xtumlrt.common.Type)modelType);
            if (systemType != null) {
                rtTypeAccess = UMLRTRuntime.UMLRTObject.UMLRTType((Type)systemType);
                if (rtTypeAccess == null) {
                    throw new RuntimeException("attempt to serialize unsupported UMLRTS-defined type as part of " + element.getName());
                }
            } else {
                if (element instanceof Capsule) {
                    throw new RuntimeException("invalid attempt to serialize a <<Capsule>> " + element.getName());
                }
                Variable rtTypeVar = cpp.getVariable(CppCodePattern.Output.UMLRTTypeDescriptor, (org.eclipse.papyrusrt.xtumlrt.common.NamedElement)modelType);
                if (rtTypeVar == null) {
                    throw new RuntimeException("invalid attempt to serialize non-serializable type " + modelType.getName());
                }
                rtTypeAccess = new ElementAccess((NamedElement)cpp.getVariable(CppCodePattern.Output.UMLRTTypeDescriptor, (org.eclipse.papyrusrt.xtumlrt.common.NamedElement)modelType));
            }
        }
        return rtTypeAccess;
    }

    private static Type createType(CppCodePattern cpp, org.eclipse.papyrusrt.xtumlrt.common.Type modelType) {
        Type type = UMLRTRuntime.getSystemType((org.eclipse.papyrusrt.xtumlrt.common.Type)modelType);
        if (type == null) {
            type = modelType instanceof org.eclipse.papyrusrt.xtumlrt.common.PrimitiveType ? TypesUtil.createType((org.eclipse.papyrusrt.xtumlrt.common.PrimitiveType)modelType) : (modelType instanceof Entity ? TypesUtil.createType(cpp, (Entity)modelType) : (modelType instanceof StructuredType ? TypesUtil.createType(cpp, (StructuredType)modelType) : (modelType instanceof Enumeration ? TypesUtil.createType(cpp, (Enumeration)modelType) : PrimitiveType.VOID.ptr())));
        }
        return type;
    }

    private static Type createType(CppCodePattern cpp, StructuredType type) {
        CppClass cls = cpp.getCppClass(CppCodePattern.Output.BasicClass, (org.eclipse.papyrusrt.xtumlrt.common.NamedElement)type);
        cls.setKind(CppClass.Kind.STRUCT);
        return cls.getType();
    }

    private static Type createType(CppCodePattern cpp, Entity cls) {
        return cpp.getCppClass(CppCodePattern.Output.BasicClass, (org.eclipse.papyrusrt.xtumlrt.common.NamedElement)cls).getType();
    }

    private static Type createType(CppCodePattern cpp, Enumeration element) {
        return cpp.getCppEnum(CppCodePattern.Output.UserEnum, (org.eclipse.papyrusrt.xtumlrt.common.NamedElement)element).getType();
    }

    private static Type createBuiltInType(String name) {
        PrimitiveType newType = null;
        if ("char".equals(name)) {
            newType = PrimitiveType.CHAR;
        } else if ("double".equals(name)) {
            newType = PrimitiveType.DOUBLE;
        } else if ("float".equals(name)) {
            newType = PrimitiveType.FLOAT;
        } else if ("int".equals(name)) {
            newType = PrimitiveType.INT;
        } else if ("void".equals(name)) {
            newType = PrimitiveType.VOID;
        } else if ("long".equals(name)) {
            newType = PrimitiveType.LONG;
        } else if ("long double".equals(name)) {
            newType = PrimitiveType.LONGDOUBLE;
        } else if ("short".equals(name)) {
            newType = PrimitiveType.SHORT;
        } else if ("unsigned int".equals(name)) {
            newType = PrimitiveType.UINT;
        } else if ("unsigned short".equals(name)) {
            newType = PrimitiveType.USHORT;
        } else if ("unsigned char".equals(name)) {
            newType = PrimitiveType.UCHAR;
        } else if ("unsigned long".equals(name)) {
            newType = PrimitiveType.ULONG;
        } else if ("bool".equals(name)) {
            newType = PrimitiveType.BOOL;
        }
        return newType;
    }

    private static Type createUMLType(String name) {
        PrimitiveType newType = null;
        if ("Boolean".equals(name)) {
            newType = PrimitiveType.BOOL;
        } else if ("Integer".equals(name)) {
            newType = PrimitiveType.INT;
        } else if ("Real".equals(name)) {
            newType = PrimitiveType.DOUBLE;
        } else if ("String".equals(name)) {
            newType = PrimitiveType.CHAR.ptr();
        } else if ("UnlimitedNatural".equals(name)) {
            newType = PrimitiveType.ULONGLONG;
        }
        return newType;
    }

    private static Type createAnsiCLibraryType(String name) {
        Type newType = null;
        if ("int8_t".equals(name)) {
            newType = StandardLibrary.int8_t;
        } else if ("int16_t".equals(name)) {
            newType = StandardLibrary.int16_t;
        } else if ("int32_t".equals(name)) {
            newType = StandardLibrary.int32_t;
        } else if ("int64_t".equals(name)) {
            newType = StandardLibrary.int64_t;
        } else if ("uint8_t".equals(name)) {
            newType = StandardLibrary.uint8_t;
        } else if ("uint16_t".equals(name)) {
            newType = StandardLibrary.uint16_t;
        } else if ("uint32_t".equals(name)) {
            newType = StandardLibrary.uint32_t;
        } else if ("uint64_t".equals(name)) {
            newType = StandardLibrary.uint64_t;
        } else if ("wchar_t".equals(name)) {
            newType = StandardLibrary.wchar_t;
        }
        return newType;
    }

    private static Type createType(org.eclipse.papyrusrt.xtumlrt.common.PrimitiveType xtumlrtType) {
        String name = xtumlrtType.getName();
        Type type = TypesUtil.createBuiltInType(name);
        if (type == null && (type = TypesUtil.createUMLType(name)) == null && (type = TypesUtil.createAnsiCLibraryType(name)) == null) {
            type = PrimitiveType.VOID.ptr();
        }
        return type;
    }

    private static Type applyUpperBoundary(Type type, org.eclipse.papyrusrt.xtumlrt.common.NamedElement element) {
        Type newType = type;
        TypedMultiplicityElement typedMultElement = null;
        if (element instanceof Operation) {
            typedMultElement = ((Operation)element).getReturnType();
            try {
                int bound = XTUMLRTUtil.getBound((MultiplicityElement)typedMultElement);
                if (bound > 1) {
                    newType = newType.ptr();
                }
            }
            catch (UndefinedValueException undefinedValueException) {
                newType = newType.ptr();
            }
        } else if (element instanceof Parameter || element instanceof Attribute) {
            typedMultElement = (TypedMultiplicityElement)element;
            try {
                int bound = XTUMLRTUtil.getBound((MultiplicityElement)typedMultElement);
                if (bound > 1) {
                    newType = newType.arrayOf((Expression)new IntegralLiteral(bound));
                }
            }
            catch (UndefinedValueException e) {
                newType = newType.arrayOf((Expression)new ExpressionBlob(e.getExpression()));
            }
        }
        return newType;
    }

    private static Type applyAttributeProperties(Type type, Attribute element) {
        boolean isPointer;
        Type newType = type;
        String typeStr = RTCppGenerationProperties.getAttributePropType((CommonElement)element);
        if (typeStr != null && !typeStr.trim().isEmpty()) {
            newType = new TypeBlob(typeStr);
        } else if (newType == null) {
            CodeGenPlugin.error((String)(" Attribute '" + QualifiedNames.cachedFullName((org.eclipse.papyrusrt.xtumlrt.common.NamedElement)element) + "' has no type"));
        }
        Boolean isVolatileBool = RTCppGenerationProperties.getAttributePropVolatile((CommonElement)element);
        Boolean pointsToBool = RTCppGenerationProperties.getAttributePropPointsTo((CommonElement)element);
        Boolean pointsToConstBool = RTCppGenerationProperties.getAttributePropPointsToConst((CommonElement)element);
        Boolean pointsToVolatileBool = RTCppGenerationProperties.getAttributePropPointsToVolatile((CommonElement)element);
        boolean isConst = element.isReadOnly();
        boolean isVolatile = isVolatileBool != null && isVolatileBool != false;
        boolean pointsTo = pointsToBool != null && pointsToBool != false;
        boolean pointsToConst = pointsToConstBool != null && pointsToConstBool != false;
        boolean pointsToVolatile = pointsToVolatileBool != null && pointsToVolatileBool != false;
        boolean bl = isPointer = pointsTo || pointsToConst || pointsToVolatile;
        if (pointsToConst) {
            newType = pointsToVolatile ? newType.constVolatile() : newType.const_();
        } else if (pointsToVolatile) {
            newType = newType.volatile_();
        }
        if (isPointer && !isConst && !isVolatile) {
            newType = newType.ptr();
        }
        if (isConst) {
            newType = isVolatile ? (isPointer ? newType.constVolatilePtr() : newType.constVolatile()) : (isPointer ? newType.constPtr() : newType.const_());
        } else if (isVolatile) {
            newType = isPointer ? newType.volatilePtr() : newType.volatile_();
        }
        return newType;
    }

    private static Type applyParameterProperties(Type type, TypedMultiplicityElement element) {
        boolean isPointer;
        Type newType = type;
        String typeStr = RTCppGenerationProperties.getParameterPropType((CommonElement)element);
        if (typeStr != null && !typeStr.trim().equals("")) {
            newType = new TypeBlob(typeStr);
        } else if (newType == null) {
            if (element instanceof TypedMultiplicityElement) {
                CodeGenPlugin.error((String)(" No return type for operation '" + QualifiedNames.cachedFullName((org.eclipse.papyrusrt.xtumlrt.common.NamedElement)((Operation)element.eContainer())) + "'"));
            } else {
                CodeGenPlugin.error((String)(" Parameter '" + QualifiedNames.cachedFullName((org.eclipse.papyrusrt.xtumlrt.common.NamedElement)((Parameter)element)) + "' has no type"));
            }
        }
        Boolean pointsToBool = RTCppGenerationProperties.getParameterPropPointsTo((CommonElement)element);
        Boolean pointsToConstBool = RTCppGenerationProperties.getParameterPropPointsToConst((CommonElement)element);
        Boolean pointsToVolatileBool = RTCppGenerationProperties.getParameterPropPointsToVolatile((CommonElement)element);
        boolean pointsTo = pointsToBool != null && pointsToBool != false;
        boolean pointsToConst = pointsToConstBool != null && pointsToConstBool != false;
        boolean pointsToVolatile = pointsToVolatileBool != null && pointsToVolatileBool != false;
        boolean bl = isPointer = pointsTo || pointsToConst || pointsToVolatile;
        if (pointsToConst) {
            newType = pointsToVolatile ? newType.constVolatile() : newType.const_();
        } else if (pointsToVolatile) {
            newType = newType.volatile_();
        }
        if (isPointer) {
            newType = newType.ptr();
        }
        return newType;
    }
}

