/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.properties.editors;

import java.util.Collection;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.editors.AbstractListEditor;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;
import org.eclipse.papyrus.uml.diagram.common.util.CommandUtil;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.papyrusrt.umlrt.core.utils.EMFHacks;
import org.eclipse.papyrusrt.umlrt.tooling.properties.Activator;
import org.eclipse.papyrusrt.umlrt.tooling.properties.messages.Messages;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.uml2.common.util.UML2Util;

public class MultiReferenceControlEditor
extends AbstractListEditor
implements SelectionListener,
DisposeListener {
    protected static final String DELETE_BUTTON_ICON = "/icons/Delete_12x12.gif";
    protected static final String ADD_BUTTON_ICON = "/icons/Add_12x12.gif";
    protected static final String EDIT_BUTTON_ICON = "/icons/Edit_12x12.gif";
    protected static final String DOWN_BUTTON_ICON = "/icons/Down_12x12.gif";
    protected static final String UP_BUTTON_ICON = "/icons/Up_12x12.gif";
    protected IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)UMLElementTypes.TRANSITION);
    protected Composite controlsSection;
    protected Button add;
    protected Button edit;
    protected Button remove;
    protected Button up;
    protected Button down;
    protected Object selectedElement;
    protected List selectedElements;
    protected EObject context;
    protected EReference containementFeature;
    protected String createElementTypeId;
    protected Consumer<? super Object> newElementAction = __ -> {};
    protected BiConsumer<? super Object, ? super Integer> movedElementAction = (_1, _2) -> {};
    protected ReferenceValueFactory referenceFactory;

    public MultiReferenceControlEditor(Composite parent, int style, EObject context, EStructuralFeature containment, INattableModelManager nattableManager) {
        super(parent, style);
        this.context = context;
        this.containementFeature = (EReference)containment;
        GridLayout layout = new GridLayout(this.label == null ? 1 : 2, false);
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.createControlSelection();
        this.createControlButtons();
        this.updateButtons();
    }

    protected void createControlSelection() {
        this.controlsSection = new Composite((Composite)this, 0);
        this.controlsSection.setLayout((Layout)new FillLayout());
        this.controlsSection.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
    }

    protected void createControlButtons() {
        this.up = this.createButton(Activator.getDefault().getImage(UP_BUTTON_ICON), Messages.MultiReferenceControlEditor_MoveUpButtonLabel);
        this.down = this.createButton(Activator.getDefault().getImage(DOWN_BUTTON_ICON), Messages.MultiReferenceControlEditor_MoveDownButtonLabel);
        this.add = this.createButton(Activator.getDefault().getImage(ADD_BUTTON_ICON), Messages.MultiReferenceControlEditor_AddButtonLabel);
        this.remove = this.createButton(Activator.getDefault().getImage(DELETE_BUTTON_ICON), Messages.MultiReferenceControlEditor_RemoveButtonLabel);
        this.edit = this.createButton(Activator.getDefault().getImage(EDIT_BUTTON_ICON), Messages.MultiReferenceControlEditor_EditButtonLabel);
    }

    protected Button createButton(Image image, String toolTipText) {
        Button button = new Button(this.controlsSection, 8);
        button.setImage(image);
        button.addSelectionListener((SelectionListener)this);
        button.setToolTipText(toolTipText);
        return button;
    }

    public void setModelObservable(IObservableList modelProperty) {
        super.setModelObservable(modelProperty);
        if (modelProperty instanceof ICommitListener) {
            this.addCommitListener((ICommitListener)modelProperty);
        }
    }

    public void setFactory(ReferenceValueFactory factory) {
        this.referenceFactory = factory;
        this.updateButtons();
    }

    public Object getEditableType() {
        return Collection.class;
    }

    public void setReadOnly(boolean readOnly) {
    }

    public boolean isReadOnly() {
        return false;
    }

    public void widgetDisposed(DisposeEvent e) {
        super.widgetDisposed(e);
        this.add.dispose();
        this.up.dispose();
        this.remove.dispose();
        this.down.dispose();
        this.edit.dispose();
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.add == e.widget) {
            this.addAction();
        }
        if (this.getSelectedElements() != null) {
            for (Object element : this.getSelectedElements()) {
                this.setSelectedElement(element);
                if (e.widget == null) continue;
                if (this.remove == e.widget) {
                    this.removeAction();
                    continue;
                }
                if (this.up == e.widget) {
                    this.upAction();
                    continue;
                }
                if (this.down == e.widget) {
                    this.downAction();
                    continue;
                }
                if (this.edit != e.widget) continue;
                this.editAction();
            }
        }
        this.updateButtons();
    }

    protected void downAction() {
        Command move;
        int indexOf = this.modelProperty.indexOf(this.selectedElement);
        EditingDomain domain = EMFHelper.resolveEditingDomain((EObject)this.context);
        if (domain != null && indexOf + 1 < this.modelProperty.size() && (move = MoveCommand.create((EditingDomain)domain, (Object)this.context, (Object)this.containementFeature, (Object)this.selectedElement, (int)(indexOf + 1))) != null) {
            move = new CommandWrapper(Messages.MultiReferenceControlEditor_MoveDownAction, Messages.MultiReferenceControlEditor_MoveDownAction, move);
            CommandUtil.executeCommandInStack((Command)move, (Object)this.context);
            this.movedElementAction.accept(this.selectedElement, (Integer)indexOf);
        }
    }

    protected void upAction() {
        Command move;
        int indexOf = this.modelProperty.indexOf(this.selectedElement);
        EditingDomain domain = EMFHelper.resolveEditingDomain((EObject)this.context);
        if (domain != null && indexOf - 1 >= 0 && (move = MoveCommand.create((EditingDomain)domain, (Object)this.context, (Object)this.containementFeature, (Object)this.selectedElement, (int)(indexOf - 1))) != null) {
            move = new CommandWrapper(Messages.MultiReferenceControlEditor_MoveUpAction, Messages.MultiReferenceControlEditor_MoveUpAction, move);
            CommandUtil.executeCommandInStack((Command)move, (Object)this.context);
            this.movedElementAction.accept(this.selectedElement, (Integer)indexOf);
        }
    }

    protected void removeAction() {
        ICommand setCommand;
        DestroyElementRequest request = new DestroyElementRequest((EObject)this.selectedElement, false);
        if (this.getProvider() != null && (setCommand = this.getProvider().getEditCommand((IEditCommandRequest)request)) != null) {
            setCommand.setLabel(NLS.bind((String)Messages.MultiReferenceControlEditor_RemoveAction, (Object)this.containementFeature.getEType().getName()));
            Command wrapperCommand = GMFtoEMFCommandWrapper.wrap((ICommand)setCommand);
            CommandUtil.executeCommandInStack((Command)wrapperCommand, (Object)this.context);
        }
    }

    public void setCreateElementTypeID(String id) {
        this.createElementTypeId = id;
    }

    protected void addAction() {
        ICommand createCommand;
        if (UML2Util.isEmpty((String)this.createElementTypeId)) {
            if (this.referenceFactory != null && this.referenceFactory.canCreateObject()) {
                this.getOperationExecutor(this.context).execute(new Runnable(){

                    @Override
                    public void run() {
                        Object newElement = MultiReferenceControlEditor.this.referenceFactory.createObject((Control)MultiReferenceControlEditor.this, (Object)MultiReferenceControlEditor.this.context);
                        if (newElement != null) {
                            MultiReferenceControlEditor.this.modelProperty.add(newElement);
                            MultiReferenceControlEditor.this.commit();
                            MultiReferenceControlEditor.this.newElementAction.accept(newElement);
                        }
                    }
                }, NLS.bind((String)Messages.MultiReferenceControlEditor_AddAction, (Object)this.containementFeature.getEType().getName()));
            }
            return;
        }
        CreateElementRequest request = new CreateElementRequest(this.context, ElementTypeRegistry.getInstance().getType(this.createElementTypeId), this.containementFeature);
        if (this.getContextCommandProvider() != null && (createCommand = this.getContextCommandProvider().getEditCommand((IEditCommandRequest)request)) != null) {
            createCommand.setLabel(NLS.bind((String)Messages.MultiReferenceControlEditor_AddAction, (Object)this.containementFeature.getEType().getName()));
            Command wrapperCommand = GMFtoEMFCommandWrapper.wrap((ICommand)createCommand);
            boolean nested = EMFHacks.isReadWriteTransactionActive((EObject)this.context);
            if (nested) {
                EMFHacks.silently((Notifier)this.context, op -> CommandUtil.executeCommandInStack((Command)wrapperCommand, (Object)this.context));
            } else {
                CommandUtil.executeCommandInStack((Command)wrapperCommand, (Object)this.context);
            }
            CommandResult result = createCommand.getCommandResult();
            if (result.getStatus().isOK()) {
                EObject added = (EObject)result.getReturnValue();
                if (nested) {
                    EMFHacks.notifyAdded((EObject)added);
                }
                this.newElementAction.accept(added);
            }
        }
    }

    protected void editAction() {
        this.getOperationExecutor(this.selectedElement).execute(new Runnable(){

            @Override
            public void run() {
                int indexOf = MultiReferenceControlEditor.this.modelProperty.indexOf(MultiReferenceControlEditor.this.selectedElement);
                Object newValue = MultiReferenceControlEditor.this.referenceFactory.edit((Control)MultiReferenceControlEditor.this.edit, MultiReferenceControlEditor.this.selectedElement);
                if (newValue != MultiReferenceControlEditor.this.selectedElement && newValue != null) {
                    MultiReferenceControlEditor.this.modelProperty.remove(indexOf);
                    MultiReferenceControlEditor.this.modelProperty.add(indexOf, newValue);
                }
                MultiReferenceControlEditor.this.commit();
            }
        }, NLS.bind((String)Messages.MultiReferenceControlEditor_EditAction, (Object)this.containementFeature.getEType().getName()));
    }

    protected IElementEditService getElementCommandProvider() {
        IElementEditService commandProvider = ElementEditServiceUtils.getCommandProvider((Object)this.context);
        return commandProvider;
    }

    public void updateButtons() {
        if (this.selectedElements == null || this.selectedElements.isEmpty()) {
            this.remove.setEnabled(false);
            this.up.setEnabled(false);
            this.down.setEnabled(false);
            this.edit.setEnabled(false);
        } else {
            this.remove.setEnabled(true);
            this.edit.setEnabled(true);
            OptionalInt minSelectionIndex = this.selectedElements.stream().mapToInt(this::indexOf).min();
            OptionalInt maxSelectionIndex = this.selectedElements.stream().mapToInt(this::indexOf).max();
            this.up.setEnabled(minSelectionIndex.orElse(-1) > 0);
            this.down.setEnabled(maxSelectionIndex.orElse(Integer.MAX_VALUE) < this.modelProperty.size() - 1);
        }
        this.add.setEnabled(true);
    }

    protected int indexOf(Object element) {
        return this.modelProperty.indexOf(element);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void setSelectedElement(Object selectedElement) {
        this.selectedElement = selectedElement;
    }

    public void setSelectedElements(List selectedElementList) {
        this.selectedElements = selectedElementList;
    }

    public IElementEditService getProvider() {
        return this.provider;
    }

    public void setProvider(IElementEditService provider) {
        this.provider = provider;
    }

    protected IElementEditService getContextCommandProvider() {
        IElementEditService commandProvider = ElementEditServiceUtils.getCommandProvider((Object)this.context);
        return commandProvider;
    }

    public List getSelectedElements() {
        return this.selectedElements;
    }

    public void onElementAdded(Consumer<? super Object> newElementAction) {
        this.newElementAction = newElementAction != null ? newElementAction : __ -> {};
    }

    public void onElementMoved(BiConsumer<? super Object, ? super Integer> movedElementAction) {
        this.movedElementAction = movedElementAction != null ? movedElementAction : (_1, _2) -> {};
    }
}

