/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.properties.widget;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.hideshow.RowHideShowLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.command.MoveSelectionCommand;
import org.eclipse.papyrus.infra.emf.nattable.selection.EObjectSelectionExtractor;
import org.eclipse.papyrus.infra.nattable.layerstack.BodyLayerStack;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.provider.TableSelectionProvider;
import org.eclipse.papyrus.infra.nattable.provider.TableStructuredSelection;
import org.eclipse.papyrus.infra.nattable.selection.ISelectionExtractor;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.NattableModelManagerFactory;
import org.eclipse.papyrus.infra.nattable.utils.TableSelectionWrapper;
import org.eclipse.papyrusrt.umlrt.tooling.properties.editors.MultiReferenceControlEditor;
import org.eclipse.papyrusrt.umlrt.tooling.properties.widget.RTNatTablePropertyEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class RTNatTableMultiReferencePropertyEditor
extends RTNatTablePropertyEditor
implements ISelectionChangedListener {
    private static final int ROW_HEIGHT = 40;
    private TableSelectionProvider selectionProvider;
    private DisposeListener nattableDisposeListener = null;
    private MultiReferenceControlEditor editor;
    protected int style;
    protected String createElementTypeId;

    public String getCreateElementTypeID() {
        return this.createElementTypeId;
    }

    public void setCreateElementTypeID(String createElementTypeId) {
        this.createElementTypeId = createElementTypeId;
        if (this.editor != null) {
            this.editor.setCreateElementTypeID(createElementTypeId);
        }
    }

    public RTNatTableMultiReferencePropertyEditor(Composite parent, int style) {
        super(parent, style);
        this.style = style;
    }

    protected void createPreviousWidgets(EObject sourceElement, EStructuralFeature feature) {
        super.createPreviousWidgets(sourceElement, feature);
        this.disposeControlEditor();
        this.editor = this.createControlEditor(sourceElement, feature);
        this.setEditor(this.editor);
    }

    @Override
    protected NatTable createNatTableWidget(INattableModelManager manager, Composite parent, int style, Collection<?> rows) {
        NatTable result = super.createNatTableWidget(manager, parent, style, rows);
        this.setSelectionProvider();
        return result;
    }

    protected MultiReferenceControlEditor createControlEditor(EObject sourceElement, EStructuralFeature feature) {
        MultiReferenceControlEditor editor = new MultiReferenceControlEditor((Composite)this.self, this.style, sourceElement, feature, this.nattableManager);
        editor.setModelObservable(this.getInputObservableList());
        editor.setFactory(this.input.getValueFactory(this.propertyPath));
        editor.setCreateElementTypeID(this.createElementTypeId);
        editor.onElementMoved(this::refreshTable);
        return editor;
    }

    protected void configureLayout(EObject sourceElement) {
        GridData data = new GridData(4, 4, true, true);
        data.horizontalIndent = 0;
        this.setLayoutData(data);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.self.setLayout((Layout)layout);
        GridData editorData = new GridData(131072, 128, false, false);
        editorData.horizontalIndent = 0;
        this.editor.setLayoutData(editorData);
        GridData tableData = new GridData(4, 4, true, true);
        tableData.minimumHeight = this.getInputObservableList().size() * 40;
        tableData.horizontalIndent = 0;
        this.natTableWidget.setLayoutData((Object)tableData);
        this.self.layout();
        this.editor.layout();
        super.configureLayout(sourceElement);
    }

    protected void setSelectionProvider() {
        this.selectionProvider = new TableSelectionProvider(this.nattableManager, this.nattableManager.getBodyLayerStack().getSelectionLayer());
        this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    protected void disposeControlEditor() {
        if (this.editor != null) {
            this.editor.dispose();
        }
    }

    public INattableModelManager getTableManager(Table table) {
        return NattableModelManagerFactory.INSTANCE.createNatTableModelManager(table, (ISelectionExtractor)new EObjectSelectionExtractor());
    }

    protected DisposeListener getDisposeListener() {
        if (this.nattableDisposeListener == null) {
            this.nattableDisposeListener = new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    RTNatTableMultiReferencePropertyEditor.this.nattableManager.dispose();
                    RTNatTableMultiReferencePropertyEditor.this.natTableWidget.dispose();
                    RTNatTableMultiReferencePropertyEditor.this.disposeControlEditor();
                }
            };
        }
        return this.nattableDisposeListener;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ArrayList<Object> elements = new ArrayList<Object>(1);
        TableStructuredSelection selection = (TableStructuredSelection)event.getSelection();
        TableSelectionWrapper wrapper = (TableSelectionWrapper)selection.getAdapter(TableSelectionWrapper.class);
        Collection selectedCells = wrapper.getSelectedCells();
        int rowPosition = 0;
        for (PositionCoordinate coordinate : selectedCells) {
            rowPosition = coordinate.getRowPosition();
            RowHideShowLayer rowHideShowLayer = this.nattableManager.getBodyLayerStack().getRowHideShowLayer();
            int realRowIndex = rowHideShowLayer.getRowIndexByPosition(rowPosition);
            Object rowElement = AxisUtils.getRepresentedElement((Object)this.nattableManager.getRowElement(realRowIndex));
            if (elements.contains(rowElement)) continue;
            elements.add(rowElement);
        }
        this.editor.setSelectedElements(elements);
        this.editor.updateButtons();
    }

    protected void refreshTable(Object element, int oldIndex) {
        this.natTableWidget.getDisplay().asyncExec(() -> {
            int index;
            BodyLayerStack stack = this.nattableManager.getBodyLayerStack();
            SelectionLayer selectionLayer = stack.getSelectionLayer();
            int selectionIndex = selectionLayer.getRowPositionByIndex(index = this.getInputObservableList().indexOf(element));
            if (selectionIndex >= 0) {
                int step = index - oldIndex;
                MoveSelectionCommand follow = new MoveSelectionCommand(step > 0 ? SelectionLayer.MoveDirectionEnum.DOWN : SelectionLayer.MoveDirectionEnum.UP, Integer.valueOf(Math.abs(step)), false, false);
                this.natTableWidget.doCommand((ILayerCommand)follow);
            }
        });
    }
}

