/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search.dependencies;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Stack;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.search.PluginJavaSearchUtil;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageObject;
import org.eclipse.pde.internal.core.text.bundle.PackageObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;

public class GatherUnusedDependenciesOperation
implements IRunnableWithProgress {
    private IPluginModelBase fModel;
    private ArrayList<Object> fList;

    public GatherUnusedDependenciesOperation(IPluginModelBase model) {
        this.fModel = model;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        ImportPackageObject[] packages = null;
        Vector exportedPackages = null;
        if (ClasspathUtilCore.hasBundleStructure((IPluginModelBase)this.fModel)) {
            IBundle bundle = ((IBundlePluginModelBase)this.fModel).getBundleModel().getBundle();
            IManifestHeader header = bundle.getManifestHeader("Import-Package");
            if (header instanceof ImportPackageHeader) {
                packages = ((ImportPackageHeader)header).getPackages();
            } else if (header != null && header.getValue() != null) {
                header = new ImportPackageHeader("Import-Package", header.getValue(), bundle, System.getProperty("line.separator"));
                packages = ((ImportPackageHeader)header).getPackages();
            }
            header = bundle.getManifestHeader("Export-Package");
            if (header instanceof ExportPackageHeader) {
                exportedPackages = ((ExportPackageHeader)header).getPackageNames();
            } else if (header != null && header.getValue() != null) {
                header = new ExportPackageHeader("Export-Package", header.getValue(), bundle, System.getProperty("line.seperator"));
                exportedPackages = ((ExportPackageHeader)header).getPackageNames();
            }
        }
        IPluginImport[] imports = this.fModel.getPluginBase().getImports();
        int totalWork = imports.length * 3 + (packages != null ? packages.length : 0) + 1;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)totalWork);
        HashMap<String, IPluginImport> usedPlugins = new HashMap<String, IPluginImport>();
        this.fList = new ArrayList();
        int i = 0;
        while (i < imports.length) {
            if (subMonitor.isCanceled()) break;
            if (this.isUnused(imports[i], (IProgressMonitor)subMonitor.split(3))) {
                this.fList.add(imports[i]);
            } else {
                usedPlugins.put(imports[i].getId(), imports[i]);
            }
            this.updateMonitor((IProgressMonitor)subMonitor, this.fList.size());
            ++i;
        }
        ArrayList<ImportPackageObject> usedPackages = new ArrayList<ImportPackageObject>();
        if (packages != null && !subMonitor.isCanceled()) {
            int i2 = 0;
            while (i2 < packages.length) {
                if (subMonitor.isCanceled()) break;
                if (this.isUnused(packages[i2], exportedPackages, (IProgressMonitor)subMonitor.split(1))) {
                    this.fList.add(packages[i2]);
                    this.updateMonitor((IProgressMonitor)subMonitor, this.fList.size());
                } else {
                    usedPackages.add(packages[i2]);
                }
                ++i2;
            }
        }
        if (!subMonitor.isCanceled()) {
            this.minimizeDependencies(usedPlugins, usedPackages, (IProgressMonitor)subMonitor);
        }
    }

    private void updateMonitor(IProgressMonitor monitor, int size) {
        monitor.setTaskName(String.valueOf(PDEUIMessages.UnusedDependencies_analyze) + size + " " + PDEUIMessages.UnusedDependencies_unused + " " + (size == 1 ? PDEUIMessages.DependencyExtent_singular : PDEUIMessages.DependencyExtent_plural) + " " + PDEUIMessages.DependencyExtent_found);
    }

    private boolean isUnused(IPluginImport plugin, IProgressMonitor monitor) {
        IPluginModelBase[] models = PluginJavaSearchUtil.getPluginImports((IPluginImport)plugin);
        return !this.provideJavaClasses(models, monitor);
    }

    private boolean isUnused(ImportPackageObject pkg, Collection<?> exportedPackages, IProgressMonitor monitor) {
        if (exportedPackages != null && exportedPackages.contains(pkg.getValue())) {
            return false;
        }
        return !this.provideJavaClasses(pkg, monitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean provideJavaClasses(IPluginModelBase[] models, IProgressMonitor monitor) {
        try {
            IProject project = this.fModel.getUnderlyingResource().getProject();
            if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
                return false;
            }
            IJavaProject jProject = JavaCore.create((IProject)project);
            IPackageFragment[] packageFragments = PluginJavaSearchUtil.collectPackageFragments((IPluginModelBase[])models, (IJavaProject)jProject, (boolean)true);
            SearchEngine engine = new SearchEngine();
            IJavaSearchScope searchScope = PluginJavaSearchUtil.createSeachScope((IJavaProject)jProject);
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(packageFragments.length * 2));
            int i = 0;
            while (true) {
                if (i >= packageFragments.length) {
                    return false;
                }
                SubMonitor iterationMonitor = subMonitor.split(2);
                IPackageFragment pkgFragment = packageFragments[i];
                if (pkgFragment.hasChildren()) {
                    Requestor requestor = new Requestor();
                    engine.search(SearchPattern.createPattern((IJavaElement)pkgFragment, (int)2), new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, searchScope, (SearchRequestor)requestor, (IProgressMonitor)iterationMonitor.split(1));
                    if (requestor.foundMatches() && this.provideJavaClasses(packageFragments[i], engine, searchScope, (IProgressMonitor)iterationMonitor.split(1))) {
                        return true;
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        return false;
    }

    private boolean provideJavaClasses(IPackageFragment packageFragment, SearchEngine engine, IJavaSearchScope searchScope, IProgressMonitor monitor) throws JavaModelException, CoreException {
        IJavaElement[] children = packageFragment.getChildren();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)children.length);
        int j = 0;
        while (j < children.length) {
            IType[] types = null;
            if (children[j] instanceof ICompilationUnit) {
                types = ((ICompilationUnit)children[j]).getAllTypes();
            } else if (children[j] instanceof IClassFile) {
                types = new IType[]{((IClassFile)children[j]).getType()};
            }
            if (types != null) {
                SubMonitor iterationMonitor = subMonitor.split(1).setWorkRemaining(types.length);
                int t = 0;
                while (t < types.length) {
                    Requestor requestor = new Requestor();
                    engine.search(SearchPattern.createPattern((IJavaElement)types[t], (int)2), new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, searchScope, (SearchRequestor)requestor, (IProgressMonitor)iterationMonitor.split(1));
                    if (requestor.foundMatches()) {
                        return true;
                    }
                    ++t;
                }
            } else {
                subMonitor.worked(1);
            }
            ++j;
        }
        return false;
    }

    private boolean provideJavaClasses(ImportPackageObject pkg, IProgressMonitor monitor) {
        IProject project;
        block4: {
            project = this.fModel.getUnderlyingResource().getProject();
            if (project.hasNature("org.eclipse.jdt.core.javanature")) break block4;
            return false;
        }
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
            IJavaProject jProject = JavaCore.create((IProject)project);
            SearchEngine engine = new SearchEngine();
            IJavaSearchScope searchScope = PluginJavaSearchUtil.createSeachScope((IJavaProject)jProject);
            Requestor requestor = new Requestor();
            String packageName = pkg.getName();
            engine.search(SearchPattern.createPattern((String)packageName, (int)2, (int)2, (int)0), new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, searchScope, (SearchRequestor)requestor, (IProgressMonitor)subMonitor.split(1));
            if (requestor.foundMatches()) {
                return true;
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        return false;
    }

    public ArrayList<Object> getList() {
        return this.fList;
    }

    public static void removeDependencies(IPluginModelBase model, Object[] elements) {
        ImportPackageHeader pkgHeader = null;
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof IPluginImport) {
                try {
                    model.getPluginBase().remove((IPluginImport)elements[i]);
                }
                catch (CoreException coreException) {}
            } else if (elements[i] instanceof ImportPackageObject) {
                if (pkgHeader == null) {
                    pkgHeader = (ImportPackageHeader)((ImportPackageObject)elements[i]).getHeader();
                }
                pkgHeader.removePackage((PackageObject)((ImportPackageObject)elements[i]));
            }
            ++i;
        }
    }

    private void minimizeDependencies(HashMap<String, IPluginImport> usedPlugins, ArrayList<ImportPackageObject> usedPackages, IProgressMonitor monitor) {
        ListIterator<ImportPackageObject> li = usedPackages.listIterator();
        while (li.hasNext()) {
            ImportPackageObject ipo = li.next();
            String bundle = ipo.getAttribute("bundle-symbolic-name");
            if (!usedPlugins.containsKey(bundle)) continue;
            this.fList.add(ipo);
        }
        Iterator<String> it = usedPlugins.keySet().iterator();
        Stack<String> plugins = new Stack<String>();
        while (it.hasNext()) {
            plugins.push(it.next().toString());
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        while (!plugins.isEmpty()) {
            String pluginId = (String)plugins.pop();
            IPluginModelBase base = PluginRegistry.findModel((String)pluginId);
            if (base == null) continue;
            IPluginImport[] imports = base.getPluginBase().getImports();
            SubMonitor iterationMonitor = subMonitor.setWorkRemaining(Math.max(plugins.size() + 1, 5)).split(1).setWorkRemaining(imports.length);
            int j = 0;
            while (j < imports.length) {
                if (imports[j].isReexported()) {
                    String reExportedId = imports[j].getId();
                    IPluginImport pluginImport = usedPlugins.remove(imports[j].getId());
                    if (pluginImport != null) {
                        this.fList.add(pluginImport);
                        this.updateMonitor((IProgressMonitor)iterationMonitor, this.fList.size());
                    }
                    plugins.push(reExportedId);
                }
                iterationMonitor.worked(1);
                ++j;
            }
        }
    }

    class Requestor
    extends SearchRequestor {
        boolean fFound = false;

        Requestor() {
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            this.fFound = true;
        }

        public boolean foundMatches() {
            return this.fFound;
        }
    }
}

