/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.catalog;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogElement;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.IDelegateCatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.INextCatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.IRewriteEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ISuffixEntry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class CatalogWriter {
    private Document doc;

    /*
     * Exception decompiling
     */
    public void write(ICatalog xmlCatalog, String uri) throws FileNotFoundException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 41->45)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void write(ICatalog catalog, OutputStream os) throws FileNotFoundException, IOException {
        if (catalog != null) {
            this.visitCatalog(catalog);
            this.serialize(os);
        }
    }

    private void visitCatalog(ICatalog xmlCatalog) {
        try {
            this.doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            Logger.logException(e);
        }
        if (this.doc == null) {
            return;
        }
        Element catalogElement = this.doc.createElementNS("urn:oasis:names:tc:entity:xmlns:xml:catalog", "catalog");
        this.doc.appendChild(catalogElement);
        this.processCatalogEntries(xmlCatalog, catalogElement);
        this.processNextCatalogs(xmlCatalog, catalogElement);
        this.processDelegateCatalogs(xmlCatalog, catalogElement);
        this.processSuffixEntries(xmlCatalog, catalogElement);
        this.processRewriteEntries(xmlCatalog, catalogElement);
    }

    private void processRewriteEntries(ICatalog catalog, Element parent) {
        IRewriteEntry[] catalogEntries = catalog.getRewriteEntries();
        int i = 0;
        while (i < catalogEntries.length) {
            IRewriteEntry entry = catalogEntries[i];
            String startString = entry.getStartString();
            String prefix = entry.getRewritePrefix();
            Element childElement = null;
            switch (entry.getEntryType()) {
                case 21: {
                    childElement = parent.getOwnerDocument().createElement("rewriteSystem");
                    if (childElement == null) break;
                    childElement.setAttribute("systemIdStartString", startString);
                    childElement.setAttribute("rewritePrefix", prefix);
                    break;
                }
                case 22: {
                    childElement = parent.getOwnerDocument().createElement("rewriteURI");
                    if (childElement == null) break;
                    childElement.setAttribute("uriStartString", startString);
                    childElement.setAttribute("rewritePrefix", prefix);
                    break;
                }
            }
            if (childElement != null) {
                this.setAttributes(entry, childElement);
                parent.appendChild(childElement);
            }
            ++i;
        }
    }

    private void processSuffixEntries(ICatalog catalog, Element parent) {
        ISuffixEntry[] suffixEntries = catalog.getSuffixEntries();
        int i = 0;
        while (i < suffixEntries.length) {
            ISuffixEntry entry = suffixEntries[i];
            String suffixString = entry.getSuffix();
            String uri = entry.getURI();
            Element childElement = null;
            switch (entry.getEntryType()) {
                case 41: {
                    childElement = parent.getOwnerDocument().createElement("systemSuffix");
                    if (childElement == null) break;
                    childElement.setAttribute("systemIdSuffix", suffixString);
                    childElement.setAttribute("uri", uri);
                    break;
                }
                case 42: {
                    childElement = parent.getOwnerDocument().createElement("uriSuffix");
                    if (childElement == null) break;
                    childElement.setAttribute("uriSuffix", suffixString);
                    childElement.setAttribute("uri", uri);
                    break;
                }
            }
            if (childElement != null) {
                this.setAttributes(entry, childElement);
                parent.appendChild(childElement);
            }
            ++i;
        }
    }

    private void processDelegateCatalogs(ICatalog catalog, Element parent) {
        IDelegateCatalog[] delegateCatalogs = catalog.getDelegateCatalogs();
        int i = 0;
        while (i < delegateCatalogs.length) {
            IDelegateCatalog entry = delegateCatalogs[i];
            String prefixString = entry.getStartString();
            String catalogLocation = entry.getCatalogLocation();
            Element childElement = null;
            switch (entry.getEntryType()) {
                case 31: {
                    childElement = parent.getOwnerDocument().createElement("delegatePublic");
                    if (childElement == null) break;
                    childElement.setAttribute("publicIdStartString", prefixString);
                    childElement.setAttribute("catalog", catalogLocation);
                    break;
                }
                case 32: {
                    childElement = parent.getOwnerDocument().createElement("delegateSystem");
                    if (childElement == null) break;
                    childElement.setAttribute("systemIdStartString", prefixString);
                    childElement.setAttribute("catalog", catalogLocation);
                    break;
                }
                case 33: {
                    childElement = parent.getOwnerDocument().createElement("delegateURI");
                    if (childElement == null) break;
                    childElement.setAttribute("uriStartString", prefixString);
                    childElement.setAttribute("catalog", catalogLocation);
                    break;
                }
            }
            if (childElement != null) {
                this.setAttributes(entry, childElement);
                parent.appendChild(childElement);
            }
            ++i;
        }
    }

    private void processCatalogEntries(ICatalog catalog, Element parent) {
        ICatalogEntry[] catalogEntries = catalog.getCatalogEntries();
        int i = 0;
        while (i < catalogEntries.length) {
            ICatalogEntry entry = catalogEntries[i];
            String key = entry.getKey();
            String uri = entry.getURI();
            Element childElement = null;
            switch (entry.getEntryType()) {
                case 2: {
                    childElement = parent.getOwnerDocument().createElement("public");
                    if (childElement == null) break;
                    childElement.setAttribute("publicId", key);
                    childElement.setAttribute("uri", uri);
                    break;
                }
                case 3: {
                    childElement = parent.getOwnerDocument().createElement("system");
                    if (childElement == null) break;
                    childElement.setAttribute("systemId", key);
                    childElement.setAttribute("uri", uri);
                    break;
                }
                case 4: {
                    childElement = parent.getOwnerDocument().createElement("uri");
                    if (childElement == null) break;
                    childElement.setAttribute("name", key);
                    childElement.setAttribute("uri", uri);
                    break;
                }
            }
            if (childElement != null) {
                this.setAttributes(entry, childElement);
                parent.appendChild(childElement);
            }
            ++i;
        }
    }

    private void setAttributes(ICatalogElement entry, Element childElement) {
        String[] attributes = entry.getAttributes();
        int j = 0;
        while (j < attributes.length) {
            String attrName = attributes[j];
            if (attrName != null && !attrName.equals("")) {
                String attrValue = entry.getAttributeValue(attrName);
                if (childElement != null && attrValue != null) {
                    childElement.setAttribute(attrName, attrValue);
                }
            }
            ++j;
        }
        String id = entry.getId();
        if (id != null) {
            childElement.setAttribute("id", id);
        }
    }

    private void processNextCatalogs(ICatalog catalog, Element parent) {
        INextCatalog[] nextCatalogs = catalog.getNextCatalogs();
        Element childElement = null;
        int i = 0;
        while (i < nextCatalogs.length) {
            INextCatalog delegate = nextCatalogs[i];
            childElement = parent.getOwnerDocument().createElement("nextCatalog");
            if (childElement != null) {
                parent.appendChild(childElement);
                String location = delegate.getCatalogLocation();
                if (location != null) {
                    childElement.setAttribute("catalog", location);
                }
                this.setAttributes(delegate, childElement);
            }
            ++i;
        }
    }

    private void serialize(OutputStream outputStream) throws FileNotFoundException, IOException {
        if (this.doc == null) {
            return;
        }
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            String encoding = "UTF-8";
            if (encoding != null) {
                transformer.setOutputProperty("encoding", encoding);
            }
            transformer.transform(new DOMSource(this.doc), new StreamResult(outputStream));
        }
        catch (TransformerException e) {
            Logger.logException(e);
        }
    }

    private OutputStream getOutputStream(String uri) throws FileNotFoundException, IOException {
        String filePath = CatalogWriter.removeProtocol(uri);
        File file = new File(filePath);
        FileOutputStream stream = new FileOutputStream(file);
        return stream;
    }

    protected static String removeProtocol(String uri) {
        int index;
        String result = uri;
        String protocol_pattern = ":";
        if (uri != null && (index = uri.indexOf(protocol_pattern)) > 2) {
            result = result.substring(index + protocol_pattern.length());
        }
        return result;
    }
}

