/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.utils;

import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;

public final class UML2CppUtil {
    private UML2CppUtil() {
    }

    public static boolean isCppLanguage(String lang) {
        return "C++".equals(lang) || "C/C++".equals(lang) || "C".equals(lang) || "CPP".equals(lang);
    }

    public static String getCppCode(Constraint constraint) {
        String code = null;
        if (constraint.getSpecification() instanceof OpaqueExpression) {
            OpaqueExpression opaqueExpression = (OpaqueExpression)constraint.getSpecification();
            int i = 0;
            while (i < opaqueExpression.getLanguages().size()) {
                String language = (String)opaqueExpression.getLanguages().get(i);
                if (UML2CppUtil.isCppLanguage(language)) {
                    if (code != null) {
                        throw new RuntimeException("too many C++-compatible languages for " + constraint.getQualifiedName());
                    }
                    EList bodies = opaqueExpression.getBodies();
                    if (!bodies.isEmpty()) {
                        code = (String)bodies.get(i);
                    }
                }
                ++i;
            }
        }
        return code;
    }

    public static String getCppCode(Behavior behaviour) {
        String code = null;
        if (behaviour instanceof OpaqueBehavior) {
            OpaqueBehavior opaqueBehaviour = (OpaqueBehavior)behaviour;
            int i = 0;
            while (i < opaqueBehaviour.getLanguages().size()) {
                String language = (String)opaqueBehaviour.getLanguages().get(i);
                if (UML2CppUtil.isCppLanguage(language)) {
                    if (code != null) {
                        throw new RuntimeException("too many C++-compatible languages for " + behaviour.getQualifiedName());
                    }
                    EList bodies = opaqueBehaviour.getBodies();
                    if (!bodies.isEmpty()) {
                        code = (String)bodies.get(i);
                    }
                }
                ++i;
            }
        }
        return code;
    }

    public static String getCppCode(Operation operation) {
        String code = null;
        for (Behavior behaviour : operation.getMethods()) {
            String cppCode = UML2CppUtil.getCppCode(behaviour);
            if (cppCode == null) continue;
            if (code == null) {
                code = cppCode;
                continue;
            }
            throw new RuntimeException("too many C++-compatible behaviours for " + operation.getQualifiedName());
        }
        return code;
    }
}

