/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.runtime.linklf.router;

import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.figures.OrthogonalConnectionAnchor;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.OrthogonalRouterUtilities;
import org.eclipse.gmf.tooling.runtime.linklf.DiagramGridSpec;
import org.eclipse.gmf.tooling.runtime.linklf.SlidableSnapToGridAnchor;
import org.eclipse.gmf.tooling.runtime.linklf.router.HintedOrthogonalRouter;
import org.eclipse.gmf.tooling.runtime.linklf.router.RectilinearRouter2;
import org.eclipse.gmf.tooling.runtime.providers.router.SnapToGridRouter;

public class LinkLFRectilinearRouter
extends RectilinearRouter2
implements HintedOrthogonalRouter,
SnapToGridRouter {
    private final Map<Connection, HintedOrthogonalRouter.EndRoutingHint> myEndRoutingHints = new IdentityHashMap<Connection, HintedOrthogonalRouter.EndRoutingHint>();
    private DiagramGridSpec myGridSpec;

    @Override
    public HintedOrthogonalRouter.EndRoutingHint getDefaultEndRoutingStrategy() {
        return HintedOrthogonalRouter.EndRoutingHint.FixAnchorMoveBendpoint;
    }

    @Override
    public void setEditPartViewer(EditPartViewer viewer) {
        if (this.myGridSpec != null && this.myGridSpec.getViewer() == viewer) {
            return;
        }
        if (this.myGridSpec != null) {
            this.myGridSpec.dispose();
        }
        this.myGridSpec = viewer == null ? null : new DiagramGridSpec(viewer);
    }

    @Override
    public void setEndRoutingHint(Connection conn, HintedOrthogonalRouter.EndRoutingHint hint) {
        if (hint == this.getDefaultEndRoutingStrategy()) {
            hint = null;
        }
        if (hint == null) {
            this.myEndRoutingHints.remove(conn);
        } else {
            this.myEndRoutingHints.put(conn, hint);
        }
    }

    @Override
    public void routeLine(Connection conn, int nestedRoutingDepth, PointList newLine) {
        if (nestedRoutingDepth == 0 && newLine.size() >= 2) {
            Point sourceLoc = conn.getSourceAnchor().getReferencePoint().getCopy();
            Point targetLoc = conn.getTargetAnchor().getReferencePoint().getCopy();
            conn.translateToRelative((Translatable)sourceLoc);
            conn.translateToRelative((Translatable)targetLoc);
            newLine.setPoint(sourceLoc, 0);
            newLine.setPoint(targetLoc, newLine.size() - 1);
        }
        super.routeLine(conn, nestedRoutingDepth, newLine);
    }

    protected void resetEndPointsToEdge(Connection conn, PointList line) {
        if (this.isReorienting(conn)) {
            super.resetEndPointsToEdge(conn, line);
            return;
        }
        PrecisionRectangle source = this.sourceBoundsRelativeToConnection2(conn);
        PrecisionRectangle target = this.targetBoundsRelativeToConnection2(conn);
        int offSourceDirection = 0;
        int offTargetDirection = 0;
        int sourceAnchorRelativeLocation = 0;
        int targetAnchorRelativeLocation = 0;
        SnapToGrid snapper = this.getSnapper();
        if (line.size() == 0) {
            PrecisionPoint sourceReference = new PrecisionPoint(conn.getTargetAnchor().getReferencePoint());
            PrecisionPoint sourceAnchorPoint = new PrecisionPoint(conn.getSourceAnchor().getLocation((Point)sourceReference));
            PrecisionPoint targetAnchorPoint = new PrecisionPoint(conn.getTargetAnchor().getLocation((Point)sourceAnchorPoint));
            conn.translateToRelative((Translatable)sourceAnchorPoint);
            conn.translateToRelative((Translatable)targetAnchorPoint);
            line.addPoint((Point)sourceAnchorPoint);
            line.addPoint((Point)targetAnchorPoint);
            sourceAnchorRelativeLocation = this.getAnchorOffRectangleDirection2((Point)sourceAnchorPoint, (Rectangle)source);
            targetAnchorRelativeLocation = this.getAnchorOffRectangleDirection2((Point)targetAnchorPoint, (Rectangle)target);
            LinkLFRectilinearRouter.insertPointsProducingNotAlignedRectilinearSegments(conn, line, sourceAnchorRelativeLocation, targetAnchorRelativeLocation, snapper);
            offSourceDirection = LinkLFRectilinearRouter.getOffShapeDirection2(sourceAnchorRelativeLocation);
            offTargetDirection = LinkLFRectilinearRouter.getOffShapeDirection2(targetAnchorRelativeLocation);
        } else {
            PrecisionPoint anchorLocation;
            PrecisionPoint reference;
            if (conn.getSourceAnchor() instanceof OrthogonalConnectionAnchor) {
                this.addSegmentToSourceAnchor(line, conn, (OrthogonalConnectionAnchor)conn.getSourceAnchor());
            } else {
                reference = new PrecisionPoint(line.getFirstPoint());
                conn.getSourceAnchor().getOwner().translateToAbsolute((Translatable)reference);
                anchorLocation = new PrecisionPoint(conn.getSourceAnchor().getLocation((Point)reference));
                conn.translateToRelative((Translatable)anchorLocation);
                line.insertPoint((Point)anchorLocation, 0);
            }
            if (conn.getTargetAnchor() instanceof OrthogonalConnectionAnchor) {
                this.addSegmentToTargetAnchor(line, conn, (OrthogonalConnectionAnchor)conn.getTargetAnchor());
            } else {
                reference = new PrecisionPoint(line.getLastPoint());
                conn.getSourceAnchor().getOwner().translateToAbsolute((Translatable)reference);
                anchorLocation = new PrecisionPoint(conn.getTargetAnchor().getLocation((Point)reference));
                conn.translateToRelative((Translatable)anchorLocation);
                line.addPoint((Point)anchorLocation);
            }
            sourceAnchorRelativeLocation = this.getAnchorOffRectangleDirection2(line.getFirstPoint(), (Rectangle)source);
            offSourceDirection = LinkLFRectilinearRouter.getOffShapeDirection2(sourceAnchorRelativeLocation);
            targetAnchorRelativeLocation = this.getAnchorOffRectangleDirection2(line.getLastPoint(), (Rectangle)target);
            offTargetDirection = LinkLFRectilinearRouter.getOffShapeDirection2(targetAnchorRelativeLocation);
        }
        OrthogonalRouterUtilities.transformToOrthogonalPointList((PointList)line, (int)offSourceDirection, (int)offTargetDirection);
        LinkLFRectilinearRouter.removeRedundantPoints2(line);
    }

    @Deprecated
    public static void insertPointsProducingNotAlignedRectilinearSegments(PointList line, int sourceAnchorRelativeLocation, int targetAnchorRelativeLocation) {
        Point offStart = line.getFirstPoint();
        Point offEnd = line.getLastPoint();
        Dimension offsetDim = offStart.getDifference(offEnd).scale(0.5);
        offStart.translate(LinkLFRectilinearRouter.getTranslationValue2(sourceAnchorRelativeLocation, Math.abs(offsetDim.width), Math.abs(offsetDim.height)));
        offEnd.translate(LinkLFRectilinearRouter.getTranslationValue2(targetAnchorRelativeLocation, Math.abs(offsetDim.width), Math.abs(offsetDim.height)));
        line.insertPoint(offStart, 1);
        line.insertPoint(offEnd, 2);
    }

    public static void insertPointsProducingNotAlignedRectilinearSegments(Connection conn, PointList line, int sourceAnchorRelativeLocation, int targetAnchorRelativeLocation, SnapToGrid snapper) {
        LinkLFRectilinearRouter.insertPointsProducingNotAlignedRectilinearSegments(line, sourceAnchorRelativeLocation, targetAnchorRelativeLocation);
        if (LinkLFRectilinearRouter.asVerticalOrHorizontal(sourceAnchorRelativeLocation) != LinkLFRectilinearRouter.asVerticalOrHorizontal(targetAnchorRelativeLocation)) {
            return;
        }
        if (snapper != null) {
            PrecisionPoint addedForSource = new PrecisionPoint(line.getPoint(1));
            PrecisionPoint addedForSourceAbs = LinkLFRectilinearRouter.makeAbsolute((IFigure)conn, addedForSource.getPreciseCopy());
            PrecisionPoint snappedForSourceAbs = addedForSourceAbs.getPreciseCopy();
            PrecisionPoint addedForTarget = new PrecisionPoint(line.getPoint(2));
            PrecisionPoint addedForTargetAbs = LinkLFRectilinearRouter.makeAbsolute((IFigure)conn, addedForTarget.getPreciseCopy());
            PrecisionPoint snappedForTargetAbs = addedForTargetAbs.getPreciseCopy();
            snapper.snapPoint(null, LinkLFRectilinearRouter.asVerticalOrHorizontal(sourceAnchorRelativeLocation), addedForSourceAbs, snappedForSourceAbs);
            snapper.snapPoint(null, LinkLFRectilinearRouter.asVerticalOrHorizontal(targetAnchorRelativeLocation), addedForTargetAbs, snappedForTargetAbs);
            PrecisionPoint snappedForSource = LinkLFRectilinearRouter.makeRelative((IFigure)conn, snappedForSourceAbs.getPreciseCopy());
            PrecisionPoint snappedForTarget = LinkLFRectilinearRouter.makeRelative((IFigure)conn, snappedForTargetAbs.getPreciseCopy());
            if (snappedForSource.getDistance((Point)addedForSource) <= snappedForTarget.getDistance((Point)addedForTarget)) {
                Dimension delta = snappedForSource.getDifference((Point)addedForSource);
                line.setPoint((Point)snappedForSource, 1);
                line.setPoint(addedForTarget.getTranslated(delta), 2);
            } else {
                Dimension delta = snappedForTarget.getDifference((Point)addedForTarget);
                line.setPoint(addedForSource.getTranslated(delta), 1);
                line.setPoint((Point)snappedForTarget, 2);
            }
        }
    }

    public static int asVerticalOrHorizontal(int direction) {
        return LinkLFRectilinearRouter.getOffShapeDirection2(direction);
    }

    protected SnapToGrid getSnapper() {
        if (this.myGridSpec == null || this.myGridSpec.getAbsoluteGridSpec() == null) {
            return null;
        }
        return new SnapToGrid((GraphicalEditPart)this.myGridSpec.getViewer().getContents());
    }

    protected void addSegmentToSourceAnchor(PointList line, Connection conn, OrthogonalConnectionAnchor anchor) {
        Point firstBend = line.getFirstPoint();
        int prevSegmentOrientation = line.size() < 2 ? 0 : LinkLFRectilinearRouter.getSegmentOrientation(firstBend, line.getPoint(1));
        Point[] prependSegment = this.computeFirstOrLastSegment(conn, anchor, firstBend, prevSegmentOrientation);
        int i = 0;
        while (i < prependSegment.length) {
            Point next = prependSegment[i];
            if (i != prependSegment.length - 1 || !next.equals((Object)firstBend)) {
                line.insertPoint(next, i);
            }
            ++i;
        }
    }

    protected void addSegmentToTargetAnchor(PointList line, Connection conn, OrthogonalConnectionAnchor anchor) {
        Point lastBend = line.getLastPoint();
        int prevSegmentOrientation = line.size() < 2 ? 0 : LinkLFRectilinearRouter.getSegmentOrientation(lastBend, line.getPoint(line.size() - 2));
        Point[] appendSegment = this.computeFirstOrLastSegment(conn, anchor, lastBend, prevSegmentOrientation);
        int i = appendSegment.length - 1;
        while (i >= 0) {
            Point next = appendSegment[i];
            if (i != appendSegment.length - 1 || !next.equals((Object)lastBend)) {
                line.addPoint(next);
            }
            --i;
        }
    }

    protected Point[] computeFirstOrLastSegment(Connection conn, OrthogonalConnectionAnchor anchor, Point bendpoint, int prevSegmentOrientation) {
        LineSeg fromFigureToBendpoint = OrthogonalRouterUtilities.getOrthogonalLineSegToAnchorLoc((Connection)conn, (ConnectionAnchor)anchor, (Point)bendpoint);
        Point figurePoint = fromFigureToBendpoint.getOrigin();
        Point syntheticBend = bendpoint.getCopy();
        HintedOrthogonalRouter.EndRoutingHint hint = this.findEndRoutingHint(conn, anchor);
        if (hint == HintedOrthogonalRouter.EndRoutingHint.FixAnchorMoveBendpoint) {
            Point bendpointInAbsCoordinates = bendpoint.getCopy();
            conn.translateToAbsolute((Translatable)bendpointInAbsCoordinates);
            int orientation = this.getOrientationAgainst((ConnectionAnchor)anchor, bendpointInAbsCoordinates);
            if (orientation == 0) {
                orientation = this.getPreferredOutgoingDirection(conn, (ConnectionAnchor)anchor);
            }
            if (orientation == 0) {
                orientation = LinkLFRectilinearRouter.flipOrientation(prevSegmentOrientation);
            }
            Point refPoint = anchor.getReferencePoint().getCopy();
            conn.translateToRelative((Translatable)refPoint);
            switch (orientation) {
                case 128: {
                    syntheticBend.setX(refPoint.x());
                    break;
                }
                case 64: {
                    syntheticBend.setY(refPoint.y());
                    break;
                }
            }
            fromFigureToBendpoint = OrthogonalRouterUtilities.getOrthogonalLineSegToAnchorLoc((Connection)conn, (ConnectionAnchor)anchor, (Point)syntheticBend);
            figurePoint = fromFigureToBendpoint.getOrigin();
        }
        Point[] result = new Point[]{figurePoint, syntheticBend};
        return result;
    }

    private int getOrientationAgainst(ConnectionAnchor anchor, Point orthoReference) {
        PrecisionPoint ownReference = new PrecisionPoint(anchor.getReferencePoint());
        PrecisionRectangle bounds = new PrecisionRectangle(FigureUtilities.getAnchorableFigureBounds((IFigure)anchor.getOwner()));
        anchor.getOwner().translateToAbsolute((Translatable)bounds);
        bounds.expand(1.0E-6, 1.0E-6);
        PrecisionPoint preciseOrthoReference = new PrecisionPoint(orthoReference);
        int orientation = 0;
        if (bounds.contains((Point)preciseOrthoReference)) {
            int side = SlidableSnapToGridAnchor.getClosestSide2((Point)ownReference, (Rectangle)bounds);
            switch (side) {
                case 1: 
                case 4: {
                    orientation = 64;
                    break;
                }
                case 8: 
                case 32: {
                    orientation = 128;
                }
            }
        } else if (preciseOrthoReference.preciseX >= bounds.preciseX && preciseOrthoReference.preciseX <= bounds.preciseX + bounds.preciseWidth) {
            orientation = 128;
        } else if (preciseOrthoReference.preciseY >= bounds.preciseY && preciseOrthoReference.preciseY <= bounds.preciseY + bounds.preciseHeight) {
            orientation = 64;
        }
        return orientation;
    }

    protected HintedOrthogonalRouter.EndRoutingHint findEndRoutingHint(Connection conn, OrthogonalConnectionAnchor anchor) {
        HintedOrthogonalRouter.EndRoutingHint result = this.myEndRoutingHints.get(conn);
        if (result == null) {
            result = this.getDefaultEndRoutingStrategy();
        }
        return result;
    }

    protected static int flipOrientation(int verticalOrHorizontal) {
        switch (verticalOrHorizontal) {
            case 128: {
                return 64;
            }
            case 64: {
                return 128;
            }
        }
        return 0;
    }

    protected static int getSegmentOrientation(Point start, Point end) {
        if (start.x() == end.x()) {
            return 128;
        }
        if (start.y() == end.y()) {
            return 64;
        }
        return 0;
    }

    protected int getPreferredOutgoingDirection(Connection conn, ConnectionAnchor anchor) {
        IFigure owner = anchor.getOwner();
        if (owner == null) {
            return 0;
        }
        PrecisionRectangle bounds = new PrecisionRectangle(FigureUtilities.getAnchorableFigureBounds((IFigure)owner));
        owner.translateToAbsolute((Translatable)bounds);
        conn.translateToRelative((Translatable)bounds);
        PrecisionPoint anchorLoc = new PrecisionPoint(anchor.getReferencePoint());
        conn.translateToRelative((Translatable)anchorLoc);
        if (Math.abs(anchorLoc.preciseX() - bounds.preciseX()) < 2.0) {
            return 64;
        }
        if (Math.abs(anchorLoc.preciseX() - bounds.preciseRight()) < 2.0) {
            return 64;
        }
        if (Math.abs(anchorLoc.preciseY() - bounds.preciseY()) < 2.0) {
            return 128;
        }
        if (Math.abs(anchorLoc.preciseY() - bounds.preciseBottom()) < 2.0) {
            return 128;
        }
        return 0;
    }
}

