/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.internal.defaultlanguage;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.BadStateException;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.papyrus.uml.tools.model.UmlUtils;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.papyrusrt.umlrt.core.Activator;
import org.eclipse.papyrusrt.umlrt.core.defaultlanguage.IDefaultLanguage;
import org.eclipse.papyrusrt.umlrt.core.defaultlanguage.IDefaultLanguageService;
import org.eclipse.papyrusrt.umlrt.core.internal.defaultlanguage.DefaultLanguageRegistry;
import org.eclipse.papyrusrt.umlrt.core.internal.defaultlanguage.NoDefautLanguage;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.internal.operations.PackageOperations;

public class DefaultLanguageService
extends PlatformObject
implements IDefaultLanguageService {
    private static final String LANGUAGE_ANNOTATION_SOURCE = "http://www.eclipse.org/papyrus-rt/language/1.0.0";
    private static final String LANGUAGE_ANNOTATION_VALUE = "language";
    protected ServicesRegistry registry;

    @Override
    public IDefaultLanguage getActiveDefaultLanguage(Element element) {
        String languageKey = this.getLanguageKey(element);
        for (IDefaultLanguage iDefaultLanguage : this.getAvailableDefaultLanguages()) {
            if (!languageKey.equals(iDefaultLanguage.getId())) continue;
            return iDefaultLanguage;
        }
        return NoDefautLanguage.INSTANCE;
    }

    @Override
    public void setActiveDefaultLanguage(Element element, IDefaultLanguage language) {
        if (language == null) {
            language = NoDefautLanguage.INSTANCE;
        }
        this.uninstallLanguage(element);
        this.updateLanguageAnnotation(element, language);
        this.installLanguage(element, language);
    }

    protected void updateLanguageAnnotation(Element element, IDefaultLanguage language) {
        if (!NoDefautLanguage.INSTANCE.equals(language)) {
            EAnnotation annotation = UML2Util.getEAnnotation((EModelElement)element, (String)LANGUAGE_ANNOTATION_SOURCE, (boolean)true);
            annotation.getDetails().put((Object)LANGUAGE_ANNOTATION_VALUE, (Object)language.getId());
        } else {
            EAnnotation annotation = UML2Util.getEAnnotation((EModelElement)element, (String)LANGUAGE_ANNOTATION_SOURCE, (boolean)false);
            if (annotation != null) {
                element.getEAnnotations().remove((Object)annotation);
            }
        }
    }

    protected String getLanguageKey(Element element) {
        Package rootPackage = PackageUtil.getRootPackage((Element)element);
        String key = NoDefautLanguage.INSTANCE.getId();
        if (rootPackage != null) {
            String value;
            EAnnotation annotation = rootPackage.getEAnnotation(LANGUAGE_ANNOTATION_SOURCE);
            if (annotation != null && (value = (String)annotation.getDetails().get((Object)LANGUAGE_ANNOTATION_VALUE)) != null) {
                key = value;
            }
        } else {
            Activator.log.error("impossible to find root element for: " + element, null);
        }
        return key;
    }

    @Override
    public List<? extends IDefaultLanguage> getAvailableDefaultLanguages() {
        return DefaultLanguageRegistry.getInstance().getLanguages();
    }

    public void init(ServicesRegistry servicesRegistry) throws ServiceException {
        this.registry = servicesRegistry;
    }

    public void startService() throws ServiceException {
        Activator.log.trace("defaultLanguage", "DefaultLanguageService#startService() ...");
        Package root = this.getRoot();
        if (root != null) {
            ModelSet modelSet = (ModelSet)this.registry.getService(ModelSet.class);
            IDefaultLanguage language = this.getDefaultLanguage(root, modelSet);
            this.initLanguage(root, (ResourceSet)modelSet, language);
        }
        Activator.log.trace("defaultLanguage", "DefaultLanguageService#startService() finished");
    }

    public void disposeService() throws ServiceException {
        this.registry = null;
    }

    public <T> T getAdapter(Class<T> adapter) {
        Object result = adapter.isInstance(this.registry) ? adapter.cast(this.registry) : (this.registry == null ? null : ServiceUtils.getInstance().getService(adapter, (Object)this.registry, null));
        return (T)(result != null ? result : super.getAdapter(adapter));
    }

    @Override
    public void installLanguage(Element element, IDefaultLanguage language) {
        Activator.log.trace("defaultLanguage", "DefaultLanguageService#installLanguage(" + EMFCoreUtil.getName((EObject)element) + ", " + language + ")\n");
        Package root = this.getRoot();
        if (root == null) {
            return;
        }
        if (language != null) {
            ResourceSet rset = EMFHelper.getResourceSet((EObject)root);
            this.initLanguage(root, rset, language);
            MultiStatus status = null;
            for (String profileURI : language.getProfilesToApply()) {
                try {
                    Resource modelResource = this.loadResource(rset, URI.createURI((String)profileURI));
                    if (!(modelResource.getContents().get(0) instanceof Profile)) continue;
                    PackageUtil.applyProfile((Package)root, (Profile)((Profile)modelResource.getContents().get(0)), (boolean)true);
                }
                catch (CoreException e) {
                    if (status == null) {
                        status = new MultiStatus("org.eclipse.papyrusrt.umlrt.core", 4, "Error while loading profiles from DefaultLanguage: " + language.getName(), null);
                    }
                    status.add(e.getStatus());
                }
            }
            if (status != null) {
                Activator.log.log(status);
            }
        }
    }

    @Override
    public void uninstallLanguage(Element element) {
        Activator.log.trace("defaultLanguage", "DefaultLanguageService#uninstallLanguage(" + EMFCoreUtil.getName((EObject)element) + ")");
        Package root = this.getRoot();
        if (root == null) {
            return;
        }
        IDefaultLanguage language = this.getActiveDefaultLanguage(element);
        if (language != null) {
            for (String profileURI : language.getProfilesToApply()) {
                Resource modelResource = EMFHelper.getResourceSet((EObject)root).getResource(URI.createURI((String)profileURI), true);
                if (modelResource == null || !(modelResource.getContents().get(0) instanceof Profile)) continue;
                PackageOperations.unapplyProfile((Package)root, (Profile)((Profile)modelResource.getContents().get(0)));
            }
        }
    }

    protected Package getRoot() {
        try {
            EObject eObject;
            ModelSet modelSet = (ModelSet)this.registry.getService(ModelSet.class);
            UmlModel model = UmlUtils.getUmlModel((ModelSet)modelSet);
            if (model != null && !model.getResource().getContents().isEmpty() && (eObject = (EObject)model.getResource().getContents().get(0)) instanceof Package) {
                return (Package)eObject;
            }
            return null;
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
            return null;
        }
    }

    protected IDefaultLanguage getDefaultLanguage(Package root, ModelSet modelSet) {
        IDefaultLanguageService service = null;
        IDefaultLanguage language = null;
        try {
            ServicesRegistry registry = ServiceUtilsForEObject.getInstance().getServiceRegistry((EObject)root);
            registry.startServicesByClassKeys(new Class[]{IDefaultLanguageService.class});
            service = (IDefaultLanguageService)ServiceUtilsForEObject.getInstance().getService(IDefaultLanguageService.class, (Object)root);
            if (service != null) {
                language = service.getActiveDefaultLanguage((Element)root);
            } else {
                Activator.log.trace("defaultLanguage", "No service found for this package: " + root);
                language = NoDefautLanguage.INSTANCE;
            }
        }
        catch (BadStateException e) {
            Activator.log.error((Throwable)e);
            language = NoDefautLanguage.INSTANCE;
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
            language = NoDefautLanguage.INSTANCE;
        }
        Activator.log.trace("defaultLanguage", "Language " + language.getName() + " for : " + root);
        return language;
    }

    protected IStatus loadDefaultLanguageLibrary(Package root, ResourceSet resourceSet, IDefaultLanguage defaultLanguage) {
        Activator.log.trace("defaultLanguage", "loading default language libraries...");
        MultiStatus status = null;
        for (String libraryURI : defaultLanguage.getLibrariesToImport()) {
            URI uri = URI.createURI((String)libraryURI);
            if (uri == null) continue;
            try {
                this.loadResource(resourceSet, uri);
            }
            catch (CoreException e) {
                if (status == null) {
                    status = new MultiStatus("org.eclipse.papyrusrt.umlrt.core", 4, "Error while loading libraries from DefaultLanguage: " + defaultLanguage.getName(), null);
                }
                ((MultiStatus)status).add(e.getStatus());
            }
        }
        Activator.log.trace("defaultLanguage", "loading default language libraries: " + (status == null ? "OK" : status));
        return status == null ? Status.OK_STATUS : status;
    }

    private Resource loadResource(ResourceSet rset, URI uri) throws CoreException {
        Resource result = null;
        try {
            result = rset.getResource(uri, true);
        }
        catch (Exception exception) {
            result = rset.getResource(uri, false);
        }
        if (result == null || result.getContents().isEmpty() || !result.getErrors().isEmpty()) {
            Throwable exception = result.getErrors().stream().filter(Throwable.class::isInstance).map(Throwable.class::cast).findAny().orElse(null);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrusrt.umlrt.core", "Failed to load default language resource: " + uri, exception));
        }
        return result;
    }

    private void initLanguage(Package rootPackage, ResourceSet resourceSet, IDefaultLanguage language) {
        IStatus libraryStatus = this.loadDefaultLanguageLibrary(rootPackage, resourceSet, language);
        if (!libraryStatus.isOK()) {
            Activator.log.error("Error while loading default language libraries:" + libraryStatus, null);
        }
    }
}

