/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.types.advice;

import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.commands.Activator;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusView;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.papyrusrt.umlrt.core.internal.commands.CreateHeadlessCapsuleStructureDiagramCommand;
import org.eclipse.papyrusrt.umlrt.core.types.ElementTypeUtils;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.UMLPackage;

public class CapsuleEditHelperAdvice
extends AbstractEditHelperAdvice {
    public boolean approveRequest(IEditCommandRequest request) {
        if (request instanceof CreateRelationshipRequest) {
            return this.approveCreateRelationshipRequest(request);
        }
        if (request instanceof CreateElementRequest) {
            return this.approveCreateElementRequest((CreateElementRequest)request);
        }
        return super.approveRequest(request);
    }

    public void configureRequest(IEditCommandRequest request) {
        IElementType typeToCreate;
        if (request instanceof CreateElementRequest && ElementTypeUtils.isTypeCompatible(typeToCreate = ((CreateElementRequest)request).getElementType(), ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.RTStateMachine"))) {
            Object nameToSet;
            EReference containmentRef = ((CreateElementRequest)request).getContainmentFeature();
            if (containmentRef == null) {
                ((CreateElementRequest)request).setContainmentFeature(UMLPackage.eINSTANCE.getBehavioredClassifier_OwnedBehavior());
            }
            if ((nameToSet = request.getParameter("nameToSet")) == null) {
                request.setParameter("nameToSet", (Object)"StateMachine");
            }
        }
    }

    private Boolean approveCreateElementRequest(CreateElementRequest request) {
        Boolean result = super.approveRequest((IEditCommandRequest)request);
        IElementType typeToCreate = request.getElementType();
        if (ElementTypeUtils.isTypeCompatible(typeToCreate, ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.RTStateMachine")) && request.getContainer() instanceof BehavioredClassifier) {
            BehavioredClassifier stateToEdit = (BehavioredClassifier)request.getContainer();
            result = stateToEdit.getClassifierBehavior() != null && ElementTypeUtils.matches((EObject)stateToEdit.getClassifierBehavior(), "org.eclipse.papyrusrt.umlrt.core.RTStateMachine") != false ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
        return result;
    }

    protected boolean approveCreateRelationshipRequest(IEditCommandRequest request) {
        IElementType type = ((CreateRelationshipRequest)request).getElementType();
        if (type != null && ElementTypeUtils.isTypeCompatible(type, ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.RTConnector"))) {
            return this.checkSourceAndTargetForRTConnector((CreateRelationshipRequest)request);
        }
        return super.approveRequest(request);
    }

    protected boolean checkSourceAndTargetForRTConnector(CreateRelationshipRequest createRelationshipRequest) {
        EObject source = createRelationshipRequest.getSource();
        EObject target = createRelationshipRequest.getTarget();
        if (source != null) {
            if (ElementTypeUtils.matches(source, "org.eclipse.papyrusrt.umlrt.core.ServiceAccessPoint").booleanValue()) {
                return false;
            }
            if (ElementTypeUtils.matches(source, "org.eclipse.papyrusrt.umlrt.core.ServiceProvisionPoint").booleanValue()) {
                return false;
            }
        }
        if (target != null) {
            if (ElementTypeUtils.matches(target, "org.eclipse.papyrusrt.umlrt.core.ServiceAccessPoint").booleanValue()) {
                return false;
            }
            if (ElementTypeUtils.matches(target, "org.eclipse.papyrusrt.umlrt.core.ServiceProvisionPoint").booleanValue()) {
                return false;
            }
        }
        return true;
    }

    protected ICommand getBeforeConfigureCommand(ConfigureRequest request) {
        final Class capsule = (Class)request.getElementToConfigure();
        return new ConfigureElementCommand(request){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                capsule.setIsActive(true);
                this.createCompositeDiagram();
                return CommandResult.newOKCommandResult((Object)capsule);
            }

            protected Diagram createCompositeDiagram() {
                ModelSet modelSet;
                ServicesRegistry registry;
                try {
                    registry = ServiceUtilsForEObject.getInstance().getServiceRegistry((EObject)capsule);
                }
                catch (ServiceException ex) {
                    Activator.log.error((Throwable)ex);
                    return null;
                }
                try {
                    modelSet = (ModelSet)registry.getService(ModelSet.class);
                }
                catch (ServiceException ex) {
                    Activator.log.error((Throwable)ex);
                    return null;
                }
                Collection prototypes = PolicyChecker.getCurrent().getPrototypesFor((EObject)capsule);
                for (ViewPrototype prototype : prototypes) {
                    PapyrusView view = prototype.getConfiguration();
                    if (view == null || !"UML-RT Capsule Structure Diagram".equals(view.getName())) continue;
                    return new CreateHeadlessCapsuleStructureDiagramCommand().createDiagram(modelSet, (EObject)capsule, (EObject)capsule, prototype, null, false);
                }
                return null;
            }
        };
    }
}

