/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.types.advice;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.GetEditContextCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrusrt.umlrt.core.Activator;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolContainerUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolUtils;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;

public class ProtocolContainerEditHelperAdvice
extends AbstractEditHelperAdvice {
    public boolean approveRequest(IEditCommandRequest request) {
        if (request instanceof CreateElementRequest) {
            CreateElementRequest createElementRequest = (CreateElementRequest)request;
            IElementType type = createElementRequest.getElementType();
            IElementType umlRTMessageType = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.ProtocolMessage");
            if (umlRTMessageType == null) {
                Activator.log.debug("RTMessage element type is not accessible");
                return super.approveRequest(request);
            }
            List<IElementType> types = Arrays.asList(type.getAllSuperTypes());
            if (types.contains(umlRTMessageType)) {
                return true;
            }
            return super.approveRequest((IEditCommandRequest)createElementRequest);
        }
        return super.approveRequest(request);
    }

    public void configureRequest(IEditCommandRequest request) {
        EObject elementToDestroy;
        if (request instanceof DestroyElementRequest && ProtocolUtils.isProtocol(elementToDestroy = ((DestroyElementRequest)request).getElementToDestroy()).booleanValue()) {
            Object o = request.getParameter("DestroyElementRequest.initialElementToDestroy");
            if (o == null) {
                ((DestroyElementRequest)request).setElementToDestroy((EObject)ProtocolUtils.getProtocolContainer((Collaboration)elementToDestroy));
            } else if (!o.equals(ProtocolUtils.getProtocolContainer((Collaboration)elementToDestroy)) && o instanceof EObject && ProtocolContainerUtils.isProtocolContainer((EObject)o)) {
                ((DestroyElementRequest)request).setElementToDestroy((EObject)ProtocolUtils.getProtocolContainer((Collaboration)elementToDestroy));
                request.setParameter("DestroyElementRequest.initialElementToDestroy", (Object)ProtocolUtils.getProtocolContainer((Collaboration)elementToDestroy));
            }
        }
        super.configureRequest(request);
    }

    protected ICommand getBeforeEditContextCommand(GetEditContextRequest request) {
        IEditCommandRequest editCommandRequest = request.getEditCommandRequest();
        if (editCommandRequest instanceof CreateElementRequest) {
            CreateElementRequest createElementRequest = (CreateElementRequest)editCommandRequest;
            IElementType type = createElementRequest.getElementType();
            IElementType umlRTMessageType = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.ProtocolMessage");
            if (umlRTMessageType == null) {
                Activator.log.debug("RTMessage element type is not accessible");
                return super.getBeforeEditContextCommand(request);
            }
            List<IElementType> types = Arrays.asList(type.getAllSuperTypes());
            if (types.contains(umlRTMessageType)) {
                GetEditContextCommand command = new GetEditContextCommand(request);
                if (request.getEditContext() instanceof Package) {
                    command.setEditContext((Object)ProtocolContainerUtils.getMessageSetIn((Package)request.getEditContext()));
                }
                return command;
            }
        }
        return super.getBeforeEditContextCommand(request);
    }

    protected ICommand getBeforeSetCommand(SetRequest request) {
        ICommand result = ProtocolContainerUtils.isProtocolContainer(request.getElementToEdit()) && request.getFeature() == UMLPackage.Literals.NAMED_ELEMENT__NAME && ProtocolContainerUtils.getProtocol((Package)request.getElementToEdit()) != null ? this.getSetProtocolFeatureCommand(request) : (ProtocolContainerUtils.isProtocolContainer(request.getElementToEdit()) && request.getFeature() instanceof EReference && request.getFeature().isMany() && request.getValue() instanceof List && ((EReference)request.getFeature()).getEReferenceType().isSuperTypeOf(UMLPackage.Literals.PACKAGE) ? this.getSetPackagedElementsCommand(request) : super.getBeforeSetCommand(request));
        return result;
    }

    private ICommand getSetPackagedElementsCommand(SetRequest request) {
        DropIntoProtocolContainerCommand result;
        List value = ((List)request.getValue()).stream().map(o -> ProtocolUtils.isProtocol(o) != false ? ProtocolUtils.getProtocolContainer((Collaboration)o) : o).collect(Collectors.toList());
        List originalContents = (List)request.getElementToEdit().eGet(request.getFeature());
        int dropTargetIndex = value.indexOf(request.getElementToEdit());
        ArrayList dropped = Lists.newArrayListWithExpectedSize((int)1);
        boolean insertBefore = false;
        int i = 0;
        while (i < value.size()) {
            if (i != dropTargetIndex && !originalContents.contains(value.get(i))) {
                dropped.add((EObject)value.get(i));
                insertBefore = i < dropTargetIndex;
            }
            ++i;
        }
        if (!dropped.isEmpty()) {
            EObject realTarget = request.getElementToEdit().eContainer();
            List realContents = (List)realTarget.eGet(request.getFeature());
            ArrayList newValue = new ArrayList(realContents);
            newValue.remove(dropped);
            int realDropIndex = newValue.indexOf(request.getElementToEdit());
            result = new DropIntoProtocolContainerCommand(request, realTarget, dropped, insertBefore ? realDropIndex : realDropIndex + 1);
            request.setParameter("IEditCommandRequest.replaceDefaultCommand", (Object)true);
        } else {
            result = null;
        }
        return result;
    }

    private ICommand getSetProtocolFeatureCommand(SetRequest request) {
        ICommand result = null;
        Collaboration protocol = ProtocolContainerUtils.getProtocol((Package)request.getElementToEdit());
        SetRequest newRequest = new SetRequest(request.getEditingDomain(), (EObject)protocol, request.getFeature(), request.getValue());
        IElementEditService edit = ElementEditServiceUtils.getCommandProvider((Object)protocol);
        if (edit != null) {
            result = edit.getEditCommand((IEditCommandRequest)newRequest);
            request.setParameter("IEditCommandRequest.replaceDefaultCommand", (Object)true);
        }
        return result;
    }

    private static class DropIntoProtocolContainerCommand
    extends AbstractTransactionalCommand {
        private static final Map<Transaction, Integer> previouslyDroppedByTransaction = new WeakHashMap<Transaction, Integer>();
        private final EObject target;
        private final EStructuralFeature feature;
        private final List<? extends EObject> dropped;
        private final int index;

        DropIntoProtocolContainerCommand(SetRequest request, EObject target, List<? extends EObject> dropped, int index) {
            super(request.getEditingDomain(), "Drop Element(s)", DropIntoProtocolContainerCommand.getWorkspaceFiles(target, dropped));
            this.target = target;
            this.feature = request.getFeature();
            this.dropped = dropped;
            this.index = index;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            EList list = (EList)this.target.eGet(this.feature);
            Transaction active = this.getActiveTransaction();
            int offset = previouslyDroppedByTransaction.getOrDefault(active, 0);
            int pos = this.index + offset;
            for (EObject eObject : this.dropped) {
                if (list.contains((Object)eObject)) {
                    list.move(pos, (Object)eObject);
                } else {
                    list.add(pos, (Object)eObject);
                }
                ++pos;
            }
            previouslyDroppedByTransaction.put(active, offset + this.dropped.size());
            return CommandResult.newOKCommandResult();
        }

        private Transaction getActiveTransaction() {
            return ((InternalTransactionalEditingDomain)this.getEditingDomain()).getActiveTransaction().getRoot();
        }

        private static List<IFile> getWorkspaceFiles(EObject object, Collection<? extends EObject> more) {
            ArrayList<Object> allObjects = new ArrayList<Object>(1 + more.size());
            allObjects.add(object);
            allObjects.addAll(more);
            return DropIntoProtocolContainerCommand.getWorkspaceFiles(allObjects);
        }
    }
}

