/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.papyrusrt.umlrt.core.types.ElementTypeUtils;
import org.eclipse.papyrusrt.umlrt.core.types.UMLRTElementTypesEnumerator;
import org.eclipse.papyrusrt.umlrt.core.utils.UMLRTProfileUtils;
import org.eclipse.papyrusrt.umlrt.profile.statemachine.UMLRTStateMachines.UMLRTStateMachinesPackage;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Vertex;

public class RegionUtils {
    public static boolean isRTRegion(Region region) {
        return ElementTypeUtils.matches((EObject)region, "org.eclipse.papyrusrt.umlrt.core.RTRegion");
    }

    public static ICommand getConfigureAsRTRegionCommand(Region region) {
        return ElementTypeUtils.getConfigureAsCommand((IElementType)UMLRTElementTypesEnumerator.RT_REGION, (EObject)region);
    }

    public static Region applyStereotype(Region region) {
        return UMLRTProfileUtils.ensureStereotype(region, UMLRTStateMachinesPackage.Literals.RT_REGION);
    }

    public static List<Pseudostate> getInitialPseudoStates(Region region) {
        ArrayList<Pseudostate> pseudoStates = new ArrayList<Pseudostate>();
        for (Vertex vertex : region.getSubvertices()) {
            if (!RegionUtils.isInitialPseudoState(vertex)) continue;
            pseudoStates.add((Pseudostate)vertex);
        }
        return pseudoStates;
    }

    public static List<State> getStates(Region region) {
        ArrayList<State> states = new ArrayList<State>();
        for (Vertex vertex : region.getSubvertices()) {
            if (!(vertex instanceof State)) continue;
            states.add((State)vertex);
        }
        return states;
    }

    public static boolean isInitialPseudoState(Vertex vertex) {
        Pseudostate ps;
        return vertex instanceof Pseudostate && (ps = (Pseudostate)vertex).getKind() == PseudostateKind.INITIAL_LITERAL;
    }
}

