/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.utils;

import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.TransitionKind;

public final class TransitionUtils {
    private TransitionUtils() {
    }

    public static TransitionKind getTransitionKind(Transition transition, EObject source, EObject target) {
        EObject targetState;
        EObject sourceState = TransitionUtils.getImplicitState(source);
        boolean isLoop = sourceState == (targetState = TransitionUtils.getImplicitState(target));
        TransitionKind expectedKind = TransitionKind.EXTERNAL_LITERAL;
        if (sourceState instanceof State && ((State)sourceState).isComposite()) {
            if (!isLoop && Stream.iterate(targetState, EObject::eContainer).filter(e -> e == sourceState || e.eContainer() == null).findFirst().get() == sourceState) {
                expectedKind = TransitionKind.LOCAL_LITERAL;
            }
            if (isLoop && Stream.iterate(transition, EObject::eContainer).filter(e -> e == sourceState || e.eContainer() == null).findFirst().get() == sourceState) {
                expectedKind = transition != null && TransitionKind.INTERNAL_LITERAL.equals((Object)transition.getKind()) ? TransitionKind.INTERNAL_LITERAL : TransitionKind.LOCAL_LITERAL;
            }
        }
        return expectedKind;
    }

    public static EObject getImplicitState(EObject vertex) {
        PseudostateKind kind;
        if (vertex instanceof Pseudostate && (PseudostateKind.ENTRY_POINT_LITERAL.equals((Object)(kind = ((Pseudostate)vertex).getKind())) || PseudostateKind.EXIT_POINT_LITERAL.equals((Object)kind))) {
            return vertex.eContainer();
        }
        return vertex;
    }

    public static boolean isInternalTransition(EObject object) {
        return object instanceof Transition && TransitionKind.INTERNAL_LITERAL == ((Transition)object).getKind();
    }
}

