/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.ui.launching;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LaunchingUtils {
    public static void loadPerspectiveManager() {
        DebugUITools.class.getName();
    }

    public static void prepareBrowseFileSystemButton(@NonNull Button browseFileSystemButton, final @NonNull Text uriField, final boolean isSave) {
        final Shell shell = browseFileSystemButton.getShell();
        browseFileSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileDialog = new FileDialog(shell, isSave ? 8192 : 0);
                fileDialog.open();
                String filterPath = fileDialog.getFilterPath();
                String fileName = fileDialog.getFileName();
                if (fileName != null) {
                    uriField.setText(URI.createFileURI((String)(String.valueOf(filterPath) + File.separator + fileName)).toString());
                }
            }
        });
    }

    public static void prepareBrowseWorkspaceButton(@NonNull Button browseWorkspaceButton, @NonNull Text uriField, boolean isSave) {
        LaunchingUtils.prepareBrowseWorkspaceButton(browseWorkspaceButton, null, uriField, isSave);
    }

    public static void prepareBrowseWorkspaceButton(@NonNull Button browseWorkspaceButton, final @Nullable String name, final @NonNull Text uriField, final boolean isSave) {
        final Shell shell = browseWorkspaceButton.getShell();
        browseWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String title = name != null ? "'" + name + "' File Selection" : "File Selection";
                IFile file = null;
                if (isSave) {
                    String message = name != null ? "Select a folder and specify a file '" + name + "' for use as the '" + name + "'" : "Select a folder and specify a file";
                    String path = this.getContextPath();
                    ArrayList<1> filters = new ArrayList<1>();
                    filters.add(new ViewerFilter(){

                        public boolean select(Viewer viewer, Object parentElement, Object element) {
                            return true;
                        }
                    });
                    file = WorkspaceResourceDialog.openNewFile((Shell)shell, (String)title, (String)message, (IPath)(path != null ? new Path(path) : null), null);
                } else {
                    String message = name != null ? "Select a file '" + name + "' for use as the '" + name + "'" : "Select a file";
                    IFile[] files = WorkspaceResourceDialog.openFileSelection((Shell)shell, (String)title, (String)message, (boolean)false, (Object[])this.getContextSelection(), null);
                    if (files.length != 0) {
                        file = files[0];
                    }
                }
                if (file != null) {
                    uriField.setText(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true).toString());
                }
            }

            private String getContextPath() {
                String path;
                block5: {
                    URI context;
                    block4: {
                        String text = uriField.getText();
                        try {
                            URI uRI = context = text != null ? URI.createURI((String)text) : null;
                            if (context != null && context.isPlatformResource()) break block4;
                            return null;
                        }
                        catch (Exception e) {
                            return null;
                        }
                    }
                    path = context.path();
                    if (path != null && path.length() >= 9) break block5;
                    return null;
                }
                return path.substring(9);
            }

            private Object[] getContextSelection() {
                String path = this.getContextPath();
                while (path != null) {
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    IResource resource = root.findMember(path);
                    if (resource != null && resource.isAccessible()) {
                        return new Object[]{resource};
                    }
                    int index = path.lastIndexOf("/");
                    if (index < 0) continue;
                    path = path.substring(0, index);
                }
                return null;
            }
        });
    }
}

