/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.common.ui.preferences;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrusrt.umlrt.common.ui.Activator;
import org.eclipse.papyrusrt.umlrt.common.ui.internal.preferences.ToggleDialogDelegateRegistry;
import org.eclipse.papyrusrt.umlrt.common.ui.preferences.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.statushandlers.IStatusAdapterConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.service.prefs.BackingStoreException;

public class DialogPreferences {
    private static final String DIALOG_TOGGLE_NODE = "dialogToggle";
    private static final String DIALOG_TOGGLE_PATH = "org.eclipse.papyrusrt.umlrt.common.ui/dialogToggle";
    private static final IPreferenceStore dialogTogglePreferences = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.papyrusrt.umlrt.common.ui/dialogToggle");
    private static ToggleDialogDelegateRegistry delegateRegistry;

    private DialogPreferences() {
    }

    public static IPreferenceStore getDialogTogglePreferenceStore() {
        return dialogTogglePreferences;
    }

    public static int yesNo(Shell parent, String title, String message, String dialogID) {
        return DialogPreferences.prompt(3, parent, title, message, dialogID, 0x10000000);
    }

    public static int yesNoCancel(Shell parent, String title, String message, String dialogID) {
        return DialogPreferences.prompt(6, parent, title, message, dialogID, 0x10000000);
    }

    public static int confirm(Shell parent, String title, String message, String dialogID) {
        return DialogPreferences.prompt(5, parent, title, message, dialogID, 0x10000000);
    }

    public static int prompt(int kind, Shell parent, String title, String message, String dialogID, int style) {
        int result = 1;
        IPreferenceStore store = DialogPreferences.getDialogTogglePreferenceStore();
        String preference = store.getString(dialogID);
        if (preference == null) {
            preference = "prompt";
        }
        block4 : switch (preference) {
            case "always": {
                switch (kind) {
                    case 3: 
                    case 6: {
                        result = 2;
                        break block4;
                    }
                }
                result = 0;
                break;
            }
            case "never": {
                switch (kind) {
                    case 3: 
                    case 6: {
                        result = 3;
                        break block4;
                    }
                }
                result = 1;
                break;
            }
            default: {
                MessageDialogWithToggle dialog = MessageDialogWithToggle.open((int)kind, (Shell)parent, (String)title, (String)message, null, (boolean)false, (IPreferenceStore)store, (String)dialogID, (int)style);
                result = dialog.getReturnCode();
            }
        }
        return result;
    }

    public static void clearDialogToggles() {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(DIALOG_TOGGLE_PATH);
        if (node != null) {
            try {
                node.removeNode();
            }
            catch (BackingStoreException e) {
                StatusAdapter adapter = new StatusAdapter((IStatus)new Status(4, "org.eclipse.papyrusrt.umlrt.common.ui", Messages.DialogPreferences_failedMsg, (Throwable)e));
                adapter.setProperty(IStatusAdapterConstants.TIMESTAMP_PROPERTY, (Object)System.currentTimeMillis());
                adapter.setProperty(IStatusAdapterConstants.TITLE_PROPERTY, (Object)Messages.DialogPreferences_failedTitle);
                StatusManager.getManager().handle(adapter, 2);
            }
        }
        DialogPreferences.getDelegateRegistry().getToggleDialogDelegates().forEach(d -> {
            try {
                d.clearUserDecisions();
            }
            catch (Exception e) {
                Activator.log.error("Uncaught exception in toggle-dialog delegate.", (Throwable)e);
            }
        });
    }

    private static ToggleDialogDelegateRegistry getDelegateRegistry() {
        if (delegateRegistry == null) {
            delegateRegistry = new ToggleDialogDelegateRegistry();
        }
        return delegateRegistry;
    }
}

