/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.extensionpoints.editors.ui;

import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IDirectEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.ui.LabelEditorDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ExtendedDirectEditionDialog
extends LabelEditorDialog {
    private static final String TITLE = "Edit Label";
    protected Object editedObject;
    protected Document document;
    protected String value;
    protected IDirectEditorConfiguration configuration;

    public ExtendedDirectEditionDialog(Shell parentShell, Object object, String initialValue, IDirectEditorConfiguration configuration) {
        super(parentShell, TITLE, initialValue, configuration.getInputValidator());
        this.editedObject = object;
        this.value = initialValue;
        this.configuration = configuration;
    }

    protected Control createDialogArea(Composite parent) {
        Group composite = new Group(parent, 16);
        composite.setText("Specification");
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Composite viewerGroup = new Composite((Composite)composite, 16);
        FillLayout viewerLayout = new FillLayout();
        viewerGroup.setLayout((Layout)viewerLayout);
        GridData data = new GridData(1796);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        viewerGroup.setLayoutData((Object)data);
        this.viewer = new SourceViewer(viewerGroup, null, 2049);
        this.document = new Document();
        this.document.set(this.value);
        this.viewer.appendVerifyKeyListener((VerifyKeyListener)new LabelKeyListener(this.viewer));
        this.document.addDocumentListener((IDocumentListener)new DocumentListener());
        this.viewer.configure(this.configuration.getSourceViewerConfiguration());
        this.viewer.setDocument((IDocument)this.document);
        IDirectEditorConfiguration.Selection selection = this.configuration.getTextSelection(this.value, this.editedObject);
        this.viewer.setSelectedRange(selection.getStart(), selection.getLentgh());
        Composite extendedArea = this.configuration.createExtendedDialogArea(viewerGroup);
        if (extendedArea != null) {
            extendedArea.setLayoutData((Object)new GridData(768));
        }
        this.errorMessageText = new CLabel((Composite)composite, 40);
        this.errorMessageText.setLayoutData((Object)new GridData(768));
        this.errorMessageText.setBackground(this.errorMessageText.getDisplay().getSystemColor(22));
        this.setErrorMessage(this.errorMessage);
        ExtendedDirectEditionDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private class DocumentListener
    implements IDocumentListener {
        private DocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            ExtendedDirectEditionDialog.this.validateInput();
        }
    }

    private class LabelKeyListener
    implements VerifyKeyListener {
        SourceViewer viewer;

        public LabelKeyListener(SourceViewer viewer) {
            this.viewer = viewer;
        }

        public void verifyKey(VerifyEvent event) {
            if (event.stateMask == 262144 && event.character == ' ') {
                if (this.viewer.canDoOperation(13)) {
                    this.viewer.doOperation(13);
                }
                event.doit = false;
            } else if (event.character == '\r') {
                event.doit = false;
            }
        }
    }
}

