/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.match.MatchOfContainmentReferenceChangeAdapter;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.filters.AbstractDifferenceFilter;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.tree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CascadingDifferencesFilter
extends AbstractDifferenceFilter {
    private static final Predicate<? super EObject> PREDICATE_WHEN_SELECTED = new Predicate<EObject>(){

        public boolean apply(EObject input) {
            TreeNode parent;
            Diff diff;
            TreeNode treeNode;
            EObject data;
            boolean ret = false;
            if (input instanceof TreeNode && (data = (treeNode = (TreeNode)input).getData()) instanceof Diff && !(data instanceof ResourceAttachmentChange) && (diff = (Diff)data).getKind() != DifferenceKind.MOVE && EMFComparePredicates.hasNoDirectOrIndirectConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL}).apply((Object)diff) && diff.getRefines().isEmpty() && (parent = treeNode.getParent()) != null && parent.getData() instanceof Match) {
                Match parentMatch = (Match)parent.getData();
                ret = this.isInsideAddOrDeleteTreeNode(diff, parent);
                if (!ret && this.isAddOrDeleteMatch(parentMatch, diff.getSource())) {
                    ret = !Predicates.and((Predicate)Predicates.or((Predicate)EMFComparePredicates.CONTAINMENT_REFERENCE_CHANGE, (Predicate)REFINED_BY_CONTAINMENT_REF_CHANGE), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD, (DifferenceKind)DifferenceKind.DELETE)).apply((Object)diff);
                }
            }
            return ret;
        }

        private boolean isInsideAddOrDeleteTreeNode(Diff diff, TreeNode parent) {
            Diff addOrDeleteDiff;
            boolean ret = false;
            DifferenceSource side = diff.getSource();
            TreeNode grandParent = parent.getParent();
            Match grandParentMatch = null;
            if (grandParent != null && grandParent.getData() instanceof Match) {
                grandParentMatch = (Match)grandParent.getData();
            }
            if (this.isAddOrDeleteMatch(grandParentMatch, side) && (addOrDeleteDiff = this.findAddOrDeleteDiff(grandParentMatch, side)) != null) {
                ret = diff.getRefinedBy().contains((Object)addOrDeleteDiff) ? this.isInsideAddOrDeleteTreeNode(diff, grandParent) : true;
            }
            return ret;
        }

        private Diff findAddOrDeleteDiff(Match match, DifferenceSource side) {
            UnmodifiableIterator sideChanges;
            Iterable addOrDeleteContainmentDiffs = MatchUtil.findAddOrDeleteContainmentDiffs((Match)match);
            if (addOrDeleteContainmentDiffs != null && (sideChanges = Iterators.filter(addOrDeleteContainmentDiffs.iterator(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)side))).hasNext()) {
                return (Diff)sideChanges.next();
            }
            return null;
        }

        protected boolean isAddOrDeleteMatch(Match match, DifferenceSource side) {
            if (match == null) {
                return false;
            }
            Adapter adapter = EcoreUtil.getAdapter((List)match.eAdapters(), MatchOfContainmentReferenceChangeAdapter.class);
            return adapter != null;
        }
    };
    private static final Predicate<Diff> REFINED_BY_CONTAINMENT_REF_CHANGE = new Predicate<Diff>(){

        public boolean apply(Diff input) {
            return Iterables.any((Iterable)input.getRefinedBy(), (Predicate)EMFComparePredicates.CONTAINMENT_REFERENCE_CHANGE);
        }
    };

    @Override
    public Predicate<? super EObject> getPredicateWhenSelected() {
        return PREDICATE_WHEN_SELECTED;
    }
}

