/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.provider;

import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.internal.EMFCompareEditMessages;
import org.eclipse.emf.compare.provider.ExtendedAdapterFactoryItemDelegator;
import org.eclipse.emf.compare.provider.IItemStyledLabelProvider;
import org.eclipse.emf.compare.provider.utils.ComposedStyledString;
import org.eclipse.emf.compare.provider.utils.IStyledString;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.StructureMergeViewerFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.provider.GroupItemProviderAdapter;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroup;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroupProvider;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.emf.edit.tree.provider.TreeNodeItemProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeNodeItemProviderSpec
extends TreeNodeItemProvider
implements IItemStyledLabelProvider,
IItemColorProvider,
IItemFontProvider {
    private Multimap<IDifferenceGroupProvider, GroupItemProviderAdapter> groupItemProviderAdapters;
    private StructureMergeViewerFilter structureMergeViewerFilter;

    public TreeNodeItemProviderSpec(AdapterFactory adapterFactory, StructureMergeViewerFilter structureMergeViewerFilter) {
        super(adapterFactory);
        this.structureMergeViewerFilter = structureMergeViewerFilter;
        this.itemDelegator = new ExtendedAdapterFactoryItemDelegator(this.getRootAdapterFactory());
    }

    public Object getParent(Object object) {
        Object parent = null;
        TreeNode treeNode = (TreeNode)object;
        TreeNode superParent = (TreeNode)super.getParent(object);
        if (superParent == null) {
            GroupItemProviderAdapter groupItemProvider = (GroupItemProviderAdapter)EcoreUtil.getExistingAdapter((Notifier)treeNode, GroupItemProviderAdapter.class);
            return groupItemProvider;
        }
        parent = object instanceof GroupItemProviderAdapter ? ((GroupItemProviderAdapter)((Object)object)).getParent(null) : superParent;
        return parent;
    }

    public Collection<?> getChildren(Object object) {
        TreeNode treeNode = (TreeNode)object;
        EObject data = treeNode.getData();
        if (data instanceof Comparison) {
            Comparison comparison;
            IDifferenceGroupProvider groupProvider = (IDifferenceGroupProvider)EcoreUtil.getExistingAdapter((Notifier)treeNode, IDifferenceGroupProvider.class);
            Collection<? extends IDifferenceGroup> groups = groupProvider.getGroups(comparison = (Comparison)data);
            if (groups.isEmpty()) {
                return ImmutableList.of();
            }
            if (groups.size() == 1) {
                return groups.iterator().next().getChildren();
            }
            if (this.groupItemProviderAdapters == null) {
                this.groupItemProviderAdapters = ArrayListMultimap.create();
                this.initMapping(groups, groupProvider, treeNode);
                return this.groupItemProviderAdapters.get((Object)groupProvider);
            }
            Collection adapters = this.groupItemProviderAdapters.get((Object)groupProvider);
            if (adapters.isEmpty()) {
                this.initMapping(groups, groupProvider, treeNode);
            }
            return adapters;
        }
        return super.getChildren(object);
    }

    protected void initMapping(Collection<? extends IDifferenceGroup> groups, IDifferenceGroupProvider groupProvider, TreeNode treeNode) {
        for (IDifferenceGroup iDifferenceGroup : groups) {
            this.groupItemProviderAdapters.put((Object)groupProvider, (Object)new GroupItemProviderAdapter(this.adapterFactory, (EObject)treeNode, iDifferenceGroup));
        }
    }

    public IStyledString.IComposedStyledString getStyledText(Object object) {
        IStyledString.IComposedStyledString treeNodeText;
        TreeNode treeNode = (TreeNode)object;
        EObject data = treeNode.getData();
        ComposedStyledString styledString = new ComposedStyledString();
        if (data instanceof Match) {
            Iterator eAllContents = Iterators.transform((Iterator)treeNode.eAllContents(), IDifferenceGroup.TREE_NODE_DATA);
            UnmodifiableIterator allDifferences = Iterators.filter((Iterator)eAllContents, Diff.class);
            if (Iterators.any((Iterator)allDifferences, (Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED}))) {
                styledString.append("> ", IStyledString.Style.DECORATIONS_STYLER);
            }
            treeNodeText = ((ExtendedAdapterFactoryItemDelegator)this.itemDelegator).getStyledText((Object)treeNode.getData());
        } else {
            treeNodeText = data instanceof Conflict ? this.getTreeNodeText(treeNode, (Conflict)data) : ((ExtendedAdapterFactoryItemDelegator)this.itemDelegator).getStyledText((Object)treeNode.getData());
        }
        return styledString.append(treeNodeText);
    }

    public Object getBackground(Object object) {
        TreeNode treeNode = (TreeNode)object;
        return this.itemDelegator.getBackground((Object)treeNode.getData());
    }

    public Object getForeground(Object object) {
        TreeNode treeNode = (TreeNode)object;
        return this.itemDelegator.getForeground((Object)treeNode.getData());
    }

    public Object getBackground(Object object, int columnIndex) {
        TreeNode treeNode = (TreeNode)object;
        return this.itemDelegator.getBackground((Object)treeNode.getData(), columnIndex);
    }

    public Object getForeground(Object object, int columnIndex) {
        TreeNode treeNode = (TreeNode)object;
        return this.itemDelegator.getForeground((Object)treeNode.getData(), columnIndex);
    }

    public Object getFont(Object object) {
        TreeNode treeNode = (TreeNode)object;
        return this.itemDelegator.getFont((Object)treeNode.getData());
    }

    public void dispose() {
        super.dispose();
        if (this.groupItemProviderAdapters != null) {
            this.groupItemProviderAdapters.clear();
        }
    }

    private IStyledString.IComposedStyledString getTreeNodeText(TreeNode treeNode, Conflict conflict) {
        ComposedStyledString ret = new ComposedStyledString();
        Assert.isNotNull((Object)((Object)this.structureMergeViewerFilter));
        Predicate<? super EObject> unfilteredNode = this.structureMergeViewerFilter.getAggregatedPredicate();
        UnmodifiableIterator visibleNodes = Iterators.filter((Iterator)treeNode.eAllContents(), unfilteredNode);
        Iterator eAllContents = Iterators.transform((Iterator)visibleNodes, IDifferenceGroup.TREE_NODE_DATA);
        UnmodifiableIterator allDifferences = Iterators.filter((Iterator)eAllContents, Diff.class);
        HashSet d = Sets.newHashSet((Iterator)allDifferences);
        int unresolvedDiffCount = Iterables.size((Iterable)Iterables.filter((Iterable)d, (Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED})));
        if (unresolvedDiffCount > 0) {
            ret.append("> ", IStyledString.Style.DECORATIONS_STYLER);
        }
        if (conflict.getKind() == ConflictKind.PSEUDO) {
            ret.append(EMFCompareEditMessages.getString((String)"pseudoconflict"));
        } else {
            ret.append(EMFCompareEditMessages.getString((String)"conflict"));
        }
        if (unresolvedDiffCount > 0) {
            ret.append(" [" + EMFCompareEditMessages.getString((String)"unresolved", (Object[])new Object[]{unresolvedDiffCount, d.size()}) + "]", IStyledString.Style.DECORATIONS_STYLER);
        } else {
            ret.append(" [" + EMFCompareEditMessages.getString((String)"resolved") + "]", IStyledString.Style.DECORATIONS_STYLER);
        }
        return ret;
    }
}

