/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.XmlStorageUtil;
import org.eclipse.cdt.make.core.IMakeCommonBuildInfo;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.cdt.make.internal.core.MakeTarget;
import org.eclipse.cdt.make.internal.core.MakeTargetManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;

public class ProjectTargets {
    private static final String MAKE_TARGET_KEY = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".buildtargets";
    private static final String TARGETS_EXT = "targets";
    private static final String BUILD_TARGET_ELEMENT = "buildTargets";
    private static final String TARGET_ELEMENT = "target";
    private static final String TARGET_ATTR_ID = "targetID";
    private static final String TARGET_ATTR_PATH = "path";
    private static final String TARGET_ATTR_NAME = "name";
    private static final String TARGET_STOP_ON_ERROR = "stopOnError";
    private static final String TARGET_USE_DEFAULT_CMD = "useDefaultCommand";
    private static final String TARGET_ARGUMENTS = "buildArguments";
    private static final String TARGET_COMMAND = "buildCommand";
    private static final String TARGET_RUN_ALL_BUILDERS = "runAllBuilders";
    private static final String BAD_TARGET = "buidlTarget";
    private static final String TARGET = "buildTarget";
    private HashMap<IContainer, List<IMakeTarget>> targetMap = new HashMap();
    private IProject project;

    public ProjectTargets(MakeTargetManager manager, IProject project) {
        boolean writeTargets = false;
        File targetFile = null;
        this.project = project;
        ICStorageElement rootElement = null;
        try {
            ICDescriptor descriptor = CCorePlugin.getDefault().getCProjectDescription(this.getProject(), true);
            rootElement = descriptor.getProjectStorageElement(MAKE_TARGET_KEY);
            if (rootElement.getChildren().length == 0) {
                IPath targetFilePath = MakeCorePlugin.getDefault().getStateLocation().append(project.getName()).addFileExtension(TARGETS_EXT);
                targetFile = targetFilePath.toFile();
                try {
                    FileInputStream input = new FileInputStream(targetFile);
                    ICStorageElement oldElement = this.translateInputStreamToDocument(input);
                    rootElement.importChild(oldElement);
                    writeTargets = true;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            this.extractMakeTargetsFromDocument(rootElement, manager);
            if (writeTargets) {
                this.saveTargets();
                if (targetFile != null) {
                    targetFile.delete();
                }
            }
        }
        catch (Exception e) {
            MakeCorePlugin.log(e);
        }
    }

    public IMakeTarget[] get(IContainer container) {
        List<IMakeTarget> list = this.targetMap.get(container);
        if (list != null) {
            return list.toArray(new IMakeTarget[list.size()]);
        }
        return new IMakeTarget[0];
    }

    public void set(IContainer container, IMakeTarget[] targets) throws CoreException {
        ArrayList<IMakeTarget> newList = new ArrayList<IMakeTarget>();
        IMakeTarget[] iMakeTargetArray = targets;
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            IMakeTarget target = iMakeTargetArray[n2];
            target.setContainer(container);
            if (newList.contains(target)) {
                throw new CoreException((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), -1, MakeMessages.getString("MakeTargetManager.target_exists"), null));
            }
            newList.add(target);
            ++n2;
        }
        this.targetMap.put(container, newList);
    }

    public IMakeTarget findTarget(IContainer container, String name) {
        List<IMakeTarget> list = this.targetMap.get(container);
        if (list != null) {
            for (IMakeTarget target : list) {
                if (!name.equals(target.getName())) continue;
                return target;
            }
        }
        return null;
    }

    public void add(IMakeTarget target) throws CoreException {
        List<IMakeTarget> list = this.targetMap.get(target.getContainer());
        if (list != null && list.contains(target)) {
            throw new CoreException((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), -1, MakeMessages.getString("MakeTargetManager.target_exists"), null));
        }
        if (list == null) {
            list = new ArrayList<IMakeTarget>();
            this.targetMap.put(target.getContainer(), list);
        }
        list.add(target);
    }

    public boolean contains(IMakeTarget target) {
        List<IMakeTarget> list = this.targetMap.get(target.getContainer());
        return list != null && list.contains(target);
    }

    public boolean remove(IMakeTarget target) {
        List<IMakeTarget> list = this.targetMap.get(target.getContainer());
        if (list == null || !list.contains(target)) {
            return false;
        }
        boolean found = list.remove(target);
        if (list.size() == 0) {
            this.targetMap.remove(list);
        }
        return found;
    }

    public IProject getProject() {
        return this.project;
    }

    private ICStorageElement createTargetElement(ICStorageElement parent, IMakeTarget target) {
        ICStorageElement targetElem = parent.createChild(TARGET_ELEMENT);
        targetElem.setAttribute(TARGET_ATTR_NAME, target.getName());
        targetElem.setAttribute(TARGET_ATTR_ID, target.getTargetBuilderID());
        targetElem.setAttribute(TARGET_ATTR_PATH, target.getContainer().getProjectRelativePath().toString());
        ICStorageElement elem = targetElem.createChild(TARGET_COMMAND);
        elem.setValue(target.getBuildAttribute(IMakeCommonBuildInfo.BUILD_COMMAND, "make"));
        String targetAttr = target.getBuildAttribute(IMakeCommonBuildInfo.BUILD_ARGUMENTS, null);
        if (targetAttr != null) {
            elem = targetElem.createChild(TARGET_ARGUMENTS);
            elem.setValue(targetAttr);
        }
        if ((targetAttr = target.getBuildAttribute(IMakeTarget.BUILD_TARGET, null)) != null) {
            elem = targetElem.createChild(TARGET);
            elem.setValue(targetAttr);
        }
        elem = targetElem.createChild(TARGET_STOP_ON_ERROR);
        elem.setValue(String.valueOf(target.isStopOnError()));
        elem = targetElem.createChild(TARGET_USE_DEFAULT_CMD);
        elem.setValue(String.valueOf(target.isDefaultBuildCmd()));
        elem = targetElem.createChild(TARGET_RUN_ALL_BUILDERS);
        elem.setValue(String.valueOf(target.runAllBuilders()));
        return targetElem;
    }

    public void saveTargets() throws CoreException {
        ICDescriptor descriptor = CCorePlugin.getDefault().getCProjectDescription(this.getProject(), true);
        ICStorageElement rootElement = descriptor.getProjectStorageElement(MAKE_TARGET_KEY);
        rootElement.clear();
        rootElement = rootElement.createChild(BUILD_TARGET_ELEMENT);
        for (Map.Entry<IContainer, List<IMakeTarget>> e : this.targetMap.entrySet()) {
            for (IMakeTarget target : e.getValue()) {
                this.createTargetElement(rootElement, target);
            }
        }
        descriptor.saveProjectData();
    }

    protected ICStorageElement translateInputStreamToDocument(InputStream input) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(input);
            return XmlStorageUtil.createCStorageTree((Document)document);
        }
        catch (Exception e) {
            MakeCorePlugin.log(e);
            return null;
        }
    }

    protected void extractMakeTargetsFromDocument(ICStorageElement root, MakeTargetManager manager) {
        ICStorageElement[] iCStorageElementArray = root.getChildren();
        int n = iCStorageElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICStorageElement node = iCStorageElementArray[n2];
            if (node.getName().equals(BUILD_TARGET_ELEMENT)) {
                ICStorageElement[] iCStorageElementArray2 = node.getChildren();
                int n3 = iCStorageElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    ICStorageElement child = iCStorageElementArray2[n4];
                    node = child;
                    if (node.getName().equals(TARGET_ELEMENT)) {
                        Object container = null;
                        String path = node.getAttribute(TARGET_ATTR_PATH);
                        container = path != null && !path.isEmpty() ? this.project.getFolder(path) : this.project;
                        try {
                            MakeTarget target = new MakeTarget(manager, this.project, node.getAttribute(TARGET_ATTR_ID), node.getAttribute(TARGET_ATTR_NAME));
                            target.setContainer((IContainer)container);
                            ICStorageElement[] option = node.getChildrenByName(TARGET_STOP_ON_ERROR);
                            if (option.length > 0) {
                                target.setStopOnError(Boolean.valueOf(option[0].getValue()));
                            }
                            if ((option = node.getChildrenByName(TARGET_USE_DEFAULT_CMD)).length > 0) {
                                target.setUseDefaultBuildCmd(Boolean.valueOf(option[0].getValue()));
                            }
                            if ((option = node.getChildrenByName(TARGET_COMMAND)).length > 0) {
                                target.setBuildAttribute(IMakeCommonBuildInfo.BUILD_COMMAND, option[0].getValue());
                            }
                            if ((option = node.getChildrenByName(TARGET_ARGUMENTS)).length > 0) {
                                target.setBuildAttribute(IMakeCommonBuildInfo.BUILD_ARGUMENTS, option[0].getValue());
                            } else if (!target.isDefaultBuildCmd()) {
                                target.setBuildAttribute(IMakeCommonBuildInfo.BUILD_ARGUMENTS, "");
                            }
                            option = node.getChildrenByName(BAD_TARGET);
                            if (option.length > 0) {
                                target.setBuildAttribute(IMakeTarget.BUILD_TARGET, option[0].getValue());
                            }
                            if ((option = node.getChildrenByName(TARGET)).length > 0) {
                                target.setBuildAttribute(IMakeTarget.BUILD_TARGET, option[0].getValue());
                            }
                            if ((option = node.getChildrenByName(TARGET_RUN_ALL_BUILDERS)).length > 0) {
                                target.setRunAllBuilders(Boolean.valueOf(option[0].getValue()));
                            }
                            this.add(target);
                        }
                        catch (CoreException e) {
                            MakeCorePlugin.log(e);
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }
}

