/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.internal.advice;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.papyrus.infra.properties.contexts.View;
import org.eclipse.papyrusrt.umlrt.tooling.types.umlrttypes.UMLRTSetTypeAdviceConfiguration;
import org.eclipse.papyrusrt.umlrt.tooling.ui.commands.InteractiveSetTypedElementTypeCommand;
import org.eclipse.uml2.uml.TypedElement;

public class UMLRTSetTypeAdvice
extends AbstractEditHelperAdvice {
    private String typeElementType;
    private java.util.function.Supplier<String> typeElementTypeLabel;
    private Set<View> newTypeViews;

    public UMLRTSetTypeAdvice(UMLRTSetTypeAdviceConfiguration adviceConfiguration) {
        this.typeElementType = adviceConfiguration.getElementType();
        this.typeElementTypeLabel = () -> ((Supplier)Suppliers.memoize(() -> ((UMLRTSetTypeAdviceConfiguration)adviceConfiguration).getElementTypeLabel())).get();
        this.newTypeViews = new HashSet<View>((Collection<View>)adviceConfiguration.getNewTypeViews());
    }

    public IElementType getTypeElementType() {
        IElementType result = null;
        if (this.typeElementType != null) {
            result = ElementTypeRegistry.getInstance().getType(this.typeElementType);
        }
        return result;
    }

    public Set<View> getNewTypeViews() {
        return Collections.unmodifiableSet(this.newTypeViews);
    }

    protected ICommand getAfterConfigureCommand(ConfigureRequest request) {
        InteractiveSetTypedElementTypeCommand result = null;
        IElementType typeElementType = this.getTypeElementType();
        if (typeElementType != null) {
            IElementType elementTypeToConfigure = request.getTypeToConfigure();
            EObject elementToConfigure = request.getElementToConfigure();
            TransactionalEditingDomain editingDomain = request.getEditingDomain();
            if (editingDomain != null && elementToConfigure instanceof TypedElement) {
                InteractiveSetTypedElementTypeCommand command;
                result = command = new InteractiveSetTypedElementTypeCommand((TypedElement)elementToConfigure, elementTypeToConfigure, typeElementType, this.getElementTypeLabel(request));
                command.setNewTypeViews(this.getNewTypeViews());
                command.setCreateNew(true);
            }
        }
        return result;
    }

    private Function<IElementType, String> getElementTypeLabel(ConfigureRequest request) {
        return type -> {
            String result = type == this.getTypeElementType() ? this.typeElementTypeLabel.get() : (type == request.getTypeToConfigure() ? type.getDisplayName() : type.getEClass().getName());
            return result;
        };
    }
}

