/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.modelelement;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.emf.utils.HistoryUtil;
import org.eclipse.papyrus.infra.properties.ui.providers.CreateInFeatureContentProvider;
import org.eclipse.papyrus.infra.properties.ui.providers.FeatureContentProvider;
import org.eclipse.papyrus.infra.ui.emf.providers.EMFGraphicalContentProvider;
import org.eclipse.papyrus.infra.ui.emf.providers.EMFLabelProvider;
import org.eclipse.papyrus.infra.ui.emf.utils.ProviderHelper;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.providers.DelegatingLabelProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.StaticContentProvider;
import org.eclipse.papyrus.infra.widgets.util.INameResolutionHelper;
import org.eclipse.papyrus.infra.widgets.util.IPapyrusConverter;
import org.eclipse.papyrus.uml.properties.modelelement.UMLModelElement;
import org.eclipse.papyrus.uml.tools.databinding.ExtendedMultiplicityObservableValue;
import org.eclipse.papyrus.uml.tools.databinding.NamedElementValidator;
import org.eclipse.papyrus.uml.tools.providers.UMLContainerContentProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLFilteredLabelProvider;
import org.eclipse.papyrusrt.umlrt.core.defaultlanguage.IDefaultLanguage;
import org.eclipse.papyrusrt.umlrt.core.internal.defaultlanguage.DefaultLanguageRegistry;
import org.eclipse.papyrusrt.umlrt.core.internal.defaultlanguage.NoDefautLanguage;
import org.eclipse.papyrusrt.umlrt.core.utils.CapsulePartUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.MessageSetUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.RTMessageUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.SystemElementsUtils;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.CapsulePart;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTMessageKind;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTMessageSet;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTPort;
import org.eclipse.papyrusrt.umlrt.tooling.ui.Activator;
import org.eclipse.papyrusrt.umlrt.tooling.ui.Messages;
import org.eclipse.papyrusrt.umlrt.tooling.ui.databinding.CompositeValidator;
import org.eclipse.papyrusrt.umlrt.tooling.ui.databinding.PapyrusRTObservableList;
import org.eclipse.papyrusrt.umlrt.tooling.ui.internal.modelelement.ChangeListenerUtils;
import org.eclipse.papyrusrt.umlrt.tooling.ui.internal.modelelement.MessageParameterTypeReferenceConverter;
import org.eclipse.papyrusrt.umlrt.tooling.ui.modelelement.RTPackageObservableValue;
import org.eclipse.papyrusrt.umlrt.tooling.ui.widgets.AbstractElementTypeBasedValueFactory;
import org.eclipse.papyrusrt.umlrt.tooling.ui.widgets.CapsulePartTypeValueFactory;
import org.eclipse.papyrusrt.umlrt.tooling.ui.widgets.MessageSetOwnedProtocolMessageValueFactory;
import org.eclipse.papyrusrt.umlrt.tooling.ui.widgets.PropertyReplicationObservableValue;
import org.eclipse.papyrusrt.umlrt.tooling.ui.widgets.RTPortTypeValueFactory;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.DirectedRelationship;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class UMLRTExtModelElement
extends UMLModelElement {
    private Hashtable<Element, UMLModelElement> delegationModelElements = new Hashtable();
    protected static final String OWNED_OPERATION = "ownedOperation";
    private final UMLRTExtModelElement owner;

    public UMLRTExtModelElement(EObject source) {
        this(source, (EditingDomain)TransactionUtil.getEditingDomain((EObject)source));
    }

    public UMLRTExtModelElement(EObject source, EditingDomain domain) {
        this(source, domain, null);
    }

    UMLRTExtModelElement(EObject source, EditingDomain domain, UMLRTExtModelElement owner) {
        super(source, domain);
        this.owner = owner;
    }

    public UMLModelElement getDelegationModelElement(Element element) {
        UMLModelElement delegationModelElement = this.delegationModelElements.get(element);
        if (delegationModelElement == null) {
            delegationModelElement = new UMLRTExtModelElement((EObject)element, this.getDomain(), this);
            this.delegationModelElements.put(element, delegationModelElement);
        }
        return delegationModelElement;
    }

    public IStaticContentProvider getContentProvider(String propertyPath) {
        Interface intf = this.getInOrInoutOrOutMessageSet(propertyPath);
        if (intf != null) {
            return this.getDelegationModelElement((Element)intf).getContentProvider(OWNED_OPERATION);
        }
        if (propertyPath.contains("RTmultiplicity")) {
            return new StaticContentProvider((Object[])new String[]{"1", "0..1"});
        }
        if (propertyPath.contains("language")) {
            ArrayList availableLanguages = new ArrayList(DefaultLanguageRegistry.getInstance().getLanguages());
            Collections.addAll(availableLanguages, NoDefautLanguage.INSTANCE);
            return new StaticContentProvider(availableLanguages.toArray());
        }
        if (propertyPath.contains("replication")) {
            return new StaticContentProvider((Object[])new String[]{"None (1)", "1", "*"});
        }
        return super.getContentProvider(propertyPath);
    }

    public boolean isOrdered(String propertyPath) {
        Interface intf = this.getInOrInoutOrOutMessageSet(propertyPath);
        if (intf != null) {
            return this.getDelegationModelElement((Element)intf).isOrdered(OWNED_OPERATION);
        }
        return super.isOrdered(propertyPath);
    }

    public boolean isMandatory(String propertyPath) {
        Interface intf = this.getInOrInoutOrOutMessageSet(propertyPath);
        if (intf != null) {
            return this.getDelegationModelElement((Element)intf).isMandatory(OWNED_OPERATION);
        }
        if (propertyPath.contains("language")) {
            return true;
        }
        if (UMLPackage.eINSTANCE.getTypedElement_Type().equals(this.getFeature(propertyPath)) && (this.source instanceof Property && CapsulePartUtils.isCapsulePart((Property)((Property)this.source)) || RTPortUtils.isRTPort((EObject)this.source) || RTMessageUtils.isRTMessageParameter((EObject)this.source))) {
            return true;
        }
        return super.isMandatory(propertyPath);
    }

    public ILabelProvider getLabelProvider(String propertyPath) {
        Interface intf = this.getInOrInoutOrOutMessageSet(propertyPath);
        if (intf != null) {
            return this.getDelegationModelElement((Element)intf).getLabelProvider(OWNED_OPERATION);
        }
        if (propertyPath.endsWith("language")) {
            return new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof IDefaultLanguage) {
                        return ((IDefaultLanguage)element).getName();
                    }
                    return super.getText(element);
                }
            };
        }
        EStructuralFeature feature = this.getFeature(propertyPath);
        if (feature == UMLPackage.Literals.TYPED_ELEMENT__TYPE && RTMessageUtils.isRTMessageParameter((EObject)this.source)) {
            ILabelProvider delegate = super.getLabelProvider(propertyPath);
            return new DelegatingLabelProvider(delegate){

                protected String customGetText(Object element) {
                    return element == null ? Messages.NoTypeForTypedElement_Label : null;
                }
            };
        }
        return super.getLabelProvider(propertyPath);
    }

    public EStructuralFeature getFeature(String propertyPath) {
        Interface intf = this.getInOrInoutOrOutMessageSet(propertyPath);
        if (intf != null) {
            return this.getDelegationModelElement((Element)intf).getFeature(OWNED_OPERATION);
        }
        return super.getFeature(propertyPath);
    }

    public FeaturePath getFeaturePath(String propertyPath) {
        Interface intf = this.getInOrInoutOrOutMessageSet(propertyPath);
        if (intf != null) {
            return this.getDelegationModelElement((Element)intf).getFeaturePath(OWNED_OPERATION);
        }
        return super.getFeaturePath(propertyPath);
    }

    public IObservable doGetObservable(String propertyPath) {
        Object observable = null;
        Interface intf = this.getInOrInoutOrOutMessageSet(propertyPath);
        if (intf != null) {
            observable = this.getDelegationModelElement((Element)intf).doGetObservable(OWNED_OPERATION);
        } else if (OWNED_OPERATION.equals(propertyPath)) {
            FeaturePath featurePath = this.getFeaturePath(propertyPath);
            EStructuralFeature feature = this.getFeature(propertyPath);
            observable = new PapyrusRTObservableList((List<?>)EMFProperties.list((FeaturePath)featurePath).observe((Object)this.source), this.domain, this.getSource(featurePath), feature);
        } else {
            observable = "RTmultiplicity".equals(propertyPath) ? new ExtendedMultiplicityObservableValue(this.source, this.domain) : ("language".equals(propertyPath) && this.domain instanceof TransactionalEditingDomain ? new RTPackageObservableValue((Package)this.source, (TransactionalEditingDomain)this.domain) : ("replication".equals(propertyPath) ? new PropertyReplicationObservableValue(this.source, (TransactionalEditingDomain)this.domain) : super.doGetObservable(propertyPath)));
        }
        if (this.getSource() instanceof RTPort) {
            observable.addChangeListener((IChangeListener)new UMLRTExtModelElementChangeListener());
        }
        return observable;
    }

    public ReferenceValueFactory getValueFactory(String propertyPath) {
        Interface intf = this.getInOrInoutOrOutMessageSet(propertyPath);
        if (intf != null) {
            return this.getDelegationModelElement((Element)intf).getValueFactory(propertyPath);
        }
        if (propertyPath.endsWith("type")) {
            AbstractElementTypeBasedValueFactory factory = null;
            EReference reference = UMLPackage.eINSTANCE.getTypedElement_Type();
            EClass type = reference.getEReferenceType();
            if (this.source instanceof Port) {
                factory = new RTPortTypeValueFactory(reference);
            } else if (this.source instanceof Property) {
                factory = new CapsulePartTypeValueFactory(reference);
            } else {
                if (RTMessageUtils.isRTMessageParameter((EObject)this.source)) {
                    return null;
                }
                return super.getValueFactory(propertyPath);
            }
            factory.setContainerLabelProvider((ILabelProvider)new UMLFilteredLabelProvider());
            factory.setReferenceLabelProvider((ILabelProvider)new EMFLabelProvider());
            UMLContainerContentProvider contentProvider = new UMLContainerContentProvider(this.source, reference);
            ResourceSet rs = this.source == null ? null : (this.source.eResource() == null ? null : this.source.eResource().getResourceSet());
            EMFGraphicalContentProvider provider = ProviderHelper.encapsulateProvider((ITreeContentProvider)contentProvider, (ResourceSet)rs, (String)HistoryUtil.getHistoryID((EObject)this.source, (EStructuralFeature)reference, (String)"container"));
            factory.setContainerContentProvider((IStaticContentProvider)provider);
            factory.setReferenceContentProvider((CreateInFeatureContentProvider)new FeatureContentProvider(type));
            return factory;
        }
        if (propertyPath.endsWith("Incoming") || propertyPath.endsWith("Outgoing") || propertyPath.endsWith("InOut")) {
            MessageSetOwnedProtocolMessageValueFactory factory = null;
            EReference reference = UMLPackage.eINSTANCE.getInterface_OwnedOperation();
            EClass type = reference.getEReferenceType();
            if (!(this.source instanceof Interface) || !MessageSetUtils.isRTMessageSet((Element)((Interface)this.source))) {
                return super.getValueFactory(propertyPath);
            }
            factory = new MessageSetOwnedProtocolMessageValueFactory(reference, (IObservableList)this.owner.getObservable(propertyPath)).setDirection(MessageSetUtils.getMessageKind((Object)this.source));
            factory.setContainerLabelProvider((ILabelProvider)new UMLFilteredLabelProvider());
            factory.setReferenceLabelProvider((ILabelProvider)new EMFLabelProvider());
            UMLContainerContentProvider contentProvider = new UMLContainerContentProvider(this.source, reference);
            ResourceSet rs = this.source == null ? null : (this.source.eResource() == null ? null : this.source.eResource().getResourceSet());
            EMFGraphicalContentProvider provider = ProviderHelper.encapsulateProvider((ITreeContentProvider)contentProvider, (ResourceSet)rs, (String)HistoryUtil.getHistoryID((EObject)this.source, (EStructuralFeature)reference, (String)"container"));
            factory.setContainerContentProvider((IStaticContentProvider)provider);
            factory.setReferenceContentProvider((CreateInFeatureContentProvider)new FeatureContentProvider(type));
            return factory;
        }
        return super.getValueFactory(propertyPath);
    }

    protected Interface getInOrInoutOrOutMessageSet(String propertyPath) {
        Interface result = null;
        if (this.source instanceof Collaboration) {
            if (propertyPath.endsWith("Incoming")) {
                result = this.getInterface(RTMessageKind.IN);
            } else if (propertyPath.endsWith("Outgoing")) {
                result = this.getInterface(RTMessageKind.OUT);
            } else if (propertyPath.endsWith("InOut")) {
                result = this.getInterface(RTMessageKind.IN_OUT);
            }
        }
        return result;
    }

    public boolean forceRefresh(String propertyPath) {
        return true;
    }

    protected boolean isFeatureEditable(String propertyPath) {
        boolean editable = false;
        EStructuralFeature feature = this.getFeature(propertyPath);
        if (this.source instanceof Transition) {
            return true;
        }
        if (this.source instanceof Port) {
            Port port = (Port)this.source;
            boolean isSystemProtocol = false;
            Type type = port.getType();
            if (type instanceof Collaboration && SystemElementsUtils.isSystemProtocol((Collaboration)((Collaboration)type))) {
                isSystemProtocol = true;
            }
            if ("replication".equals(propertyPath)) {
                editable = true;
            } else if (UMLPackage.eINSTANCE.getPort_IsConjugated().equals(feature)) {
                editable = isSystemProtocol ? false : super.isFeatureEditable(propertyPath);
            } else if ("type".equals(propertyPath)) {
                editable = super.isFeatureEditable(propertyPath);
            } else if (RTPortUtils.isRTPort((EObject)this.source)) {
                RTPort rtPort = RTPortUtils.getStereotypeApplication((Port)port);
                if (UMLPackage.eINSTANCE.getPort_IsService().equals(feature)) {
                    editable = isSystemProtocol ? false : !RTPortUtils.isConnected((Port)port) && port.isBehavior();
                } else if (UMLPackage.eINSTANCE.getPort_IsBehavior().equals(feature)) {
                    editable = isSystemProtocol ? false : !(!rtPort.isWired() || rtPort.isWired() && !port.isService() || rtPort.isWired() && port.isService() && !port.isBehavior() && RTPortUtils.isConnectedInside((Port)port));
                }
            } else {
                editable = super.isFeatureEditable(propertyPath);
            }
        } else if (this.source instanceof Property) {
            editable = UMLUtil.getStereotypeApplication((Element)((Element)this.source), CapsulePart.class) != null ? true : super.isFeatureEditable(propertyPath);
        } else if (this.isCollaborationOrClass(this.source)) {
            editable = super.isFeatureEditable(propertyPath);
        } else if (this.source instanceof Parameter) {
            editable = super.isFeatureEditable(propertyPath);
        } else if (this.source instanceof Package) {
            editable = propertyPath.endsWith("language") ? true : super.isFeatureEditable(propertyPath);
        }
        return editable;
    }

    public boolean getDirectCreation(String propertyPath) {
        EStructuralFeature feature = this.getFeature(propertyPath);
        boolean result = feature == UMLPackage.Literals.TYPED_ELEMENT__TYPE ? !RTMessageUtils.isRTMessageParameter((EObject)this.source) : super.getDirectCreation(propertyPath);
        return result;
    }

    protected Interface getInterface(RTMessageKind rtMessageKind) {
        Interface result = null;
        Collaboration protocol = (Collaboration)this.source;
        Iterator relationshipIterator = protocol.getSourceDirectedRelationships().iterator();
        while (relationshipIterator.hasNext() && result == null) {
            DirectedRelationship directedRelation = (DirectedRelationship)relationshipIterator.next();
            if (!(directedRelation instanceof Dependency)) continue;
            result = this.getInterfaceFromDepencies(rtMessageKind, directedRelation);
        }
        return result;
    }

    protected Interface getInterfaceFromDepencies(RTMessageKind rtMessageKind, DirectedRelationship directedRelation) {
        Interface matchingInterface = null;
        Dependency dependency = (Dependency)directedRelation;
        Iterator dependencyIterator = dependency.getSuppliers().iterator();
        while (dependencyIterator.hasNext() && matchingInterface == null) {
            Interface interfaceImpl;
            RTMessageSet rtMessageSet;
            NamedElement supplier = (NamedElement)dependencyIterator.next();
            if (!(supplier instanceof Interface) || (rtMessageSet = (RTMessageSet)UMLUtil.getStereotypeApplication((Element)(interfaceImpl = (Interface)supplier), RTMessageSet.class)) == null || rtMessageSet.getRtMsgKind() != rtMessageKind) continue;
            matchingInterface = (Interface)supplier;
        }
        return matchingInterface;
    }

    public IValidator getValidator(String propertyPath) {
        IValidator result = super.getValidator(propertyPath);
        if (propertyPath.matches("\\bname$") && this.isCollaborationOrClass(this.source)) {
            result = CompositeValidator.of(result, value -> {
                boolean valid = value instanceof String && !((String)value).trim().isEmpty();
                return valid ? Status.OK_STATUS : new Status(4, "org.eclipse.papyrusrt.umlrt.tooling.ui", "Name is required");
            });
            if (ProtocolUtils.isProtocol((EObject)this.source).booleanValue()) {
                result = CompositeValidator.of(result, value -> {
                    NamedElementValidator packageValidator = new NamedElementValidator((EObject)ProtocolUtils.getProtocolContainer((Collaboration)((Collaboration)this.source)));
                    return packageValidator.validate(value);
                });
            }
        }
        if ("replication".equals(propertyPath)) {
            result = CompositeValidator.of(result, new IValidator(){

                public IStatus validate(Object value) {
                    if (((String)value).matches("-\\d*.?\\d+|\\d*\\.\\d+")) {
                        return new Status(4, "org.eclipse.papyrusrt.umlrt.tooling.ui", "Only positive Integers are allowed");
                    }
                    if (((String)value).contains("..")) {
                        return new Status(4, "org.eclipse.papyrusrt.umlrt.tooling.ui", ".. notation is not allowed");
                    }
                    return Status.OK_STATUS;
                }
            });
        }
        return result;
    }

    private boolean isCollaborationOrClass(EObject object) {
        return object instanceof Collaboration || object instanceof Class;
    }

    public IPapyrusConverter getPapyrusConverter(String propertyPath) {
        Object result;
        EStructuralFeature feature = this.getFeature(propertyPath);
        if (feature == UMLPackage.Literals.TYPED_ELEMENT__TYPE) {
            if (RTMessageUtils.isRTMessageParameter((EObject)this.source)) {
                INameResolutionHelper helper = this.getNameResolutionHelper(propertyPath);
                result = new MessageParameterTypeReferenceConverter(helper);
            } else {
                result = super.getPapyrusConverter(propertyPath);
            }
        } else {
            result = super.getPapyrusConverter(propertyPath);
        }
        return result;
    }

    public class UMLRTExtModelElementChangeListener
    implements IChangeListener {
        public void handleChange(ChangeEvent event) {
            try {
                ChangeListenerUtils.fireDataSourceChanged(UMLRTExtModelElement.this.dataSource);
            }
            catch (IllegalAccessException | NoSuchMethodException | RuntimeException | InvocationTargetException e) {
                Activator.log.debug(e.getMessage());
            }
        }
    }
}

